/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ionpathextraction;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonType;
import software.amazon.ionpathextraction.PathExtractor;
import software.amazon.ionpathextraction.PathExtractorConfig;
import software.amazon.ionpathextraction.SearchPath;
import software.amazon.ionpathextraction.pathcomponents.PathComponent;
import software.amazon.ionpathextraction.utils.Preconditions;

class PathExtractorImpl<T>
implements PathExtractor<T> {
    private final PathExtractorConfig config;
    private final List<SearchPath<T>> searchPaths;
    private final int maxSearchPathDepth;

    PathExtractorImpl(List<SearchPath<T>> searchPaths, PathExtractorConfig config) {
        this.searchPaths = searchPaths;
        this.config = config;
        this.maxSearchPathDepth = searchPaths.stream().mapToInt(sp -> sp.getPathComponents().size()).max().orElse(0);
    }

    @Override
    public void match(IonReader reader) {
        this.match(reader, null);
    }

    @Override
    public void match(IonReader reader, T context) {
        Preconditions.checkArgument(reader.getDepth() == 0 || this.config.isMatchRelativePaths(), "reader must be at depth zero, it was at:" + reader.getDepth());
        if (this.searchPaths.isEmpty()) {
            return;
        }
        Tracker<T> tracker = new Tracker<T>(this.maxSearchPathDepth, this.searchPaths, reader.getDepth());
        this.matchRecursive(reader, tracker, context);
    }

    private int matchRecursive(IonReader reader, Tracker<T> tracker, T context) {
        int currentDepth = tracker.getCurrentDepth();
        int ordinal = 0;
        while (reader.next() != null) {
            ArrayList partialMatches = new ArrayList();
            for (SearchPath<T> sp : tracker.activePaths()) {
                int stepOutTimes;
                boolean match = this.pathComponentMatches(sp, reader, tracker.getCurrentDepth(), ordinal);
                boolean isTerminal = this.isTerminal(tracker.getCurrentDepth(), sp);
                if (match && isTerminal && (stepOutTimes = this.invokeCallback(reader, sp, tracker.getInitialReaderDepth(), context)) > 0) {
                    return stepOutTimes - 1;
                }
                if (isTerminal || currentDepth != 0 && !match) continue;
                partialMatches.add(sp);
            }
            if (IonType.isContainer((IonType)reader.getType()) && !partialMatches.isEmpty()) {
                tracker.push(partialMatches);
                reader.stepIn();
                int stepOutTimes = this.matchRecursive(reader, tracker, context);
                reader.stepOut();
                tracker.pop();
                if (stepOutTimes > 0) {
                    return stepOutTimes - 1;
                }
            }
            ++ordinal;
        }
        return 0;
    }

    private int invokeCallback(IonReader reader, SearchPath<T> searchPath, int initialReaderDepth, T context) {
        int previousReaderDepth = reader.getDepth();
        int stepOutTimes = searchPath.getCallback().apply(reader, (IonReader)context);
        int newReaderDepth = reader.getDepth();
        Preconditions.checkState(previousReaderDepth == newReaderDepth, "Reader must be at same depth when returning from callbacks. initial: " + previousReaderDepth + ", new: " + newReaderDepth);
        int readerRelativeDepth = reader.getDepth() - initialReaderDepth;
        Preconditions.checkState(stepOutTimes <= readerRelativeDepth, "Callback return cannot be greater than the reader current relative depth. return: " + stepOutTimes + ", relative reader depth: " + readerRelativeDepth);
        return stepOutTimes;
    }

    private boolean pathComponentMatches(SearchPath<T> searchPath, IonReader reader, int currentDepth, int currentPosition) {
        List<PathComponent> pathComponents = searchPath.getPathComponents();
        if (currentDepth == 0) {
            return pathComponents.isEmpty();
        }
        if (currentDepth <= pathComponents.size()) {
            return pathComponents.get(currentDepth - 1).matches(reader, currentPosition, this.config);
        }
        return false;
    }

    private boolean isTerminal(int currentDepth, SearchPath searchPath) {
        return currentDepth == searchPath.getPathComponents().size();
    }

    private static class Tracker<T> {
        private final Deque<List<SearchPath<T>>> stack;
        private int initialReaderDepth;

        Tracker(int size, List<SearchPath<T>> searchPaths, int initialReaderDepth) {
            this.stack = new ArrayDeque<List<SearchPath<T>>>(size);
            this.stack.push(searchPaths);
            this.initialReaderDepth = initialReaderDepth;
        }

        List<SearchPath<T>> activePaths() {
            return this.stack.peek();
        }

        int getCurrentDepth() {
            return this.stack.size() - 1;
        }

        void push(List<SearchPath<T>> partialMatches) {
            this.stack.push(partialMatches);
        }

        void pop() {
            this.stack.pop();
        }

        int getInitialReaderDepth() {
            return this.initialReaderDepth;
        }
    }
}

