/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.serializers;

import com.amazonaws.services.schemaregistry.common.GlueSchemaRegistryCompressionFactory;
import com.amazonaws.services.schemaregistry.common.GlueSchemaRegistryCompressionHandler;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;

public class SerializationDataEncoder {
    private final GlueSchemaRegistryCompressionHandler compressionHandler;
    private final GlueSchemaRegistryConfiguration schemaRegistrySerDeConfigs;

    public SerializationDataEncoder(GlueSchemaRegistryConfiguration schemaRegistrySerDeConfigs) {
        this.schemaRegistrySerDeConfigs = schemaRegistrySerDeConfigs;
        this.compressionHandler = new GlueSchemaRegistryCompressionFactory().getCompressionHandler(schemaRegistrySerDeConfigs.getCompressionType());
    }

    public byte[] write(byte[] objectBytes, UUID schemaVersionId) {
        byte[] bytes;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            this.writeHeaderVersionBytes(out);
            this.writeCompressionBytes(out);
            this.writeSchemaVersionId(out, schemaVersionId);
            boolean shouldCompress = this.compressionHandler != null;
            bytes = this.writeToExistingStream(out, shouldCompress ? this.compressData(objectBytes) : objectBytes);
        }
        catch (Exception e) {
            throw new AWSSchemaRegistryException(e.getMessage(), (Throwable)e);
        }
        return bytes;
    }

    private void writeCompressionBytes(ByteArrayOutputStream out) {
        out.write(this.compressionHandler != null ? 5 : 0);
    }

    private void writeHeaderVersionBytes(ByteArrayOutputStream out) {
        out.write(3);
    }

    private void writeSchemaVersionId(ByteArrayOutputStream out, UUID schemaVersionId) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
        buffer.putLong(schemaVersionId.getMostSignificantBits());
        buffer.putLong(schemaVersionId.getLeastSignificantBits());
        out.write(buffer.array());
    }

    private byte[] compressData(byte[] actualDataBytes) throws IOException {
        return this.compressionHandler.compress(actualDataBytes);
    }

    private byte[] writeToExistingStream(ByteArrayOutputStream toStream, byte[] fromStream) throws IOException {
        toStream.write(fromStream);
        return toStream.toByteArray();
    }
}

