/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.deserializers.json;

import com.amazonaws.services.schemaregistry.common.GlueSchemaRegistryDataFormatDeserializer;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.deserializers.GlueSchemaRegistryDeserializerDataParser;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import com.amazonaws.services.schemaregistry.serializers.json.JsonDataWithSchema;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonDeserializer
implements GlueSchemaRegistryDataFormatDeserializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonDeserializer.class);
    private static final GlueSchemaRegistryDeserializerDataParser DESERIALIZER_DATA_PARSER = GlueSchemaRegistryDeserializerDataParser.getInstance();
    private final ObjectMapper objectMapper;
    private GlueSchemaRegistryConfiguration schemaRegistrySerDeConfigs;

    public JsonDeserializer(GlueSchemaRegistryConfiguration configs) {
        this.schemaRegistrySerDeConfigs = configs;
        JsonNodeFactory jsonNodeFactory = JsonNodeFactory.withExactBigDecimals((boolean)true);
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setNodeFactory(jsonNodeFactory);
        if (configs != null) {
            if (!CollectionUtils.isEmpty((Collection)configs.getJacksonSerializationFeatures())) {
                configs.getJacksonSerializationFeatures().forEach(arg_0 -> ((ObjectMapper)this.objectMapper).enable(arg_0));
            }
            if (!CollectionUtils.isEmpty((Collection)configs.getJacksonDeserializationFeatures())) {
                configs.getJacksonDeserializationFeatures().forEach(arg_0 -> ((ObjectMapper)this.objectMapper).enable(arg_0));
            }
        }
    }

    public Object deserialize(@NonNull ByteBuffer buffer, @NonNull String schema) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer is marked non-null but is null");
        }
        if (schema == null) {
            throw new IllegalArgumentException("schema is marked non-null but is null");
        }
        try {
            Object deserializedObject;
            byte[] data = DESERIALIZER_DATA_PARSER.getPlainData(buffer);
            log.debug("Length of actual message: {}", (Object)data.length);
            JsonNode schemaNode = this.objectMapper.readTree(schema);
            JsonNode classNameNode = schemaNode.get("className");
            if (classNameNode != null) {
                String className = classNameNode.asText();
                deserializedObject = this.objectMapper.readValue(data, Class.forName(className));
            } else {
                JsonNode dataNode = this.objectMapper.readTree(data);
                deserializedObject = JsonDataWithSchema.builder(schemaNode.toString(), dataNode.toString()).build();
            }
            return deserializedObject;
        }
        catch (IOException | ClassNotFoundException e) {
            String message = String.format("Exception occurred while de-serializing JSON message.", new Object[0]);
            throw new AWSSchemaRegistryException(message, (Throwable)e);
        }
    }

    @Generated
    public static JsonDeserializerBuilder builder() {
        return new JsonDeserializerBuilder();
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonDeserializer)) {
            return false;
        }
        JsonDeserializer other = (JsonDeserializer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ObjectMapper this$objectMapper = this.getObjectMapper();
        ObjectMapper other$objectMapper = other.getObjectMapper();
        if (this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper)) {
            return false;
        }
        GlueSchemaRegistryConfiguration this$schemaRegistrySerDeConfigs = this.getSchemaRegistrySerDeConfigs();
        GlueSchemaRegistryConfiguration other$schemaRegistrySerDeConfigs = other.getSchemaRegistrySerDeConfigs();
        return !(this$schemaRegistrySerDeConfigs == null ? other$schemaRegistrySerDeConfigs != null : !this$schemaRegistrySerDeConfigs.equals(other$schemaRegistrySerDeConfigs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JsonDeserializer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ObjectMapper $objectMapper = this.getObjectMapper();
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        GlueSchemaRegistryConfiguration $schemaRegistrySerDeConfigs = this.getSchemaRegistrySerDeConfigs();
        result = result * 59 + ($schemaRegistrySerDeConfigs == null ? 43 : $schemaRegistrySerDeConfigs.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JsonDeserializer(objectMapper=" + this.getObjectMapper() + ", schemaRegistrySerDeConfigs=" + this.getSchemaRegistrySerDeConfigs() + ")";
    }

    @Generated
    public GlueSchemaRegistryConfiguration getSchemaRegistrySerDeConfigs() {
        return this.schemaRegistrySerDeConfigs;
    }

    @Generated
    public void setSchemaRegistrySerDeConfigs(GlueSchemaRegistryConfiguration schemaRegistrySerDeConfigs) {
        this.schemaRegistrySerDeConfigs = schemaRegistrySerDeConfigs;
    }

    @Generated
    public static class JsonDeserializerBuilder {
        @Generated
        private GlueSchemaRegistryConfiguration configs;

        @Generated
        JsonDeserializerBuilder() {
        }

        @Generated
        public JsonDeserializerBuilder configs(GlueSchemaRegistryConfiguration configs) {
            this.configs = configs;
            return this;
        }

        @Generated
        public JsonDeserializer build() {
            return new JsonDeserializer(this.configs);
        }

        @Generated
        public String toString() {
            return "JsonDeserializer.JsonDeserializerBuilder(configs=" + this.configs + ")";
        }
    }
}

