/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.serializers;

import com.amazonaws.services.schemaregistry.caching.GlueSchemaRegistryCache;
import com.amazonaws.services.schemaregistry.caching.GlueSchemaRegistrySerializerCache;
import com.amazonaws.services.schemaregistry.common.AWSSchemaRegistryClient;
import com.amazonaws.services.schemaregistry.common.AWSSchemaRegistryGlueClientRetryPolicyHelper;
import com.amazonaws.services.schemaregistry.common.AWSSerializerInput;
import com.amazonaws.services.schemaregistry.common.GlueSchemaRegistryDataFormatSerializer;
import com.amazonaws.services.schemaregistry.common.Schema;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import com.amazonaws.services.schemaregistry.serializers.GlueSchemaRegistrySerializerFactory;
import com.amazonaws.services.schemaregistry.serializers.SerializationDataEncoder;
import com.google.common.cache.CacheStats;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.glue.model.DataFormat;

public class GlueSchemaRegistrySerializationFacade {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlueSchemaRegistrySerializationFacade.class);
    private AWSSchemaRegistryClient awsSchemaRegistryClient;
    private SerializationDataEncoder serializationDataEncoder;
    private GlueSchemaRegistryConfiguration glueSchemaRegistryConfiguration;
    private GlueSchemaRegistrySerializerFactory glueSchemaRegistrySerializerFactory = new GlueSchemaRegistrySerializerFactory();
    private GlueSchemaRegistryCache<Schema, UUID, CacheStats> cache;

    public GlueSchemaRegistrySerializationFacade(@NonNull AwsCredentialsProvider credentialProvider, AWSSchemaRegistryClient schemaRegistryClient, GlueSchemaRegistryConfiguration glueSchemaRegistryConfiguration, Map<String, ?> configs, Properties properties) {
        if (credentialProvider == null) {
            throw new IllegalArgumentException("credentialProvider is marked non-null but is null");
        }
        if (glueSchemaRegistryConfiguration != null) {
            this.glueSchemaRegistryConfiguration = glueSchemaRegistryConfiguration;
        } else if (configs != null) {
            this.glueSchemaRegistryConfiguration = new GlueSchemaRegistryConfiguration(configs);
        } else if (properties != null) {
            this.glueSchemaRegistryConfiguration = new GlueSchemaRegistryConfiguration(properties);
        } else {
            throw new AWSSchemaRegistryException("Configuration map and properties cannot be null");
        }
        this.awsSchemaRegistryClient = schemaRegistryClient != null ? schemaRegistryClient : new AWSSchemaRegistryClient(credentialProvider, this.glueSchemaRegistryConfiguration, AWSSchemaRegistryGlueClientRetryPolicyHelper.getRetryPolicy());
        this.serializationDataEncoder = new SerializationDataEncoder(this.glueSchemaRegistryConfiguration);
        this.cache = GlueSchemaRegistrySerializerCache.getInstance((GlueSchemaRegistryConfiguration)this.glueSchemaRegistryConfiguration);
    }

    public UUID getOrRegisterSchemaVersion(@NonNull AWSSerializerInput serializerInput) {
        if (serializerInput == null) {
            throw new IllegalArgumentException("serializerInput is marked non-null but is null");
        }
        String schemaDefinition = serializerInput.getSchemaDefinition();
        String schemaName = serializerInput.getSchemaName();
        String transportName = serializerInput.getTransportName();
        String dataFormat = serializerInput.getDataFormat();
        Schema key = new Schema(schemaDefinition, dataFormat, schemaName);
        Map<String, String> metadata = this.constructSchemaVersionMetadata(transportName);
        UUID schemaVersionId = (UUID)this.cache.get((Object)key);
        if (schemaVersionId == null) {
            schemaVersionId = this.awsSchemaRegistryClient.getORRegisterSchemaVersionId(schemaDefinition, schemaName, dataFormat, metadata);
            this.cache.put((Object)key, (Object)schemaVersionId);
            log.debug("Cache stats {}", this.cache.getCacheStats());
        }
        return schemaVersionId;
    }

    private Map<String, String> constructSchemaVersionMetadata(String transportName) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("x-amz-meta-transport", transportName);
        if (this.glueSchemaRegistryConfiguration.getMetadata() != null) {
            metadata.putAll(this.glueSchemaRegistryConfiguration.getMetadata());
        }
        return metadata;
    }

    public byte[] serialize(DataFormat dataFormat, @NonNull Object data, @NonNull UUID schemaVersionId) {
        if (data == null) {
            throw new IllegalArgumentException("data is marked non-null but is null");
        }
        if (schemaVersionId == null) {
            throw new IllegalArgumentException("schemaVersionId is marked non-null but is null");
        }
        GlueSchemaRegistryDataFormatSerializer dataFormatSerializer = this.glueSchemaRegistrySerializerFactory.getInstance(dataFormat, this.glueSchemaRegistryConfiguration);
        byte[] serializedBytes = dataFormatSerializer.serialize(data);
        return this.serializationDataEncoder.write(serializedBytes, schemaVersionId);
    }

    public byte[] encode(String transportName, Schema schema, byte[] data) {
        String dataFormat = schema.getDataFormat();
        String schemaDefinition = schema.getSchemaDefinition();
        String schemaName = schema.getSchemaName();
        GlueSchemaRegistryDataFormatSerializer dataFormatSerializer = this.glueSchemaRegistrySerializerFactory.getInstance(DataFormat.valueOf((String)dataFormat), this.glueSchemaRegistryConfiguration);
        dataFormatSerializer.validate(schemaDefinition, data);
        UUID schemaVersionId = this.getOrRegisterSchemaVersion(AWSSerializerInput.builder().schemaDefinition(schemaDefinition).schemaName(schemaName).dataFormat(dataFormat).transportName(transportName).build());
        return this.serializationDataEncoder.write(data, schemaVersionId);
    }

    public String getSchemaDefinition(DataFormat dataFormat, @NonNull Object data) {
        if (data == null) {
            throw new IllegalArgumentException("data is marked non-null but is null");
        }
        GlueSchemaRegistryDataFormatSerializer dataFormatSerializer = this.glueSchemaRegistrySerializerFactory.getInstance(dataFormat, this.glueSchemaRegistryConfiguration);
        return dataFormatSerializer.getSchemaDefinition(data);
    }

    @Generated
    public static GlueSchemaRegistrySerializationFacadeBuilder builder() {
        return new GlueSchemaRegistrySerializationFacadeBuilder();
    }

    @Generated
    public void setCache(GlueSchemaRegistryCache<Schema, UUID, CacheStats> cache) {
        this.cache = cache;
    }

    @Generated
    public GlueSchemaRegistryCache<Schema, UUID, CacheStats> getCache() {
        return this.cache;
    }

    @Generated
    public static class GlueSchemaRegistrySerializationFacadeBuilder {
        @Generated
        private AwsCredentialsProvider credentialProvider;
        @Generated
        private AWSSchemaRegistryClient schemaRegistryClient;
        @Generated
        private GlueSchemaRegistryConfiguration glueSchemaRegistryConfiguration;
        @Generated
        private Map<String, ?> configs;
        @Generated
        private Properties properties;

        @Generated
        GlueSchemaRegistrySerializationFacadeBuilder() {
        }

        @Generated
        public GlueSchemaRegistrySerializationFacadeBuilder credentialProvider(@NonNull AwsCredentialsProvider credentialProvider) {
            if (credentialProvider == null) {
                throw new IllegalArgumentException("credentialProvider is marked non-null but is null");
            }
            this.credentialProvider = credentialProvider;
            return this;
        }

        @Generated
        public GlueSchemaRegistrySerializationFacadeBuilder schemaRegistryClient(AWSSchemaRegistryClient schemaRegistryClient) {
            this.schemaRegistryClient = schemaRegistryClient;
            return this;
        }

        @Generated
        public GlueSchemaRegistrySerializationFacadeBuilder glueSchemaRegistryConfiguration(GlueSchemaRegistryConfiguration glueSchemaRegistryConfiguration) {
            this.glueSchemaRegistryConfiguration = glueSchemaRegistryConfiguration;
            return this;
        }

        @Generated
        public GlueSchemaRegistrySerializationFacadeBuilder configs(Map<String, ?> configs) {
            this.configs = configs;
            return this;
        }

        @Generated
        public GlueSchemaRegistrySerializationFacadeBuilder properties(Properties properties) {
            this.properties = properties;
            return this;
        }

        @Generated
        public GlueSchemaRegistrySerializationFacade build() {
            return new GlueSchemaRegistrySerializationFacade(this.credentialProvider, this.schemaRegistryClient, this.glueSchemaRegistryConfiguration, this.configs, this.properties);
        }

        @Generated
        public String toString() {
            return "GlueSchemaRegistrySerializationFacade.GlueSchemaRegistrySerializationFacadeBuilder(credentialProvider=" + this.credentialProvider + ", schemaRegistryClient=" + this.schemaRegistryClient + ", glueSchemaRegistryConfiguration=" + this.glueSchemaRegistryConfiguration + ", configs=" + this.configs + ", properties=" + this.properties + ")";
        }
    }
}

