/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.deserializers;

import com.amazonaws.services.schemaregistry.common.AWSCompressionFactory;
import com.amazonaws.services.schemaregistry.exception.AWSIncompatibleDataException;
import java.nio.ByteBuffer;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AWSDeserializerDataParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AWSDeserializerDataParser.class);
    private AWSCompressionFactory compressionFactory;

    private AWSDeserializerDataParser(AWSCompressionFactory awsCompressionFactory) {
        this.compressionFactory = awsCompressionFactory;
    }

    public static AWSDeserializerDataParser getInstance() {
        return DataParserHelper.INSTANCE;
    }

    public UUID getSchemaVersionId(ByteBuffer byteBuffer) {
        this.validateData(byteBuffer);
        byteBuffer.rewind();
        byteBuffer.get();
        byteBuffer.get();
        long mostSigBits = byteBuffer.getLong();
        long leastSigBits = byteBuffer.getLong();
        return new UUID(mostSigBits, leastSigBits);
    }

    public boolean isDataCompatible(ByteBuffer byteBuffer, StringBuilder errorBuilder) {
        byteBuffer.rewind();
        if (byteBuffer.limit() < 18) {
            String message = String.format("%s size: %d", "Data is not compatible with schema registry", byteBuffer.limit());
            errorBuilder.append(message);
            log.debug(message);
            return false;
        }
        Byte headerVersionByte = byteBuffer.get();
        if (!headerVersionByte.equals((byte)3)) {
            String message = "Invalid schema registry header version byte in data";
            errorBuilder.append(message);
            log.debug(message);
            return false;
        }
        Byte compressionByte = byteBuffer.get();
        if (!compressionByte.equals((byte)5) && !compressionByte.equals((byte)0)) {
            String message = "Invalid schema registry compression byte in data";
            errorBuilder.append(message);
            log.debug(message);
            return false;
        }
        return true;
    }

    public byte[] getPlainData(ByteBuffer byteBuffer) {
        this.validateData(byteBuffer);
        byteBuffer.rewind();
        byteBuffer.get();
        Byte compressionByte = byteBuffer.get();
        byteBuffer.getLong();
        byteBuffer.getLong();
        byte[] plainData = new byte[byteBuffer.remaining()];
        byteBuffer.get(plainData);
        boolean isCompressionEnabled = this.isCompressionByteSet(compressionByte);
        if (!isCompressionEnabled) {
            return plainData;
        }
        int dataStart = this.getSchemaRegistryHeaderLength();
        int dataEnd = byteBuffer.limit() - dataStart;
        return this.decompressData(compressionByte, byteBuffer, dataStart, dataEnd);
    }

    private byte[] decompressData(Byte compressionByte, ByteBuffer compressedData, int start, int end) {
        return this.compressionFactory.getCompressionHandler(compressionByte.byteValue()).decompress(compressedData.array(), start, end);
    }

    private void validateData(@NonNull ByteBuffer buffer) throws AWSIncompatibleDataException {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer is marked @NonNull but is null");
        }
        StringBuilder errorMessageBuilder = new StringBuilder();
        if (!this.isDataCompatible(buffer, errorMessageBuilder)) {
            throw new AWSIncompatibleDataException(errorMessageBuilder.toString());
        }
    }

    public boolean isCompressionEnabled(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        byteBuffer.get();
        Byte compressionByte = byteBuffer.get();
        return this.isCompressionByteSet(compressionByte);
    }

    private boolean isCompressionByteSet(Byte compressionByte) {
        return !compressionByte.equals((byte)0);
    }

    public Byte getCompressionByte(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        byteBuffer.get();
        return byteBuffer.get();
    }

    public Byte getHeaderVersionByte(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        return byteBuffer.get();
    }

    private int getSchemaRegistryHeaderLength() {
        return 18;
    }

    private static class DataParserHelper {
        private static final AWSDeserializerDataParser INSTANCE = new AWSDeserializerDataParser(new AWSCompressionFactory());

        private DataParserHelper() {
        }
    }
}

