/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.deserializers;

import com.amazonaws.services.schemaregistry.caching.AWSCache;
import com.amazonaws.services.schemaregistry.caching.AWSSchemaRegistryDeserializerCache;
import com.amazonaws.services.schemaregistry.common.AWSDeserializerInput;
import com.amazonaws.services.schemaregistry.common.AWSSchemaRegistryClient;
import com.amazonaws.services.schemaregistry.common.Schema;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.deserializers.AWSDeserializerDataParser;
import com.amazonaws.services.schemaregistry.deserializers.AWSDeserializerFactory;
import com.amazonaws.services.schemaregistry.deserializers.avro.AWSAvroDeserializer;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import com.google.common.cache.CacheStats;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.glue.model.DataFormat;
import software.amazon.awssdk.services.glue.model.GetSchemaVersionResponse;

public class AWSDeserializer
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AWSDeserializer.class);
    private AwsCredentialsProvider credentialsProvider;
    private AWSSchemaRegistryClient schemaRegistryClient;
    private GlueSchemaRegistryConfiguration glueSchemaRegistryConfiguration;
    private AWSDeserializerFactory deserializerFactory;
    private AWSCache<UUID, Schema, CacheStats> cache;

    public AWSDeserializer(Map<String, ?> configs, Properties properties, @NonNull AwsCredentialsProvider credentialProvider, AWSSchemaRegistryClient schemaRegistryClient) {
        if (credentialProvider == null) {
            throw new IllegalArgumentException("credentialProvider is marked @NonNull but is null");
        }
        this.credentialsProvider = credentialProvider;
        if (configs != null) {
            this.glueSchemaRegistryConfiguration = new GlueSchemaRegistryConfiguration(configs);
        } else if (properties != null) {
            this.glueSchemaRegistryConfiguration = new GlueSchemaRegistryConfiguration(properties);
        } else {
            throw new AWSSchemaRegistryException("Either properties or configuration has to be provided");
        }
        this.schemaRegistryClient = schemaRegistryClient != null ? schemaRegistryClient : new AWSSchemaRegistryClient(this.credentialsProvider, this.glueSchemaRegistryConfiguration);
        this.deserializerFactory = new AWSDeserializerFactory();
        this.cache = AWSSchemaRegistryDeserializerCache.getInstance((GlueSchemaRegistryConfiguration)this.glueSchemaRegistryConfiguration);
    }

    public AWSDeserializer(@NonNull GlueSchemaRegistryConfiguration configuration, @NonNull AwsCredentialsProvider credentialsProvider) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is marked @NonNull but is null");
        }
        if (credentialsProvider == null) {
            throw new IllegalArgumentException("credentialsProvider is marked @NonNull but is null");
        }
        this.credentialsProvider = credentialsProvider;
        this.glueSchemaRegistryConfiguration = configuration;
        this.schemaRegistryClient = new AWSSchemaRegistryClient(credentialsProvider, this.glueSchemaRegistryConfiguration);
        this.deserializerFactory = new AWSDeserializerFactory();
        this.cache = AWSSchemaRegistryDeserializerCache.getInstance((GlueSchemaRegistryConfiguration)this.glueSchemaRegistryConfiguration);
    }

    public String getSchemaDefinition(@NonNull ByteBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer is marked @NonNull but is null");
        }
        AwsDeserializerSchema awsDeserializerSchema = this.getAwsDeserializerSchema(buffer);
        return awsDeserializerSchema.getSchema().getSchemaDefinition();
    }

    public byte[] getActualData(byte[] data) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        return AWSDeserializerDataParser.getInstance().getPlainData(byteBuffer);
    }

    public Schema getSchema(@NonNull byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data is marked @NonNull but is null");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        AwsDeserializerSchema awsDeserializerSchema = this.getAwsDeserializerSchema(byteBuffer);
        return awsDeserializerSchema.getSchema();
    }

    private DataFormat getDataFormat(UUID schemaVersionId) {
        DataFormat dataFormat = null;
        if (schemaVersionId != null && this.cache.get((Object)schemaVersionId) != null) {
            dataFormat = DataFormat.valueOf((String)((Schema)this.cache.get((Object)schemaVersionId)).getDataFormat());
        }
        return dataFormat;
    }

    public String getSchemaDefinition(@NonNull byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data is marked @NonNull but is null");
        }
        return this.getSchemaDefinition(ByteBuffer.wrap(data));
    }

    public Object deserialize(@NonNull AWSDeserializerInput deserializerInput) throws AWSSchemaRegistryException {
        if (deserializerInput == null) {
            throw new IllegalArgumentException("deserializerInput is marked @NonNull but is null");
        }
        ByteBuffer buffer = deserializerInput.getBuffer();
        AwsDeserializerSchema awsDeserializerSchema = this.getAwsDeserializerSchema(buffer);
        UUID schemaVersionId = awsDeserializerSchema.getSchemaVersionId();
        Schema schema = awsDeserializerSchema.getSchema();
        Object result = this.deserializerFactory.getInstance(DataFormat.valueOf((String)schema.getDataFormat()), this.glueSchemaRegistryConfiguration).deserialize(schemaVersionId, buffer, schema.getSchemaDefinition());
        return result;
    }

    public boolean canDeserialize(byte[] data) {
        if (data == null) {
            return false;
        }
        AWSDeserializerDataParser awsDeserializerDataParser = AWSDeserializerDataParser.getInstance();
        return awsDeserializerDataParser.isDataCompatible(ByteBuffer.wrap(data), new StringBuilder());
    }

    public byte[] getAvroDeserializedData(@NonNull ByteBuffer buffer) throws IOException {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer is marked @NonNull but is null");
        }
        AwsDeserializerSchema awsDeserializerSchema = this.getAwsDeserializerSchema(buffer);
        Schema schema = awsDeserializerSchema.getSchema();
        DataFormat dataFormat = DataFormat.valueOf((String)schema.getDataFormat());
        AWSAvroDeserializer awsAvroDeserializer = (AWSAvroDeserializer)this.deserializerFactory.getInstance(dataFormat, this.glueSchemaRegistryConfiguration);
        return awsAvroDeserializer.getDeserializedData(buffer);
    }

    private AwsDeserializerSchema getAwsDeserializerSchema(@NonNull ByteBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer is marked @NonNull but is null");
        }
        AWSDeserializerDataParser dataParser = AWSDeserializerDataParser.getInstance();
        UUID schemaVersionId = dataParser.getSchemaVersionId(buffer);
        Schema schema = this.retrieveSchemaRegistrySchema(schemaVersionId);
        return new AwsDeserializerSchema(schemaVersionId, schema);
    }

    private Schema retrieveSchemaRegistrySchema(UUID schemaVersionId) throws AWSSchemaRegistryException {
        Schema schema = (Schema)this.cache.get((Object)schemaVersionId);
        if (schema != null) {
            return schema;
        }
        GetSchemaVersionResponse response = this.schemaRegistryClient.getSchemaVersionResponse(schemaVersionId.toString());
        log.debug("Retrieved writer schema from Amazon Schema Registry for message: schema version id = {}, ", (Object)schemaVersionId);
        schema = new Schema(response.schemaDefinition(), response.dataFormat().name(), this.getSchemaName(response.schemaArn()));
        this.cache.put((Object)schemaVersionId, (Object)schema);
        return schema;
    }

    private String getSchemaName(String schemaArn) {
        Arn arn = Arn.fromString((String)schemaArn);
        String resource = arn.resourceAsString();
        String[] splitArray = resource.split("/");
        return splitArray[splitArray.length - 1];
    }

    @Override
    public void close() {
    }

    @Generated
    public static AWSDeserializerBuilder builder() {
        return new AWSDeserializerBuilder();
    }

    @Generated
    public AwsCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @Generated
    public AWSSchemaRegistryClient getSchemaRegistryClient() {
        return this.schemaRegistryClient;
    }

    @Generated
    public GlueSchemaRegistryConfiguration getGlueSchemaRegistryConfiguration() {
        return this.glueSchemaRegistryConfiguration;
    }

    @Generated
    public void setDeserializerFactory(AWSDeserializerFactory deserializerFactory) {
        this.deserializerFactory = deserializerFactory;
    }

    @Generated
    public void setCache(AWSCache<UUID, Schema, CacheStats> cache) {
        this.cache = cache;
    }

    @Generated
    public static class AWSDeserializerBuilder {
        @Generated
        private Map<String, ?> configs;
        @Generated
        private Properties properties;
        @Generated
        private AwsCredentialsProvider credentialProvider;
        @Generated
        private AWSSchemaRegistryClient schemaRegistryClient;

        @Generated
        AWSDeserializerBuilder() {
        }

        @Generated
        public AWSDeserializerBuilder configs(Map<String, ?> configs) {
            this.configs = configs;
            return this;
        }

        @Generated
        public AWSDeserializerBuilder properties(Properties properties) {
            this.properties = properties;
            return this;
        }

        @Generated
        public AWSDeserializerBuilder credentialProvider(AwsCredentialsProvider credentialProvider) {
            this.credentialProvider = credentialProvider;
            return this;
        }

        @Generated
        public AWSDeserializerBuilder schemaRegistryClient(AWSSchemaRegistryClient schemaRegistryClient) {
            this.schemaRegistryClient = schemaRegistryClient;
            return this;
        }

        @Generated
        public AWSDeserializer build() {
            return new AWSDeserializer(this.configs, this.properties, this.credentialProvider, this.schemaRegistryClient);
        }

        @Generated
        public String toString() {
            return "AWSDeserializer.AWSDeserializerBuilder(configs=" + this.configs + ", properties=" + this.properties + ", credentialProvider=" + this.credentialProvider + ", schemaRegistryClient=" + this.schemaRegistryClient + ")";
        }
    }

    private static class AwsDeserializerSchema {
        private final UUID schemaVersionId;
        private final Schema schema;

        AwsDeserializerSchema(UUID schemaVersionId, Schema schema) {
            this.schemaVersionId = schemaVersionId;
            this.schema = schema;
        }

        @Generated
        public UUID getSchemaVersionId() {
            return this.schemaVersionId;
        }

        @Generated
        public Schema getSchema() {
            return this.schema;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AwsDeserializerSchema)) {
                return false;
            }
            AwsDeserializerSchema other = (AwsDeserializerSchema)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$schemaVersionId = this.getSchemaVersionId();
            UUID other$schemaVersionId = other.getSchemaVersionId();
            if (this$schemaVersionId == null ? other$schemaVersionId != null : !((Object)this$schemaVersionId).equals(other$schemaVersionId)) {
                return false;
            }
            Schema this$schema = this.getSchema();
            Schema other$schema = other.getSchema();
            return !(this$schema == null ? other$schema != null : !this$schema.equals(other$schema));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AwsDeserializerSchema;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $schemaVersionId = this.getSchemaVersionId();
            result = result * 59 + ($schemaVersionId == null ? 43 : ((Object)$schemaVersionId).hashCode());
            Schema $schema = this.getSchema();
            result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AWSDeserializer.AwsDeserializerSchema(schemaVersionId=" + this.getSchemaVersionId() + ", schema=" + this.getSchema() + ")";
        }
    }
}

