/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.common;

import com.amazonaws.services.schemaregistry.common.GlueSchemaRegistryCompressionHandler;
import com.amazonaws.services.schemaregistry.common.GlueSchemaRegistryDefaultCompression;
import com.amazonaws.services.schemaregistry.utils.AWSSchemaRegistryConstants;

public class GlueSchemaRegistryCompressionFactory {
    private GlueSchemaRegistryDefaultCompression zlibCompression;

    public GlueSchemaRegistryCompressionHandler getCompressionHandler(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        if (compressionType != null && AWSSchemaRegistryConstants.COMPRESSION.ZLIB.name().equalsIgnoreCase(compressionType.name())) {
            return this.getZlibCompression();
        }
        return null;
    }

    public GlueSchemaRegistryCompressionHandler getCompressionHandler(byte compressionByte) {
        if (5 == compressionByte) {
            return this.getZlibCompression();
        }
        return null;
    }

    private synchronized GlueSchemaRegistryCompressionHandler getZlibCompression() {
        if (this.zlibCompression == null) {
            this.zlibCompression = new GlueSchemaRegistryDefaultCompression();
        }
        return this.zlibCompression;
    }
}

