/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.caching;

import com.amazonaws.services.schemaregistry.caching.GlueSchemaRegistryCache;
import com.amazonaws.services.schemaregistry.common.Schema;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GlueSchemaRegistrySerializerCache
implements GlueSchemaRegistryCache<Schema, UUID, CacheStats> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlueSchemaRegistrySerializerCache.class);
    private static GlueSchemaRegistryConfiguration serDeConfigs = null;
    private Cache<Schema, UUID> cache;

    private GlueSchemaRegistrySerializerCache() {
    }

    private GlueSchemaRegistrySerializerCache(Cache<Schema, UUID> cache) {
        this.cache = cache;
    }

    private static GlueSchemaRegistrySerializerCache createSerializerCache() {
        return new GlueSchemaRegistrySerializerCache((Cache<Schema, UUID>)CacheBuilder.newBuilder().maximumSize((long)serDeConfigs.getCacheSize()).expireAfterWrite(serDeConfigs.getTimeToLiveMillis(), TimeUnit.MILLISECONDS).recordStats().removalListener((RemovalListener)new AWSCacheRemovalListener()).build());
    }

    public static GlueSchemaRegistrySerializerCache getInstance(@NonNull GlueSchemaRegistryConfiguration configs) {
        if (configs == null) {
            throw new IllegalArgumentException("configs is marked non-null but is null");
        }
        serDeConfigs = configs;
        return CacheSingletonHelper.INSTANCE;
    }

    @Override
    public UUID get(Schema key) {
        return (UUID)this.cache.getIfPresent((Object)key);
    }

    @Override
    public void put(Schema key, UUID value) {
        log.debug("Associating key {} with value {}", (Object)key, (Object)value);
        this.cache.put((Object)key, (Object)value);
    }

    @Override
    public void delete(Schema key) {
        this.cache.invalidate((Object)key);
    }

    @Override
    public void flushCache() {
        this.cache.invalidateAll();
    }

    @Override
    public long getCacheSize() {
        return this.cache.size();
    }

    @Override
    public CacheStats getCacheStats() {
        return this.cache.stats();
    }

    private static class AWSCacheRemovalListener
    implements RemovalListener<Schema, UUID> {
        private AWSCacheRemovalListener() {
        }

        public void onRemoval(RemovalNotification<Schema, UUID> notification) {
            log.debug(" key {} and value {} from cache cause {}", new Object[]{notification.getKey(), notification.getValue(), notification.getCause()});
        }
    }

    private static class CacheSingletonHelper {
        private static final GlueSchemaRegistrySerializerCache INSTANCE = CacheSingletonHelper.initialize();

        private CacheSingletonHelper() {
        }

        private static GlueSchemaRegistrySerializerCache initialize() {
            return GlueSchemaRegistrySerializerCache.createSerializerCache();
        }
    }
}

