/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.common;

import com.amazonaws.services.schemaregistry.common.GlueSchemaRegistryCompressionHandler;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlueSchemaRegistryDefaultCompression
implements GlueSchemaRegistryCompressionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlueSchemaRegistryDefaultCompression.class);
    private static final String KILO_BYTES = "KB";

    @Override
    public byte[] compress(byte[] record) {
        byte[] compressed = null;
        try {
            compressed = GlueSchemaRegistryCompressionHandler.super.compress(record);
            log.debug("Compression :: record length: {}", (Object)this.formatDataLengthInKB(record.length));
            log.debug("Compression :: record length after compression: {}", (Object)this.formatDataLengthInKB(compressed.length));
        }
        catch (Exception e) {
            String message = "Error while compressing data";
            log.error(message, (Throwable)e);
            throw new AWSSchemaRegistryException(message, e);
        }
        return compressed;
    }

    @Override
    public byte[] decompress(byte[] compressedRecord, int start, int end) {
        byte[] deCompressedRecord = null;
        try {
            deCompressedRecord = GlueSchemaRegistryCompressionHandler.super.decompress(compressedRecord, start, end);
            log.debug("Decompression :: Compressed record length: {}", (Object)this.formatDataLengthInKB(compressedRecord.length));
            log.debug("Decompression :: Decompressed record length: {}", (Object)this.formatDataLengthInKB(deCompressedRecord.length));
        }
        catch (Exception e) {
            String message = "Error while decompressing data";
            log.error(message, (Throwable)e);
            throw new AWSSchemaRegistryException(message, e);
        }
        return deCompressedRecord;
    }

    private String formatDataLengthInKB(int dataLength) {
        return dataLength / 1024 + KILO_BYTES;
    }
}

