/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.common;

import com.amazonaws.services.schemaregistry.common.AWSCompressionHandler;
import com.amazonaws.services.schemaregistry.common.AWSSchemaRegistryDefaultCompression;
import com.amazonaws.services.schemaregistry.utils.AWSSchemaRegistryConstants;

public class AWSCompressionFactory {
    private AWSSchemaRegistryDefaultCompression zlibCompression;

    public AWSCompressionHandler getCompressionHandler(AWSSchemaRegistryConstants.COMPRESSION compressionType) {
        if (compressionType != null && AWSSchemaRegistryConstants.COMPRESSION.ZLIB.name().equalsIgnoreCase(compressionType.name())) {
            return this.getZlibCompression();
        }
        return null;
    }

    public AWSCompressionHandler getCompressionHandler(byte compressionByte) {
        if (5 == compressionByte) {
            return this.getZlibCompression();
        }
        return null;
    }

    private synchronized AWSCompressionHandler getZlibCompression() {
        if (this.zlibCompression == null) {
            this.zlibCompression = new AWSSchemaRegistryDefaultCompression();
        }
        return this.zlibCompression;
    }
}

