/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.utils;

import com.amazonaws.services.schemaregistry.common.AWSSchemaNamingStrategy;
import com.amazonaws.services.schemaregistry.common.AWSSchemaNamingStrategyDefaultImpl;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AWSSchemaRegistryUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AWSSchemaRegistryUtils.class);

    private AWSSchemaRegistryUtils() {
    }

    public static AWSSchemaRegistryUtils getInstance() {
        return UtilsHelper.INSTANCE;
    }

    public boolean checkIfPresentInMap(@NonNull Map<String, ?> map, @NonNull String key) {
        if (map == null) {
            throw new IllegalArgumentException("map is marked @NonNull but is null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key is marked @NonNull but is null");
        }
        Validate.notEmpty(map);
        return map.containsKey(key);
    }

    public AWSSchemaNamingStrategy configureSchemaNamingStrategy(Map<String, ?> configs) {
        return this.isSchemaGenerationClassPresent(configs) ? this.useCustomerProvidedStrategy(String.valueOf(configs.get("schemaNameGenerationClass"))) : this.useDefaultStrategy();
    }

    public String getSchemaName(Map<String, ?> configs) {
        return this.checkIfPresentInMap(configs, "schemaName") ? String.valueOf(configs.get("schemaName")) : null;
    }

    private AWSSchemaNamingStrategy initializeStrategy(@NonNull String className) {
        if (className == null) {
            throw new IllegalArgumentException("className is marked @NonNull but is null");
        }
        AWSSchemaNamingStrategy schemaNameStrategy = null;
        try {
            Object newInstance = Class.forName(className).newInstance();
            if (newInstance instanceof AWSSchemaNamingStrategy) {
                schemaNameStrategy = (AWSSchemaNamingStrategy)newInstance;
            }
        }
        catch (Exception e) {
            String message = String.format("Unable to locate the naming strategy class, check in the classpath for classname = %s", className);
            log.error(message, (Object)"AWSSchemaNamingStrategyDefaultImpl");
            throw new AWSSchemaRegistryException(message, e);
        }
        return schemaNameStrategy;
    }

    private AWSSchemaNamingStrategy useDefaultStrategy() {
        return new AWSSchemaNamingStrategyDefaultImpl();
    }

    private AWSSchemaNamingStrategy useCustomerProvidedStrategy(@NonNull String className) {
        if (className == null) {
            throw new IllegalArgumentException("className is marked @NonNull but is null");
        }
        return this.initializeStrategy(className);
    }

    private boolean isSchemaGenerationClassPresent(Map<String, ?> configs) {
        return this.checkIfPresentInMap(configs, "schemaNameGenerationClass");
    }

    private static class UtilsHelper {
        private static final AWSSchemaRegistryUtils INSTANCE = new AWSSchemaRegistryUtils();

        private UtilsHelper() {
        }
    }
}

