/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.common;

import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.amazonaws.services.schemaregistry.exception.AWSSchemaRegistryException;
import com.amazonaws.services.schemaregistry.utils.AWSSchemaRegistryConstants;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.GlueClientBuilder;
import software.amazon.awssdk.services.glue.model.AlreadyExistsException;
import software.amazon.awssdk.services.glue.model.CreateSchemaRequest;
import software.amazon.awssdk.services.glue.model.CreateSchemaResponse;
import software.amazon.awssdk.services.glue.model.DataFormat;
import software.amazon.awssdk.services.glue.model.GetSchemaByDefinitionRequest;
import software.amazon.awssdk.services.glue.model.GetSchemaByDefinitionResponse;
import software.amazon.awssdk.services.glue.model.GetSchemaVersionRequest;
import software.amazon.awssdk.services.glue.model.GetSchemaVersionResponse;
import software.amazon.awssdk.services.glue.model.GetTagsRequest;
import software.amazon.awssdk.services.glue.model.GetTagsResponse;
import software.amazon.awssdk.services.glue.model.MetadataKeyValuePair;
import software.amazon.awssdk.services.glue.model.PutSchemaVersionMetadataRequest;
import software.amazon.awssdk.services.glue.model.PutSchemaVersionMetadataResponse;
import software.amazon.awssdk.services.glue.model.QuerySchemaVersionMetadataRequest;
import software.amazon.awssdk.services.glue.model.QuerySchemaVersionMetadataResponse;
import software.amazon.awssdk.services.glue.model.RegisterSchemaVersionRequest;
import software.amazon.awssdk.services.glue.model.RegisterSchemaVersionResponse;
import software.amazon.awssdk.services.glue.model.RegistryId;
import software.amazon.awssdk.services.glue.model.SchemaId;

public class AWSSchemaRegistryClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AWSSchemaRegistryClient.class);
    private static final int MAX_ATTEMPTS = 10;
    private static final long MAX_WAIT_INTERVAL = 3000L;
    private final GlueClient client;
    private GlueSchemaRegistryConfiguration glueSchemaRegistryConfiguration;

    public AWSSchemaRegistryClient(@NonNull AwsCredentialsProvider credentialsProvider, @NonNull GlueSchemaRegistryConfiguration glueSchemaRegistryConfiguration, @NonNull RetryPolicy retryPolicy) {
        if (credentialsProvider == null) {
            throw new IllegalArgumentException("credentialsProvider is marked @NonNull but is null");
        }
        if (glueSchemaRegistryConfiguration == null) {
            throw new IllegalArgumentException("glueSchemaRegistryConfiguration is marked @NonNull but is null");
        }
        if (retryPolicy == null) {
            throw new IllegalArgumentException("retryPolicy is marked @NonNull but is null");
        }
        ClientOverrideConfiguration overrideConfiguration = (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().retryPolicy(retryPolicy).build();
        this.glueSchemaRegistryConfiguration = glueSchemaRegistryConfiguration;
        GlueClientBuilder glueClientBuilder = (GlueClientBuilder)((GlueClientBuilder)((GlueClientBuilder)GlueClient.builder().credentialsProvider(credentialsProvider)).overrideConfiguration(overrideConfiguration)).region(Region.of((String)glueSchemaRegistryConfiguration.getRegion()));
        if (glueSchemaRegistryConfiguration.getEndPoint() != null) {
            try {
                glueClientBuilder.endpointOverride(new URI(glueSchemaRegistryConfiguration.getEndPoint()));
            }
            catch (URISyntaxException e) {
                String message = String.format("Malformed uri, please pass the valid uri for creating the client", glueSchemaRegistryConfiguration.getEndPoint());
                throw new AWSSchemaRegistryException(message, e);
            }
        }
        this.client = (GlueClient)glueClientBuilder.build();
    }

    public AWSSchemaRegistryClient(@NonNull AwsCredentialsProvider credentialsProvider, @NonNull GlueSchemaRegistryConfiguration glueSchemaRegistryConfiguration) {
        this(credentialsProvider, glueSchemaRegistryConfiguration, RetryPolicy.defaultRetryPolicy());
        if (credentialsProvider == null) {
            throw new IllegalArgumentException("credentialsProvider is marked @NonNull but is null");
        }
        if (glueSchemaRegistryConfiguration == null) {
            throw new IllegalArgumentException("glueSchemaRegistryConfiguration is marked @NonNull but is null");
        }
    }

    public AWSSchemaRegistryClient(@NonNull GlueClient glueClient) {
        if (glueClient == null) {
            throw new IllegalArgumentException("glueClient is marked @NonNull but is null");
        }
        this.client = glueClient;
    }

    public UUID getSchemaVersionIdByDefinition(@NonNull String schemaDefinition, @NonNull String schemaName, @NonNull String dataFormat) throws AWSSchemaRegistryException {
        if (schemaDefinition == null) {
            throw new IllegalArgumentException("schemaDefinition is marked @NonNull but is null");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("schemaName is marked @NonNull but is null");
        }
        if (dataFormat == null) {
            throw new IllegalArgumentException("dataFormat is marked @NonNull but is null");
        }
        try {
            String message = String.format("Getting Schema Version Id for : schemaDefinition = %s, schemaName = %s, dataFormat = %s", schemaDefinition, schemaName, dataFormat);
            log.info(message);
            GetSchemaByDefinitionResponse response = null;
            response = this.client.getSchemaByDefinition(this.buildGetSchemaByDefinitionRequest(schemaDefinition, schemaName));
            return this.returnSchemaVersionIdIfAvailable(response);
        }
        catch (Exception e) {
            String message = String.format("Failed to get schemaVersionId by schema definition for schema name = %s ", schemaName);
            throw new AWSSchemaRegistryException(message, e);
        }
    }

    public UUID getORRegisterSchemaVersionId(@NonNull String schemaDefinition, @NonNull String schemaName, @NonNull String dataFormat, @NonNull Map<String, String> metadata) throws AWSSchemaRegistryException {
        if (schemaDefinition == null) {
            throw new IllegalArgumentException("schemaDefinition is marked @NonNull but is null");
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("schemaName is marked @NonNull but is null");
        }
        if (dataFormat == null) {
            throw new IllegalArgumentException("dataFormat is marked @NonNull but is null");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("metadata is marked @NonNull but is null");
        }
        UUID schemaVersionId = null;
        try {
            schemaVersionId = this.getSchemaVersionIdByDefinition(schemaDefinition, schemaName, dataFormat);
        }
        catch (AWSSchemaRegistryException e) {
            String exceptionCauseMessage = e.getCause().getMessage();
            if (exceptionCauseMessage.contains("Schema version is not found.")) {
                log.info(exceptionCauseMessage);
                if (!this.glueSchemaRegistryConfiguration.isSchemaAutoRegistrationEnabled()) {
                    throw new AWSSchemaRegistryException("Failed to auto-register schema. Auto registration of schema is not enabled.", e);
                }
                schemaVersionId = this.registerSchemaVersion(schemaDefinition, schemaName, dataFormat, metadata);
            }
            if (exceptionCauseMessage.contains("Schema is not found.")) {
                log.info(exceptionCauseMessage);
                if (!this.glueSchemaRegistryConfiguration.isSchemaAutoRegistrationEnabled()) {
                    throw new AWSSchemaRegistryException("Failed to auto-register schema. Auto registration of schema is not enabled.", e);
                }
                schemaVersionId = this.createSchema(schemaName, dataFormat, schemaDefinition, metadata);
            }
            String msg = String.format("Exception occurred while fetching or registering schema definition = %s, schema name = %s ", schemaDefinition, schemaName);
            throw new AWSSchemaRegistryException(msg, e);
        }
        return schemaVersionId;
    }

    public GetSchemaVersionResponse getSchemaVersionResponse(@NonNull String schemaVersionId) throws AWSSchemaRegistryException {
        if (schemaVersionId == null) {
            throw new IllegalArgumentException("schemaVersionId is marked @NonNull but is null");
        }
        GetSchemaVersionResponse schemaVersionResponse = null;
        try {
            schemaVersionResponse = this.client.getSchemaVersion(this.getSchemaVersionRequest(schemaVersionId));
            this.validateSchemaVersionResponse(schemaVersionResponse, schemaVersionId);
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to get schema version Id = %s", schemaVersionId);
            throw new AWSSchemaRegistryException(errorMessage, e);
        }
        return schemaVersionResponse;
    }

    private GetSchemaVersionRequest getSchemaVersionRequest(String schemaVersionId) {
        GetSchemaVersionRequest getSchemaVersionRequest = (GetSchemaVersionRequest)GetSchemaVersionRequest.builder().schemaVersionId(schemaVersionId).build();
        return getSchemaVersionRequest;
    }

    private void validateSchemaVersionResponse(GetSchemaVersionResponse schemaVersionResponse, String schemaVersionId) {
        if (schemaVersionResponse == null || schemaVersionResponse.schemaVersionId() == null) {
            String message = String.format("Schema definition is not present for the schema id = %s", schemaVersionId);
            throw new AWSSchemaRegistryException(message);
        }
    }

    private UUID returnSchemaVersionIdIfAvailable(GetSchemaByDefinitionResponse response) {
        if (response.schemaVersionId() != null && response.statusAsString().equals(AWSSchemaRegistryConstants.SchemaVersionStatus.AVAILABLE.toString())) {
            return UUID.fromString(response.schemaVersionId());
        }
        String msg = String.format("Schema Found but status is %s", response.statusAsString());
        throw new AWSSchemaRegistryException(msg);
    }

    public GetSchemaByDefinitionRequest buildGetSchemaByDefinitionRequest(String schemaDefinition, String schemaName) {
        return this.buildGetSchemaByDefinitionRequest(schemaDefinition, schemaName, this.glueSchemaRegistryConfiguration.getRegistryName());
    }

    public GetSchemaByDefinitionRequest buildGetSchemaByDefinitionRequest(String schemaDefinition, String schemaName, String registryName) {
        GetSchemaByDefinitionRequest request = (GetSchemaByDefinitionRequest)GetSchemaByDefinitionRequest.builder().schemaId(this.getSchemaIdRequestObject(schemaName, registryName)).schemaDefinition(schemaDefinition).build();
        return request;
    }

    public UUID createSchema(String schemaName, String dataFormat, String schemaDefinition, Map<String, String> metadata) throws AWSSchemaRegistryException {
        UUID schemaVersionId = null;
        try {
            log.debug("Auto Creating schema with schemaName: {} and schemaDefinition : {}", (Object)schemaName, (Object)schemaDefinition);
            CreateSchemaResponse createSchemaResponse = this.client.createSchema(this.getCreateSchemaRequestObject(schemaName, dataFormat, schemaDefinition));
            schemaVersionId = UUID.fromString(createSchemaResponse.schemaVersionId());
        }
        catch (AlreadyExistsException e) {
            log.warn("Schema is already created, this could be caused by multiple producers racing to auto-create schema.");
            schemaVersionId = this.registerSchemaVersion(schemaDefinition, schemaName, dataFormat, metadata);
        }
        catch (Exception e) {
            String errorMessage = String.format("Create schema :: Call failed when creating the schema with the schema registry for schema name = %s", schemaName);
            throw new AWSSchemaRegistryException(errorMessage, e);
        }
        this.putSchemaVersionMetadata(schemaVersionId, metadata);
        return schemaVersionId;
    }

    public UUID registerSchemaVersion(String schemaDefinition, String schemaName, String dataFormat, Map<String, String> metadata) {
        GetSchemaVersionResponse getSchemaVersionResponse = this.registerSchemaVersion(schemaDefinition, schemaName, dataFormat);
        UUID schemaVersionId = UUID.fromString(getSchemaVersionResponse.schemaVersionId());
        this.putSchemaVersionMetadata(schemaVersionId, metadata);
        return schemaVersionId;
    }

    public GetSchemaVersionResponse registerSchemaVersion(String schemaDefinition, String schemaName, String dataFormat) throws AWSSchemaRegistryException {
        GetSchemaVersionResponse schemaVersionResponse = null;
        try {
            RegisterSchemaVersionResponse registerSchemaVersionResponse = this.client.registerSchemaVersion(this.getRegisterSchemaVersionRequest(schemaDefinition, schemaName));
            log.info("Registered the schema version with schema version id = {} and with version number = {} and status {}", new Object[]{registerSchemaVersionResponse.schemaVersionId(), registerSchemaVersionResponse.versionNumber(), registerSchemaVersionResponse.statusAsString()});
            if (AWSSchemaRegistryConstants.SchemaVersionStatus.AVAILABLE.toString().equals(registerSchemaVersionResponse.statusAsString())) {
                return this.transformToGetSchemaVersionResponse(registerSchemaVersionResponse);
            }
            schemaVersionResponse = this.waitForSchemaEvolutionCheckToComplete(this.getGetSchemaVersionRequest(registerSchemaVersionResponse.schemaVersionId()));
        }
        catch (Exception e) {
            String errorMessage = String.format("Register schema :: Call failed when registering the schema with the schema registry for schema name = %s", schemaName);
            throw new AWSSchemaRegistryException(errorMessage, e);
        }
        return schemaVersionResponse;
    }

    private GetSchemaVersionResponse transformToGetSchemaVersionResponse(RegisterSchemaVersionResponse registerSchemaVersionResponse) {
        return (GetSchemaVersionResponse)GetSchemaVersionResponse.builder().schemaVersionId(registerSchemaVersionResponse.schemaVersionId()).status(registerSchemaVersionResponse.status()).status(registerSchemaVersionResponse.statusAsString()).versionNumber(registerSchemaVersionResponse.versionNumber()).build();
    }

    private CreateSchemaRequest getCreateSchemaRequestObject(String schemaName, String dataFormat, String schemaDefinition) {
        return (CreateSchemaRequest)CreateSchemaRequest.builder().dataFormat(DataFormat.valueOf((String)dataFormat)).description(this.glueSchemaRegistryConfiguration.getDescription()).registryId((RegistryId)RegistryId.builder().registryName(this.glueSchemaRegistryConfiguration.getRegistryName()).build()).schemaName(schemaName).schemaDefinition(schemaDefinition).compatibility(this.glueSchemaRegistryConfiguration.getCompatibilitySetting()).tags(this.glueSchemaRegistryConfiguration.getTags()).build();
    }

    private RegisterSchemaVersionRequest getRegisterSchemaVersionRequest(String schemaDefinition, String schemaName) {
        return (RegisterSchemaVersionRequest)RegisterSchemaVersionRequest.builder().schemaDefinition(schemaDefinition).schemaId(this.getSchemaIdRequestObject(schemaName, this.glueSchemaRegistryConfiguration.getRegistryName())).build();
    }

    private SchemaId getSchemaIdRequestObject(@NonNull String schemaName, @NonNull String registryName) {
        if (schemaName == null) {
            throw new IllegalArgumentException("schemaName is marked @NonNull but is null");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("registryName is marked @NonNull but is null");
        }
        return (SchemaId)SchemaId.builder().schemaName(schemaName).registryName(registryName).build();
    }

    private GetSchemaVersionRequest getGetSchemaVersionRequest(String schemaVersionId) {
        return (GetSchemaVersionRequest)GetSchemaVersionRequest.builder().schemaVersionId(schemaVersionId).build();
    }

    private GetSchemaVersionResponse waitForSchemaEvolutionCheckToComplete(GetSchemaVersionRequest getSchemaVersionRequest) {
        GetSchemaVersionResponse response;
        try {
            int retries = 0;
            Thread.sleep(3000L);
            do {
                response = this.client.getSchemaVersion(getSchemaVersionRequest);
                if (AWSSchemaRegistryConstants.SchemaVersionStatus.AVAILABLE.toString().equals(response.statusAsString())) {
                    return response;
                }
                if (AWSSchemaRegistryConstants.SchemaVersionStatus.PENDING.toString().equals(response.statusAsString())) continue;
                throw new AWSSchemaRegistryException(String.format("Schema evolution check failed. schemaVersionId %s is in %s status.", getSchemaVersionRequest.schemaVersionId(), response.statusAsString()));
            } while (retries++ < 9);
            if (retries >= 10 && !AWSSchemaRegistryConstants.SchemaVersionStatus.AVAILABLE.toString().equals(response.statusAsString())) {
                throw new AWSSchemaRegistryException(String.format("Retries exhausted for schema evolution check for schemaVersionId = %s", getSchemaVersionRequest.schemaVersionId()));
            }
        }
        catch (Exception ex) {
            String message = String.format("Exception occurred, while performing schema evolution check for schemaVersionId = %s", getSchemaVersionRequest.schemaVersionId());
            throw new AWSSchemaRegistryException(message, ex);
        }
        return response;
    }

    public void putSchemaVersionMetadata(UUID schemaVersionId, Map<String, String> metadata) {
        metadata.entrySet().parallelStream().map(this::createMetadataKeyValuePair).forEach(metadataKeyValuePair -> {
            try {
                this.putSchemaVersionMetadata(schemaVersionId, (MetadataKeyValuePair)metadataKeyValuePair);
            }
            catch (AWSSchemaRegistryException e) {
                log.warn(e.getMessage());
            }
        });
    }

    public PutSchemaVersionMetadataResponse putSchemaVersionMetadata(UUID schemaVersionId, MetadataKeyValuePair metadataKeyValuePair) throws AWSSchemaRegistryException {
        PutSchemaVersionMetadataResponse response = null;
        try {
            response = this.client.putSchemaVersionMetadata(this.createPutSchemaVersionMetadataRequest(schemaVersionId, metadataKeyValuePair));
        }
        catch (Exception e) {
            String errorMessage = String.format("Put schema version metadata :: Call failed when put metadata key = %s value = %s to schema for schema version id = %s", metadataKeyValuePair.metadataKey(), metadataKeyValuePair.metadataValue(), schemaVersionId.toString());
            throw new AWSSchemaRegistryException(errorMessage, e);
        }
        return response;
    }

    private PutSchemaVersionMetadataRequest createPutSchemaVersionMetadataRequest(UUID schemaVersionId, MetadataKeyValuePair metadataKeyValuePair) {
        return (PutSchemaVersionMetadataRequest)PutSchemaVersionMetadataRequest.builder().schemaVersionId(schemaVersionId.toString()).metadataKeyValue(metadataKeyValuePair).build();
    }

    private MetadataKeyValuePair createMetadataKeyValuePair(Map.Entry<String, String> metadataEntry) {
        return (MetadataKeyValuePair)MetadataKeyValuePair.builder().metadataKey(metadataEntry.getKey()).metadataValue(metadataEntry.getValue()).build();
    }

    public QuerySchemaVersionMetadataResponse querySchemaVersionMetadata(UUID schemaVersionId) {
        QuerySchemaVersionMetadataResponse response = null;
        try {
            response = this.client.querySchemaVersionMetadata(this.createQuerySchemaVersionMetadataRequest(schemaVersionId));
        }
        catch (Exception e) {
            String errorMessage = String.format("Query schema version metadata :: Call failed when query metadata for schema version id = %s", schemaVersionId.toString());
            throw new AWSSchemaRegistryException(errorMessage, e);
        }
        return response;
    }

    private QuerySchemaVersionMetadataRequest createQuerySchemaVersionMetadataRequest(UUID schemaVersionId) {
        return (QuerySchemaVersionMetadataRequest)QuerySchemaVersionMetadataRequest.builder().schemaVersionId(schemaVersionId.toString()).build();
    }

    public GetTagsResponse querySchemaTags(String schemaDefinition, String schemaName) {
        GetTagsResponse getTagsResponse = null;
        try {
            GetSchemaByDefinitionResponse getSchemaByDefinitionResponse = this.client.getSchemaByDefinition(this.buildGetSchemaByDefinitionRequest(schemaDefinition, schemaName));
            GetTagsRequest getTagsRequest = (GetTagsRequest)GetTagsRequest.builder().resourceArn(getSchemaByDefinitionResponse.schemaArn()).build();
            getTagsResponse = this.client.getTags(getTagsRequest);
        }
        catch (Exception e) {
            String errorMessage = String.format("Query schema tags:: Call failed while querying tags for schema = %s", schemaName);
            throw new AWSSchemaRegistryException(errorMessage, e);
        }
        return getTagsResponse;
    }
}

