/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.caching;

import com.amazonaws.services.schemaregistry.caching.AWSCache;
import com.amazonaws.services.schemaregistry.common.Schema;
import com.amazonaws.services.schemaregistry.common.configs.GlueSchemaRegistryConfiguration;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AWSSchemaRegistryDeserializerCache
implements AWSCache<UUID, Schema, CacheStats> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AWSSchemaRegistryDeserializerCache.class);
    private static GlueSchemaRegistryConfiguration serDeConfigs = null;
    private Cache<UUID, Schema> cache;

    private AWSSchemaRegistryDeserializerCache() {
    }

    private AWSSchemaRegistryDeserializerCache(Cache<UUID, Schema> cache) {
        this.cache = cache;
    }

    private static AWSSchemaRegistryDeserializerCache createDeserializerCache() {
        return new AWSSchemaRegistryDeserializerCache((Cache<UUID, Schema>)CacheBuilder.newBuilder().maximumSize((long)serDeConfigs.getCacheSize()).expireAfterWrite(serDeConfigs.getTimeToLiveMillis(), TimeUnit.MILLISECONDS).recordStats().removalListener((RemovalListener)new AWSCacheRemovalListener()).build());
    }

    public static AWSSchemaRegistryDeserializerCache getInstance(@NonNull GlueSchemaRegistryConfiguration configs) {
        if (configs == null) {
            throw new IllegalArgumentException("configs is marked @NonNull but is null");
        }
        serDeConfigs = configs;
        return CacheSingletonHelper.INSTANCE;
    }

    @Override
    public Schema get(UUID key) {
        return (Schema)this.cache.getIfPresent((Object)key);
    }

    @Override
    public void put(UUID key, Schema value) {
        log.info("Associating key {} with value {}", (Object)key, (Object)value);
        this.cache.put((Object)key, (Object)value);
    }

    @Override
    public void delete(UUID key) {
        this.cache.invalidate((Object)key);
    }

    @Override
    public void flushCache() {
        this.cache.invalidateAll();
    }

    @Override
    public long getCacheSize() {
        return this.cache.size();
    }

    @Override
    public CacheStats getCacheStats() {
        return this.cache.stats();
    }

    private static class AWSCacheRemovalListener
    implements RemovalListener<UUID, Schema> {
        private AWSCacheRemovalListener() {
        }

        public void onRemoval(RemovalNotification<UUID, Schema> notification) {
            log.debug("Removed key {} and value {} from cache cause {}", new Object[]{notification.getKey(), notification.getValue(), notification.getCause()});
        }
    }

    private static class CacheSingletonHelper {
        private static final AWSSchemaRegistryDeserializerCache INSTANCE = CacheSingletonHelper.initialize();

        private CacheSingletonHelper() {
        }

        private static AWSSchemaRegistryDeserializerCache initialize() {
            return AWSSchemaRegistryDeserializerCache.createDeserializerCache();
        }
    }
}

