/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.glue.dqdl.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import software.amazon.glue.dqdl.model.DQVariable;
import software.amazon.glue.dqdl.model.condition.Condition;
import software.amazon.glue.dqdl.model.condition.string.QuotedStringOperand;
import software.amazon.glue.dqdl.model.condition.string.StringBasedCondition;
import software.amazon.glue.dqdl.model.condition.string.StringOperand;
import software.amazon.glue.dqdl.model.condition.variable.VariableReferenceOperand;

public final class DQDLVariableResolver {
    private DQDLVariableResolver() {
        throw new AssertionError((Object)"Utility class should not be instantiated");
    }

    public static Condition resolveVariablesInCondition(Condition condition, Map<String, DQVariable> variables, Map<String, DQVariable> usedVars) {
        if (!(condition instanceof StringBasedCondition)) {
            return condition;
        }
        StringBasedCondition stringCondition = (StringBasedCondition)condition;
        ArrayList<StringOperand> resolvedOperands = new ArrayList<StringOperand>();
        for (StringOperand operand : stringCondition.getOperands()) {
            if (operand instanceof VariableReferenceOperand) {
                String varName = operand.getOperand();
                DQVariable variable = variables.get(varName);
                if (variable != null) {
                    usedVars.put(varName, variable);
                    Object value = variable.getValue();
                    if (value instanceof List) {
                        for (Object listItem : (List)value) {
                            resolvedOperands.add(new QuotedStringOperand(listItem.toString()));
                        }
                        continue;
                    }
                    resolvedOperands.add(new QuotedStringOperand(value.toString()));
                    continue;
                }
                resolvedOperands.add(operand);
                continue;
            }
            resolvedOperands.add(operand);
        }
        return new StringBasedCondition(stringCondition.getConditionAsString(), stringCondition.getOperator(), resolvedOperands, stringCondition.getOperands());
    }
}

