/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.glue.dqdl.parser;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.zone.ZoneRulesException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import software.amazon.glue.dqdl.DataQualityDefinitionLanguageBaseListener;
import software.amazon.glue.dqdl.DataQualityDefinitionLanguageParser;
import software.amazon.glue.dqdl.model.DQAnalyzer;
import software.amazon.glue.dqdl.model.DQRule;
import software.amazon.glue.dqdl.model.DQRuleLogicalOperator;
import software.amazon.glue.dqdl.model.DQRuleParameterValue;
import software.amazon.glue.dqdl.model.DQRuleType;
import software.amazon.glue.dqdl.model.DQRuleset;
import software.amazon.glue.dqdl.model.DQVariable;
import software.amazon.glue.dqdl.model.condition.Condition;
import software.amazon.glue.dqdl.model.condition.date.DateBasedCondition;
import software.amazon.glue.dqdl.model.condition.date.DateBasedConditionOperator;
import software.amazon.glue.dqdl.model.condition.date.DateExpression;
import software.amazon.glue.dqdl.model.condition.date.NullDateExpression;
import software.amazon.glue.dqdl.model.condition.duration.Duration;
import software.amazon.glue.dqdl.model.condition.duration.DurationBasedCondition;
import software.amazon.glue.dqdl.model.condition.duration.DurationBasedConditionOperator;
import software.amazon.glue.dqdl.model.condition.duration.DurationUnit;
import software.amazon.glue.dqdl.model.condition.number.AtomicNumberOperand;
import software.amazon.glue.dqdl.model.condition.number.BinaryExpressionOperand;
import software.amazon.glue.dqdl.model.condition.number.FunctionCallOperand;
import software.amazon.glue.dqdl.model.condition.number.NullNumericOperand;
import software.amazon.glue.dqdl.model.condition.number.NumberBasedCondition;
import software.amazon.glue.dqdl.model.condition.number.NumberBasedConditionOperator;
import software.amazon.glue.dqdl.model.condition.number.NumericOperand;
import software.amazon.glue.dqdl.model.condition.size.Size;
import software.amazon.glue.dqdl.model.condition.size.SizeBasedCondition;
import software.amazon.glue.dqdl.model.condition.size.SizeBasedConditionOperator;
import software.amazon.glue.dqdl.model.condition.size.SizeUnit;
import software.amazon.glue.dqdl.model.condition.string.Keyword;
import software.amazon.glue.dqdl.model.condition.string.KeywordStringOperand;
import software.amazon.glue.dqdl.model.condition.string.QuotedStringOperand;
import software.amazon.glue.dqdl.model.condition.string.StringBasedCondition;
import software.amazon.glue.dqdl.model.condition.string.StringBasedConditionOperator;
import software.amazon.glue.dqdl.model.condition.string.StringOperand;
import software.amazon.glue.dqdl.model.condition.string.Tag;
import software.amazon.glue.dqdl.model.condition.variable.VariableReferenceOperand;
import software.amazon.glue.dqdl.parser.DQDLErrorListener;
import software.amazon.glue.dqdl.util.Either;

public class DQDLParserListener
extends DataQualityDefinitionLanguageBaseListener {
    private final DQDLErrorListener errorListener;
    private final List<String> errorMessages = new ArrayList<String>();
    private final Map<String, String> metadata = new HashMap<String, String>();
    private String primarySource;
    private List<String> additionalSources;
    private final List<DQRule> dqRules = new ArrayList<DQRule>();
    private final List<DQAnalyzer> dqAnalyzers = new ArrayList<DQAnalyzer>();
    private final Map<String, DQVariable> dqVariables = new HashMap<String, DQVariable>();
    private static final String METADATA_VERSION_KEY = "Version";
    private static final Set<String> ALLOWED_METADATA_KEYS = new HashSet<String>();
    private static final String PRIMARY_SOURCE_KEY = "Primary";
    private static final String ADDITIONAL_SOURCES_KEY = "AdditionalDataSources";
    private static final Set<String> ALLOWED_SOURCES_KEYS;
    private static final String THRESHOLD_KEY = "threshold";
    private static final String MILITARY_TIME_FORMAT = "HH:mm";
    private static final String AMPM_TIME_FORMAT = "h:mm a";
    private static final int COMPOSITE_RULE_MAX_NESTING_DEPTH = 5;

    public DQDLParserListener(DQDLErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public Either<List<String>, DQRuleset> getParsedRuleset() {
        if (this.errorMessages.isEmpty() && this.dqRules.isEmpty() && this.dqAnalyzers.isEmpty()) {
            this.errorMessages.add("No rules or analyzers provided.");
        }
        if (this.errorMessages.isEmpty() && this.errorListener.getErrorMessages().isEmpty()) {
            return Either.fromRight(new DQRuleset(this.metadata, this.primarySource, this.additionalSources, this.dqRules, this.dqAnalyzers));
        }
        ArrayList<String> allErrorMessages = new ArrayList<String>();
        allErrorMessages.addAll(this.errorMessages);
        allErrorMessages.addAll(this.errorListener.getErrorMessages());
        return Either.fromLeft(allErrorMessages);
    }

    @Override
    public void enterMetadata(DataQualityDefinitionLanguageParser.MetadataContext ctx) {
        DataQualityDefinitionLanguageParser.DictionaryContext dictionaryContext = ctx.dictionary();
        List<String> dictionaryErrors = this.validateDictionary(dictionaryContext);
        if (!dictionaryErrors.isEmpty()) {
            this.errorMessages.addAll(dictionaryErrors);
            return;
        }
        for (DataQualityDefinitionLanguageParser.PairContext pairContext : dictionaryContext.pair()) {
            String key = this.removeEscapes(this.removeQuotes(pairContext.QUOTED_STRING().getText()));
            if (!ALLOWED_METADATA_KEYS.contains(key)) {
                this.errorMessages.add("Unsupported key provided in Metadata section");
                return;
            }
            String value = pairContext.pairValue().getText().replaceAll("\"", "");
            this.metadata.put(key, value);
        }
    }

    @Override
    public void enterDataSources(DataQualityDefinitionLanguageParser.DataSourcesContext ctx) {
        DataQualityDefinitionLanguageParser.DictionaryContext dictionaryContext = ctx.dictionary();
        List<String> dictionaryErrors = this.validateDictionary(dictionaryContext);
        if (!dictionaryErrors.isEmpty()) {
            this.errorMessages.addAll(dictionaryErrors);
            return;
        }
        for (DataQualityDefinitionLanguageParser.PairContext pairContext : dictionaryContext.pair()) {
            String key = this.removeEscapes(this.removeQuotes(pairContext.QUOTED_STRING().getText()));
            if (!ALLOWED_SOURCES_KEYS.contains(key)) {
                this.errorMessages.add("Unsupported key provided in Sources section");
                return;
            }
            if (PRIMARY_SOURCE_KEY.equals(key)) {
                this.primarySource = pairContext.pairValue().getText().replaceAll("\"", "");
            }
            if (!ADDITIONAL_SOURCES_KEY.equals(key)) continue;
            if (pairContext.pairValue().array() == null) {
                this.errorMessages.add("Additional sources must be an array of values.");
                continue;
            }
            this.additionalSources = new ArrayList<String>();
            String cleanedSources = pairContext.pairValue().getText().replace("[", "").replace("]", "").replaceAll(" ", "").replaceAll("\"", "");
            Collections.addAll(this.additionalSources, cleanedSources.split(","));
        }
    }

    @Override
    public void enterDqRules(DataQualityDefinitionLanguageParser.DqRulesContext dqRulesContext) {
        if (!this.errorMessages.isEmpty()) {
            return;
        }
        for (DataQualityDefinitionLanguageParser.TopLevelRuleContext tlc : dqRulesContext.topLevelRule()) {
            Either<String, DQRule> dqRuleEither = this.parseTopLevelRule(tlc, 0);
            if (dqRuleEither.isLeft()) {
                this.errorMessages.add(dqRuleEither.getLeft());
                return;
            }
            this.dqRules.add(dqRuleEither.getRight());
        }
    }

    private Either<String, DQRule> parseTopLevelRule(DataQualityDefinitionLanguageParser.TopLevelRuleContext tlc, int depth) {
        if (tlc.LPAREN() != null && tlc.RPAREN() != null) {
            return this.parseTopLevelRule(tlc.topLevelRule(0), depth);
        }
        if (tlc.AND() != null || tlc.OR() != null) {
            DQRuleLogicalOperator op = tlc.AND() != null ? DQRuleLogicalOperator.AND : DQRuleLogicalOperator.OR;
            List<Either> nestedRuleEitherList = tlc.topLevelRule().stream().map(r -> this.parseTopLevelRule((DataQualityDefinitionLanguageParser.TopLevelRuleContext)((Object)r), depth + 1)).collect(Collectors.toList());
            ArrayList allErrorMessages = new ArrayList();
            ArrayList<DQRule> allRules = new ArrayList<DQRule>();
            nestedRuleEitherList.forEach(arg -> {
                if (arg.isLeft()) {
                    allErrorMessages.add(arg.getLeft());
                } else {
                    allRules.add((DQRule)arg.getRight());
                }
            });
            if (allErrorMessages.isEmpty()) {
                return Either.fromRight(new DQRule("Composite", null, null, null, op, allRules));
            }
            return Either.fromLeft(allErrorMessages.get(0));
        }
        if (tlc.dqRule() != null) {
            if (depth > 5) {
                return Either.fromLeft(String.format("Maximum nested expression depth of %s reached for composite rule", 5));
            }
            return this.getDQRule(tlc.dqRule());
        }
        return Either.fromLeft("No valid rule found");
    }

    @Override
    public void enterDqAnalyzers(DataQualityDefinitionLanguageParser.DqAnalyzersContext dqAnalyzersContext) {
        if (!this.errorMessages.isEmpty()) {
            return;
        }
        for (DataQualityDefinitionLanguageParser.DqAnalyzerContext dac : dqAnalyzersContext.dqAnalyzer()) {
            Either<String, DQAnalyzer> dqAnalyzerEither = this.getDQAnalyzer(dac);
            if (dqAnalyzerEither.isLeft()) {
                this.errorMessages.add(dqAnalyzerEither.getLeft());
                return;
            }
            this.dqAnalyzers.add(dqAnalyzerEither.getRight());
        }
    }

    @Override
    public void enterVariableDeclaration(DataQualityDefinitionLanguageParser.VariableDeclarationContext ctx) {
        if (!this.errorMessages.isEmpty()) {
            return;
        }
        String variableName = ctx.IDENTIFIER().getText();
        if (variableName.startsWith(".") || variableName.startsWith("_")) {
            this.errorMessages.add(String.format("Variable name '%s' cannot start with '.' or '_'", variableName));
            return;
        }
        if (this.dqVariables.containsKey(variableName)) {
            this.errorMessages.add("Variable '" + variableName + "' is already defined");
            return;
        }
        DQVariable<Object> variable = null;
        DataQualityDefinitionLanguageParser.ExpressionContext expr = ctx.expression();
        if (expr == null) {
            this.errorMessages.add(String.format("Missing value for variable '%s'", variableName));
            return;
        }
        if (expr.stringValuesArray() != null) {
            List values = expr.stringValuesArray().stringValues().stream().map(this::processStringValues).collect(Collectors.toList());
            variable = new DQVariable(variableName, DQVariable.VariableType.STRING_ARRAY, values);
        } else if (expr.stringValues() != null) {
            String value = this.processStringValues(expr.stringValues());
            variable = new DQVariable<String>(variableName, DQVariable.VariableType.STRING, value);
        }
        if (variable != null) {
            this.dqVariables.put(variableName, variable);
        } else {
            this.errorMessages.add(String.format("Failed to parse variable '%s'", variableName));
        }
    }

    private Either<String, DQRule> getDQRule(DataQualityDefinitionLanguageParser.DqRuleContext dqRuleContext) {
        List<DQRuleParameterValue> parameters;
        String ruleType = dqRuleContext.ruleType().getText();
        Optional<DQRuleType> optionalDQRuleType = DQRuleType.getRuleType(ruleType, (parameters = this.parseParameters(dqRuleContext.parameterWithConnectorWord())).size());
        if (!optionalDQRuleType.isPresent()) {
            return Either.fromLeft(String.format("Rule Type: %s is not valid", ruleType));
        }
        DQRuleType dqRuleType = optionalDQRuleType.get();
        if (dqRuleType.isAnalyzerOnly()) {
            return Either.fromLeft(String.format("Analyzer Type: %s is not supported in rules section", ruleType));
        }
        Optional<String> errorMessage = dqRuleType.verifyParameters(dqRuleType.getParameters(), parameters);
        if (errorMessage.isPresent()) {
            return Either.fromLeft(String.format(errorMessage.get() + ": %s", ruleType));
        }
        LinkedHashMap<String, DQRuleParameterValue> parameterMap = dqRuleType.createParameterMap(dqRuleType.getParameters(), parameters);
        String whereClause = null;
        if (dqRuleContext.whereClause() != null) {
            if (dqRuleType.isWhereClauseSupported()) {
                DataQualityDefinitionLanguageParser.WhereClauseContext ctx = dqRuleContext.whereClause();
                if (ctx.quotedString().getText().isEmpty() || ctx.quotedString().getText().equals("\"\"")) {
                    return Either.fromLeft(String.format("Empty where condition provided for rule type: %s", ruleType));
                }
                whereClause = this.removeQuotes(ctx.quotedString().getText());
            } else {
                return Either.fromLeft(String.format("Where clause is not supported for rule type: %s", ruleType));
            }
        }
        Condition thresholdCondition = null;
        HashMap<String, Tag> tags = new HashMap<String, Tag>();
        List<Object> tagContexts = dqRuleContext.tagWithCondition() == null ? new ArrayList() : dqRuleContext.tagWithCondition();
        for (DataQualityDefinitionLanguageParser.TagWithConditionContext tagWithConditionContext : tagContexts) {
            if (tagWithConditionContext.stringBasedCondition() != null) {
                Either<String, Tag> outcome = this.processStringTag(tagWithConditionContext);
                if (outcome.isLeft()) {
                    return Either.fromLeft(outcome.getLeft());
                }
                Tag tag = outcome.getRight();
                tags.put(tag.getKey(), tag);
                continue;
            }
            if (tagWithConditionContext.numberBasedCondition() != null) {
                Either<String, Serializable> outcome;
                String tagName = tagWithConditionContext.tagValues().getText();
                if (tagName.equalsIgnoreCase(THRESHOLD_KEY)) {
                    outcome = this.processThresholdTag(dqRuleType, thresholdCondition, tagWithConditionContext, ruleType);
                    if (outcome.isLeft()) {
                        return Either.fromLeft(outcome.getLeft());
                    }
                    thresholdCondition = (Condition)outcome.getRight();
                    continue;
                }
                outcome = this.processNumberTag(tagWithConditionContext, tagName);
                if (outcome.isLeft()) {
                    return Either.fromLeft(outcome.getLeft());
                }
                Tag tag = (Tag)outcome.getRight();
                tags.put(tag.getKey(), tag);
                continue;
            }
            return Either.fromLeft(String.format("Invalid tag provided for rule type: %s", ruleType));
        }
        List list = Arrays.stream(dqRuleType.getReturnType().split("\\|")).map(rt -> this.parseCondition(dqRuleType, (String)rt, dqRuleContext, Tag.convertToStringMap(tags))).collect(Collectors.toList());
        Optional<Either> optionalCondition = list.stream().filter(Either::isRight).findFirst();
        if (optionalCondition.isPresent()) {
            if (!optionalCondition.get().isRight()) {
                return Either.fromLeft(optionalCondition.get().getLeft());
            }
        } else {
            Optional<Either> optionalFailedCondition = list.stream().filter(Either::isLeft).findFirst();
            if (optionalFailedCondition.isPresent()) {
                return Either.fromLeft(optionalFailedCondition.get().getLeft());
            }
            return Either.fromLeft(String.format("Error while parsing condition for rule with rule type: %s", ruleType));
        }
        Condition condition = (Condition)optionalCondition.get().getRight();
        return Either.fromRight(DQRule.createFromParameterValueMapWithVariables(dqRuleType, parameterMap, condition, thresholdCondition, whereClause, tags, this.dqVariables));
    }

    private Either<String, Condition> processThresholdTag(DQRuleType dqRuleType, Condition thresholdCondition, DataQualityDefinitionLanguageParser.TagWithConditionContext tagContext, String ruleType) {
        if (dqRuleType.isThresholdSupported()) {
            if (thresholdCondition != null) {
                return Either.fromLeft("Only one threshold condition at a time is supported.");
            }
            return this.processThresholdTag(tagContext, ruleType);
        }
        return Either.fromLeft(String.format("Threshold condition not supported for rule type: %s", ruleType));
    }

    private Either<String, Tag> processNumberTag(DataQualityDefinitionLanguageParser.TagWithConditionContext tagContext, String tagName) {
        if (!this.isTagValid(tagContext.numberBasedCondition())) {
            return Either.fromLeft("Number tags only support the equality operator.");
        }
        List<DataQualityDefinitionLanguageParser.NumberContext> numberContexts = tagContext.numberBasedCondition().number();
        if (numberContexts != null && !numberContexts.isEmpty()) {
            String tagValue = numberContexts.get(0).getText();
            return Either.fromRight(new Tag(tagName, tagValue));
        }
        return Either.fromLeft(String.format("Error Parsing Tag %s", tagName));
    }

    private Either<String, Tag> processStringTag(DataQualityDefinitionLanguageParser.TagWithConditionContext tagContext) {
        if (!this.isTagValid(tagContext.stringBasedCondition())) {
            return Either.fromLeft("String tags only support the equality operator.");
        }
        String tagKey = tagContext.tagValues().getText();
        Optional<Condition> valueCondition = this.parseStringBasedCondition(tagContext.stringBasedCondition());
        if (valueCondition.isPresent()) {
            StringBasedCondition stringCondition = (StringBasedCondition)valueCondition.get();
            String tagValue = stringCondition.getOperands().get(0).formatOperand();
            return Either.fromRight(new Tag(tagKey, tagValue));
        }
        return Either.fromLeft(String.format("Error while parsing tag: %s", tagKey));
    }

    private Either<String, Condition> processThresholdTag(DataQualityDefinitionLanguageParser.TagWithConditionContext tagContext, String ruleType) {
        DataQualityDefinitionLanguageParser.NumberBasedConditionContext ctx = tagContext.numberBasedCondition();
        Optional<Condition> possibleCond = this.parseNumberBasedCondition(ctx);
        if (possibleCond.isPresent()) {
            return Either.fromRight(possibleCond.get());
        }
        return Either.fromLeft(String.format("Unable to parse threshold condition provided for rule type: %s", ruleType));
    }

    private boolean isTagValid(ParserRuleContext ctx) {
        if (ctx instanceof DataQualityDefinitionLanguageParser.StringBasedConditionContext) {
            DataQualityDefinitionLanguageParser.StringBasedConditionContext stringCtx = (DataQualityDefinitionLanguageParser.StringBasedConditionContext)ctx;
            return stringCtx.EQUAL_TO() != null && stringCtx.NEGATION() == null;
        }
        if (ctx instanceof DataQualityDefinitionLanguageParser.NumberBasedConditionContext) {
            DataQualityDefinitionLanguageParser.NumberBasedConditionContext numberCtx = (DataQualityDefinitionLanguageParser.NumberBasedConditionContext)ctx;
            return numberCtx.EQUAL_TO() != null && numberCtx.NEGATION() == null;
        }
        return false;
    }

    private Either<String, DQAnalyzer> getDQAnalyzer(DataQualityDefinitionLanguageParser.DqAnalyzerContext dqAnalyzerContext) {
        List<DQRuleParameterValue> parameters;
        String analyzerType = dqAnalyzerContext.analyzerType().getText();
        Optional<DQRuleType> optionalDQAnalyzerType = DQRuleType.getRuleType(analyzerType, (parameters = this.parseParameters(dqAnalyzerContext.parameterWithConnectorWord())).size());
        if (!optionalDQAnalyzerType.isPresent()) {
            return Either.fromLeft(String.format("Analyzer Type: %s is not valid", analyzerType));
        }
        DQRuleType dqRuleType = optionalDQAnalyzerType.get();
        if (dqRuleType.getReturnType().equals("BOOLEAN")) {
            return Either.fromLeft(String.format("Analyzer Type: %s is not supported", analyzerType));
        }
        Optional<String> errorMessage = dqRuleType.verifyParameters(dqRuleType.getParameters(), parameters);
        if (errorMessage.isPresent()) {
            return Either.fromLeft(String.format(errorMessage.get() + ": %s", analyzerType));
        }
        LinkedHashMap<String, DQRuleParameterValue> parameterMap = dqRuleType.createParameterMap(dqRuleType.getParameters(), parameters);
        return Either.fromRight(DQAnalyzer.createFromValueMap(analyzerType, parameterMap));
    }

    private Either<String, Condition> parseCondition(DQRuleType ruleType, String returnType, DataQualityDefinitionLanguageParser.DqRuleContext dqRuleContext, Map<String, String> tags) {
        Either<String, Condition> response = Either.fromLeft(String.format("Error parsing condition for return type: %s", returnType));
        switch (returnType) {
            case "BOOLEAN": {
                if (dqRuleContext.condition() != null) {
                    response = Either.fromLeft(String.format("Unexpected condition for rule of type %s with boolean return type", ruleType.getRuleTypeName()));
                    break;
                }
                response = Either.fromRight(new Condition(""));
                break;
            }
            case "NUMBER": 
            case "NUMBER_ARRAY": {
                if (dqRuleContext.condition() == null || dqRuleContext.condition().numberBasedCondition() == null) {
                    response = Either.fromLeft(String.format("Unexpected condition for rule of type %s with number return type", ruleType.getRuleTypeName()));
                    break;
                }
                Optional<Condition> possibleCond = this.parseNumberBasedCondition(dqRuleContext.condition().numberBasedCondition());
                if (!possibleCond.isPresent()) break;
                response = Either.fromRight(possibleCond.get());
                break;
            }
            case "STRING": 
            case "STRING_ARRAY": {
                if (dqRuleContext.condition() == null || dqRuleContext.condition().stringBasedCondition() == null) {
                    response = Either.fromLeft(String.format("Unexpected condition for rule of type %s with string return type", ruleType.getRuleTypeName()));
                    break;
                }
                Optional<Condition> possibleCond = this.parseStringBasedCondition(dqRuleContext.condition().stringBasedCondition());
                if (!possibleCond.isPresent()) break;
                response = Either.fromRight(possibleCond.get());
                break;
            }
            case "DATE": 
            case "DATE_ARRAY": {
                if (dqRuleContext.condition() == null || dqRuleContext.condition().dateBasedCondition() == null) {
                    return Either.fromLeft(String.format("Unexpected condition for rule of type %s with date return type", ruleType.getRuleTypeName()));
                }
                Optional<Condition> possibleCond = this.parseDateBasedCondition(dqRuleContext.condition().dateBasedCondition(), tags);
                if (!possibleCond.isPresent()) break;
                response = Either.fromRight(possibleCond.get());
                break;
            }
            case "DURATION": 
            case "DURATION_ARRAY": {
                if (dqRuleContext.condition() == null || dqRuleContext.condition().durationBasedCondition() == null) {
                    return Either.fromLeft(String.format("Unexpected condition for rule of type %s with duration return type", ruleType.getRuleTypeName()));
                }
                Optional<Condition> possibleCond = this.parseDurationBasedCondition(dqRuleContext.condition().durationBasedCondition());
                if (!possibleCond.isPresent()) break;
                response = Either.fromRight(possibleCond.get());
                break;
            }
            case "SIZE": 
            case "SIZE_ARRAY": {
                Optional<SizeBasedCondition> possibleCond;
                DataQualityDefinitionLanguageParser.ConditionContext cx = dqRuleContext.condition();
                if (cx == null || cx.sizeBasedCondition() == null && cx.numberBasedCondition() == null) {
                    return Either.fromLeft(String.format("Unexpected condition for rule of type %s with size return type", ruleType.getRuleTypeName()));
                }
                if (cx.sizeBasedCondition() != null) {
                    Optional<Condition> possibleCond2 = this.parseSizeBasedCondition(dqRuleContext.condition().sizeBasedCondition());
                    if (!possibleCond2.isPresent()) break;
                    response = Either.fromRight(possibleCond2.get());
                    break;
                }
                if (cx.numberBasedCondition() == null || !(possibleCond = this.convertNumberToSizeCondition(this.parseNumberBasedCondition(dqRuleContext.condition().numberBasedCondition()))).isPresent()) break;
                response = Either.fromRight(possibleCond.get());
                break;
            }
        }
        return response;
    }

    private Optional<SizeBasedCondition> convertNumberToSizeCondition(Optional<Condition> in) {
        if (!in.isPresent() || !(in.get() instanceof NumberBasedCondition)) {
            return Optional.empty();
        }
        NumberBasedCondition input = (NumberBasedCondition)in.get();
        String conditionAsString = input.getConditionAsString();
        SizeBasedConditionOperator operator = SizeBasedConditionOperator.valueOf(input.getOperator().name());
        List<Size> operands = input.getOperands().stream().filter(x -> x instanceof AtomicNumberOperand).filter(x -> Double.parseDouble(x.getOperand()) % 1.0 == 0.0).map(x -> new Size(Integer.parseInt(x.getOperand()), SizeUnit.B)).collect(Collectors.toList());
        if (operands.size() != input.getOperands().size()) {
            return Optional.empty();
        }
        return Optional.of(new SizeBasedCondition(conditionAsString, operator, operands));
    }

    private Optional<Condition> parseNumberBasedCondition(DataQualityDefinitionLanguageParser.NumberBasedConditionContext ctx) {
        List numbers;
        String exprStr = ctx.getText();
        NumberBasedCondition condition = null;
        if (ctx.BETWEEN() != null && ctx.number().size() == 2) {
            Optional<NumericOperand> operand1 = this.parseNumericOperand(ctx.number(0), false);
            Optional<NumericOperand> operand2 = this.parseNumericOperand(ctx.number(1), false);
            if (operand1.isPresent() && operand2.isPresent()) {
                NumberBasedConditionOperator op2 = ctx.NOT() != null ? NumberBasedConditionOperator.NOT_BETWEEN : NumberBasedConditionOperator.BETWEEN;
                condition = new NumberBasedCondition(exprStr, op2, Arrays.asList(operand1.get(), operand2.get()));
            }
        } else if (ctx.GREATER_THAN_EQUAL_TO() != null && ctx.number().size() == 1) {
            Optional<NumericOperand> operand = this.parseNumericOperand(ctx.number(0), false);
            if (operand.isPresent()) {
                condition = new NumberBasedCondition(exprStr, NumberBasedConditionOperator.GREATER_THAN_EQUAL_TO, Collections.singletonList(operand.get()));
            }
        } else if (ctx.GREATER_THAN() != null && ctx.number().size() == 1) {
            Optional<NumericOperand> operand = this.parseNumericOperand(ctx.number(0), false);
            if (operand.isPresent()) {
                condition = new NumberBasedCondition(exprStr, NumberBasedConditionOperator.GREATER_THAN, Collections.singletonList(operand.get()));
            }
        } else if (ctx.LESS_THAN() != null && ctx.number().size() == 1) {
            Optional<NumericOperand> operand = this.parseNumericOperand(ctx.number(0), false);
            if (operand.isPresent()) {
                condition = new NumberBasedCondition(exprStr, NumberBasedConditionOperator.LESS_THAN, Collections.singletonList(operand.get()));
            }
        } else if (ctx.LESS_THAN_EQUAL_TO() != null && ctx.number().size() == 1) {
            Optional<NumericOperand> operand = this.parseNumericOperand(ctx.number(0), false);
            if (operand.isPresent()) {
                condition = new NumberBasedCondition(exprStr, NumberBasedConditionOperator.LESS_THAN_EQUAL_TO, Collections.singletonList(operand.get()));
            }
        } else if (ctx.EQUAL_TO() != null && ctx.number().size() == 1) {
            Optional<NumericOperand> operand = this.parseNumericOperand(ctx.number(0), false);
            if (operand.isPresent()) {
                NumberBasedConditionOperator op3 = ctx.NEGATION() != null ? NumberBasedConditionOperator.NOT_EQUALS : NumberBasedConditionOperator.EQUALS;
                condition = new NumberBasedCondition(exprStr, op3, Collections.singletonList(operand.get()));
            }
        } else if (ctx.IN() != null && ctx.numberArray() != null && ctx.numberArray().number().size() > 0 && (numbers = ctx.numberArray().number().stream().map(op -> this.parseNumericOperand((DataQualityDefinitionLanguageParser.NumberContext)((Object)op), false)).collect(Collectors.toList())).stream().allMatch(Optional::isPresent)) {
            NumberBasedConditionOperator op4 = ctx.NOT() != null ? NumberBasedConditionOperator.NOT_IN : NumberBasedConditionOperator.IN;
            condition = new NumberBasedCondition(exprStr, op4, numbers.stream().map(Optional::get).collect(Collectors.toList()));
        }
        return Optional.ofNullable(condition);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Optional<NumericOperand> parseNumericOperand(DataQualityDefinitionLanguageParser.NumberContext numberContext, boolean isParenthesized) {
        if (numberContext.numberOp() != null) {
            Optional<NumericOperand> operand1 = this.parseNumericOperand(numberContext.number(0), false);
            Optional<NumericOperand> operand2 = this.parseNumericOperand(numberContext.number(1), false);
            if (!operand1.isPresent() || !operand2.isPresent()) return Optional.empty();
            return Optional.of(new BinaryExpressionOperand(numberContext.getText(), numberContext.numberOp().getText(), operand1.get(), operand2.get(), isParenthesized));
        }
        if (numberContext.functionCall() != null) {
            DataQualityDefinitionLanguageParser.FunctionCallContext fcc = numberContext.functionCall();
            String functionName = fcc.IDENTIFIER().getText();
            ArrayList<NumericOperand> arrayList = new ArrayList<NumericOperand>();
            if (fcc.functionParameters() == null) return Optional.of(new FunctionCallOperand(fcc.getText(), functionName, arrayList));
            List parameters = fcc.functionParameters().number().stream().map(op -> this.parseNumericOperand((DataQualityDefinitionLanguageParser.NumberContext)((Object)op), false)).collect(Collectors.toList());
            if (!parameters.stream().allMatch(Optional::isPresent)) return Optional.empty();
            List<NumericOperand> list = parameters.stream().map(Optional::get).collect(Collectors.toList());
            return Optional.of(new FunctionCallOperand(fcc.getText(), functionName, list));
        }
        if (numberContext.LPAREN() != null) {
            return this.parseNumericOperand(numberContext.number(0), true);
        }
        if (numberContext.atomicNumber() != null) {
            return Optional.of(new AtomicNumberOperand(numberContext.getText()));
        }
        if (numberContext.NULL() == null) return Optional.empty();
        return Optional.of(new NullNumericOperand(numberContext.getText()));
    }

    private Optional<Condition> parseStringBasedCondition(DataQualityDefinitionLanguageParser.StringBasedConditionContext ctx) {
        String exprStr = ctx.getText();
        StringBasedCondition condition = null;
        if (ctx.EQUAL_TO() != null) {
            StringOperand operand;
            StringBasedConditionOperator op;
            StringBasedConditionOperator stringBasedConditionOperator = op = ctx.NEGATION() != null ? StringBasedConditionOperator.NOT_EQUALS : StringBasedConditionOperator.EQUALS;
            if (ctx.variableDereference() != null) {
                operand = new VariableReferenceOperand(ctx.variableDereference().IDENTIFIER().getText());
            } else if (ctx.stringValues() != null) {
                Optional<StringOperand> parsedOperand = this.parseStringOperand(ctx, Optional.of(ctx.stringValues()), op);
                if (!parsedOperand.isPresent()) {
                    return Optional.empty();
                }
                operand = parsedOperand.get();
            } else {
                return Optional.empty();
            }
            condition = new StringBasedCondition(exprStr, op, Collections.singletonList(operand));
        } else if (ctx.IN() != null) {
            List<StringOperand> operands;
            StringBasedConditionOperator op;
            StringBasedConditionOperator stringBasedConditionOperator = op = ctx.NOT() != null ? StringBasedConditionOperator.NOT_IN : StringBasedConditionOperator.IN;
            if (ctx.variableDereference() != null) {
                operands = Collections.singletonList(new VariableReferenceOperand(ctx.variableDereference().IDENTIFIER().getText()));
            } else if (ctx.stringValuesArray() != null && ctx.stringValuesArray().stringValues().size() > 0) {
                operands = ctx.stringValuesArray().stringValues().stream().map(s -> this.parseStringOperand(ctx, Optional.of(s), op)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            } else {
                return Optional.empty();
            }
            if (!operands.isEmpty()) {
                condition = new StringBasedCondition(exprStr, op, operands);
            }
        } else if (ctx.matchesRegexCondition() != null) {
            StringBasedConditionOperator op = ctx.NOT() != null ? StringBasedConditionOperator.NOT_MATCHES : StringBasedConditionOperator.MATCHES;
            Optional<StringOperand> operand = this.parseStringOperand(ctx, Optional.ofNullable(ctx.stringValues()), op);
            if (operand.isPresent()) {
                condition = new StringBasedCondition(exprStr, op, Collections.singletonList(operand.get()));
            }
        }
        return Optional.ofNullable(condition);
    }

    private Optional<StringOperand> parseStringOperand(DataQualityDefinitionLanguageParser.StringBasedConditionContext ctx, Optional<DataQualityDefinitionLanguageParser.StringValuesContext> stringValuesContext, StringBasedConditionOperator op) {
        switch (op) {
            case NOT_EQUALS: 
            case EQUALS: {
                Keyword keyword = this.parseKeyword(stringValuesContext.get());
                if (keyword == null) {
                    return Optional.of(new QuotedStringOperand(this.removeQuotes(stringValuesContext.get().quotedString().getText())));
                }
                return Optional.of(new KeywordStringOperand(keyword));
            }
            case NOT_IN: 
            case IN: {
                Keyword keyword = this.parseKeyword(stringValuesContext.get());
                if (keyword == null) {
                    return Optional.of(new QuotedStringOperand(this.removeQuotes(this.removeEscapes(stringValuesContext.get().quotedString().getText()))));
                }
                return Optional.of(new KeywordStringOperand(keyword));
            }
            case MATCHES: 
            case NOT_MATCHES: {
                return Optional.of(new QuotedStringOperand(this.removeQuotes(ctx.matchesRegexCondition().quotedString().getText())));
            }
        }
        return Optional.empty();
    }

    private Optional<Condition> parseDateBasedCondition(DataQualityDefinitionLanguageParser.DateBasedConditionContext ctx, Map<String, String> tags) {
        List expressions;
        String exprStr = ctx.getText();
        DateBasedCondition condition = null;
        if (ctx.BETWEEN() != null && ctx.dateExpression().size() == 2) {
            Optional<DateExpression> lower = this.parseDateExpression(ctx.dateExpression(0), tags);
            Optional<DateExpression> upper = this.parseDateExpression(ctx.dateExpression(1), tags);
            if (lower.isPresent() && upper.isPresent()) {
                DateBasedConditionOperator op = ctx.NOT() != null ? DateBasedConditionOperator.NOT_BETWEEN : DateBasedConditionOperator.BETWEEN;
                condition = new DateBasedCondition(exprStr, op, Arrays.asList(lower.get(), upper.get()));
            }
        } else if (ctx.GREATER_THAN_EQUAL_TO() != null && ctx.dateExpression().size() == 1) {
            Optional<DateExpression> operand = this.parseDateExpression(ctx.dateExpression(0), tags);
            if (operand.isPresent()) {
                condition = new DateBasedCondition(exprStr, DateBasedConditionOperator.GREATER_THAN_EQUAL_TO, Collections.singletonList(operand.get()));
            }
        } else if (ctx.GREATER_THAN() != null && ctx.dateExpression().size() == 1) {
            Optional<DateExpression> operand = this.parseDateExpression(ctx.dateExpression(0), tags);
            if (operand.isPresent()) {
                condition = new DateBasedCondition(exprStr, DateBasedConditionOperator.GREATER_THAN, Collections.singletonList(operand.get()));
            }
        } else if (ctx.LESS_THAN() != null && ctx.dateExpression().size() == 1) {
            Optional<DateExpression> operand = this.parseDateExpression(ctx.dateExpression(0), tags);
            if (operand.isPresent()) {
                condition = new DateBasedCondition(exprStr, DateBasedConditionOperator.LESS_THAN, Collections.singletonList(operand.get()));
            }
        } else if (ctx.LESS_THAN_EQUAL_TO() != null && ctx.dateExpression().size() == 1) {
            Optional<DateExpression> operand = this.parseDateExpression(ctx.dateExpression(0), tags);
            if (operand.isPresent()) {
                condition = new DateBasedCondition(exprStr, DateBasedConditionOperator.LESS_THAN_EQUAL_TO, Collections.singletonList(operand.get()));
            }
        } else if (ctx.EQUAL_TO() != null && ctx.dateExpression().size() == 1) {
            Optional<DateExpression> operand = this.parseDateExpression(ctx.dateExpression(0), tags);
            if (operand.isPresent()) {
                DateBasedConditionOperator op = ctx.NEGATION() != null ? DateBasedConditionOperator.NOT_EQUALS : DateBasedConditionOperator.EQUALS;
                condition = new DateBasedCondition(exprStr, op, Collections.singletonList(operand.get()));
            }
        } else if (ctx.IN() != null && ctx.dateExpressionArray() != null && ctx.dateExpressionArray().dateExpression().size() > 0 && (expressions = ctx.dateExpressionArray().dateExpression().stream().map(x -> this.parseDateExpression((DataQualityDefinitionLanguageParser.DateExpressionContext)((Object)x), tags)).collect(Collectors.toList())).stream().allMatch(Optional::isPresent)) {
            DateBasedConditionOperator op = ctx.NOT() != null ? DateBasedConditionOperator.NOT_IN : DateBasedConditionOperator.IN;
            condition = new DateBasedCondition(exprStr, op, expressions.stream().map(Optional::get).collect(Collectors.toList()));
        }
        return Optional.ofNullable(condition);
    }

    private Optional<Condition> parseDurationBasedCondition(DataQualityDefinitionLanguageParser.DurationBasedConditionContext ctx) {
        List durations;
        String exprStr = ctx.getText();
        DurationBasedCondition condition = null;
        if (ctx.BETWEEN() != null && ctx.durationExpression().size() == 2) {
            Optional<Duration> lower = this.parseDuration(ctx.durationExpression(0));
            Optional<Duration> upper = this.parseDuration(ctx.durationExpression(1));
            if (lower.isPresent() && upper.isPresent()) {
                DurationBasedConditionOperator op = ctx.NOT() != null ? DurationBasedConditionOperator.NOT_BETWEEN : DurationBasedConditionOperator.BETWEEN;
                condition = new DurationBasedCondition(exprStr, op, Arrays.asList(lower.get(), upper.get()));
            }
        } else if (ctx.GREATER_THAN_EQUAL_TO() != null && ctx.durationExpression().size() == 1) {
            Optional<Duration> operand = this.parseDuration(ctx.durationExpression(0));
            if (operand.isPresent()) {
                condition = new DurationBasedCondition(exprStr, DurationBasedConditionOperator.GREATER_THAN_EQUAL_TO, Collections.singletonList(operand.get()));
            }
        } else if (ctx.GREATER_THAN() != null && ctx.durationExpression().size() == 1) {
            Optional<Duration> operand = this.parseDuration(ctx.durationExpression(0));
            if (operand.isPresent()) {
                condition = new DurationBasedCondition(exprStr, DurationBasedConditionOperator.GREATER_THAN, Collections.singletonList(operand.get()));
            }
        } else if (ctx.LESS_THAN() != null && ctx.durationExpression().size() == 1) {
            Optional<Duration> operand = this.parseDuration(ctx.durationExpression(0));
            if (operand.isPresent()) {
                condition = new DurationBasedCondition(exprStr, DurationBasedConditionOperator.LESS_THAN, Collections.singletonList(operand.get()));
            }
        } else if (ctx.LESS_THAN_EQUAL_TO() != null && ctx.durationExpression().size() == 1) {
            Optional<Duration> operand = this.parseDuration(ctx.durationExpression(0));
            if (operand.isPresent()) {
                condition = new DurationBasedCondition(exprStr, DurationBasedConditionOperator.LESS_THAN_EQUAL_TO, Collections.singletonList(operand.get()));
            }
        } else if (ctx.EQUAL_TO() != null && ctx.durationExpression().size() == 1) {
            Optional<Duration> operand = this.parseDuration(ctx.durationExpression(0));
            if (operand.isPresent()) {
                DurationBasedConditionOperator op = ctx.NEGATION() != null ? DurationBasedConditionOperator.NOT_EQUALS : DurationBasedConditionOperator.EQUALS;
                condition = new DurationBasedCondition(exprStr, op, Collections.singletonList(operand.get()));
            }
        } else if (ctx.IN() != null && ctx.durationExpressionArray() != null && ctx.durationExpressionArray().durationExpression().size() > 0 && (durations = ctx.durationExpressionArray().durationExpression().stream().map(this::parseDuration).collect(Collectors.toList())).stream().allMatch(Optional::isPresent)) {
            DurationBasedConditionOperator op = ctx.NOT() != null ? DurationBasedConditionOperator.NOT_IN : DurationBasedConditionOperator.IN;
            condition = new DurationBasedCondition(exprStr, op, durations.stream().map(Optional::get).collect(Collectors.toList()));
        }
        return Optional.ofNullable(condition);
    }

    private Optional<Condition> parseSizeBasedCondition(DataQualityDefinitionLanguageParser.SizeBasedConditionContext ctx) {
        List sizes;
        String exprStr = ctx.getText();
        SizeBasedCondition condition = null;
        if (ctx.BETWEEN() != null && ctx.sizeExpression().size() == 2) {
            Optional<Size> lower = this.parseSize(ctx.sizeExpression(0));
            Optional<Size> upper = this.parseSize(ctx.sizeExpression(1));
            if (lower.isPresent() && upper.isPresent()) {
                SizeBasedConditionOperator op = ctx.NOT() != null ? SizeBasedConditionOperator.NOT_BETWEEN : SizeBasedConditionOperator.BETWEEN;
                condition = new SizeBasedCondition(exprStr, op, Arrays.asList(lower.get(), upper.get()));
            }
        } else if (ctx.GREATER_THAN_EQUAL_TO() != null && ctx.sizeExpression().size() == 1) {
            Optional<Size> operand = this.parseSize(ctx.sizeExpression(0));
            if (operand.isPresent()) {
                condition = new SizeBasedCondition(exprStr, SizeBasedConditionOperator.GREATER_THAN_EQUAL_TO, Collections.singletonList(operand.get()));
            }
        } else if (ctx.GREATER_THAN() != null && ctx.sizeExpression().size() == 1) {
            Optional<Size> operand = this.parseSize(ctx.sizeExpression(0));
            if (operand.isPresent()) {
                condition = new SizeBasedCondition(exprStr, SizeBasedConditionOperator.GREATER_THAN, Collections.singletonList(operand.get()));
            }
        } else if (ctx.LESS_THAN() != null && ctx.sizeExpression().size() == 1) {
            Optional<Size> operand = this.parseSize(ctx.sizeExpression(0));
            if (operand.isPresent()) {
                condition = new SizeBasedCondition(exprStr, SizeBasedConditionOperator.LESS_THAN, Collections.singletonList(operand.get()));
            }
        } else if (ctx.LESS_THAN_EQUAL_TO() != null && ctx.sizeExpression().size() == 1) {
            Optional<Size> operand = this.parseSize(ctx.sizeExpression(0));
            if (operand.isPresent()) {
                condition = new SizeBasedCondition(exprStr, SizeBasedConditionOperator.LESS_THAN_EQUAL_TO, Collections.singletonList(operand.get()));
            }
        } else if (ctx.EQUAL_TO() != null && ctx.sizeExpression().size() == 1) {
            Optional<Size> operand = this.parseSize(ctx.sizeExpression(0));
            if (operand.isPresent()) {
                SizeBasedConditionOperator op = ctx.NEGATION() != null ? SizeBasedConditionOperator.NOT_EQUALS : SizeBasedConditionOperator.EQUALS;
                condition = new SizeBasedCondition(exprStr, op, Collections.singletonList(operand.get()));
            }
        } else if (ctx.IN() != null && ctx.sizeExpressionArray() != null && ctx.sizeExpressionArray().sizeExpression().size() > 0 && (sizes = ctx.sizeExpressionArray().sizeExpression().stream().map(this::parseSize).collect(Collectors.toList())).stream().allMatch(Optional::isPresent)) {
            SizeBasedConditionOperator op = ctx.NOT() != null ? SizeBasedConditionOperator.NOT_IN : SizeBasedConditionOperator.IN;
            condition = new SizeBasedCondition(exprStr, op, sizes.stream().map(Optional::get).collect(Collectors.toList()));
        }
        return Optional.ofNullable(condition);
    }

    private Optional<DateExpression> parseDateExpression(DataQualityDefinitionLanguageParser.DateExpressionContext ctx, Map<String, String> tags) {
        if (ctx.durationExpression() != null) {
            Optional<Duration> duration = this.parseDuration(ctx.durationExpression());
            return duration.map(value -> new DateExpression.CurrentDateExpression(ctx.dateExpressionOp().getText().equals("-") ? DateExpression.DateExpressionOperator.MINUS : DateExpression.DateExpressionOperator.PLUS, (Duration)value));
        }
        if (ctx.dateNow() != null) {
            return Optional.of(new DateExpression.CurrentDate());
        }
        if (ctx.NULL() != null) {
            return Optional.of(new NullDateExpression());
        }
        if (ctx.timeExpression() != null) {
            String time = this.removeQuotes(ctx.timeExpression().MIL_TIME() != null ? ctx.timeExpression().MIL_TIME().getText() : ctx.timeExpression().TIME().getText());
            String pattern = ctx.timeExpression().MIL_TIME() != null ? MILITARY_TIME_FORMAT : AMPM_TIME_FORMAT;
            String timeZone = tags.getOrDefault("timeZone", "UTC");
            return this.parseTime(time, pattern, timeZone);
        }
        return Optional.of(new DateExpression.StaticDate(this.removeQuotes(ctx.DATE().getText())));
    }

    private Optional<DateExpression> parseTime(String in, String pattern, String timeZone) {
        try {
            ZoneId zoneId = ZoneId.of(timeZone);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
            LocalTime time = LocalTime.parse(in, formatter);
            LocalDate today = LocalDate.now();
            LocalDateTime localDateTime = LocalDateTime.of(today, time);
            ZonedDateTime zonedDateTime = localDateTime.atZone(zoneId);
            ZonedDateTime utcTime = zonedDateTime.withZoneSameInstant(ZoneOffset.UTC);
            return Optional.of(new DateExpression.StaticDateTime(utcTime.toLocalDateTime(), in));
        }
        catch (DateTimeParseException e) {
            this.errorMessages.add(String.format("Error Parsing Date: %s. %s.", in, e.getMessage()));
            return Optional.empty();
        }
        catch (ZoneRulesException e) {
            this.errorMessages.add(String.format("Error Parsing Time Zone: %s. %s.", timeZone, e.getMessage()));
            return Optional.empty();
        }
    }

    private Optional<Duration> parseDuration(DataQualityDefinitionLanguageParser.DurationExpressionContext ctx) {
        int amount = Integer.parseInt(ctx.INT() != null ? ctx.INT().getText() : ctx.DIGIT().getText());
        if (ctx.durationUnit().exception != null) {
            return Optional.empty();
        }
        DurationUnit unit = DurationUnit.valueOf(ctx.durationUnit().getText().toUpperCase());
        return Optional.of(new Duration(amount, unit));
    }

    private Optional<Size> parseSize(DataQualityDefinitionLanguageParser.SizeExpressionContext ctx) {
        int amount = Integer.parseInt(ctx.INT() != null ? ctx.INT().getText() : ctx.DIGIT().getText());
        if (ctx.sizeUnit().exception != null) {
            return Optional.empty();
        }
        SizeUnit unit = SizeUnit.valueOf(ctx.sizeUnit().getText().toUpperCase());
        return Optional.of(new Size(amount, unit));
    }

    private String removeQuotes(String quotedString) {
        if (quotedString.startsWith("\"") && quotedString.endsWith("\"")) {
            quotedString = quotedString.substring(1);
            quotedString = quotedString.substring(0, quotedString.length() - 1);
        }
        return quotedString;
    }

    private String removeEscapes(String stringWithEscapes) {
        stringWithEscapes = stringWithEscapes.replaceAll("\\\\(.)", "$1");
        return stringWithEscapes;
    }

    private List<DQRuleParameterValue> parseParameters(List<DataQualityDefinitionLanguageParser.ParameterWithConnectorWordContext> parameters) {
        if (parameters == null) {
            return new ArrayList<DQRuleParameterValue>();
        }
        return parameters.stream().map(this::parseParameter).collect(Collectors.toList());
    }

    private DQRuleParameterValue parseParameter(DataQualityDefinitionLanguageParser.ParameterWithConnectorWordContext pc) {
        String connectorWord;
        String string = connectorWord = pc.connectorWord() == null ? "" : pc.connectorWord().getText();
        if (pc.parameter().QUOTED_STRING() != null) {
            return new DQRuleParameterValue(this.removeQuotes(pc.parameter().QUOTED_STRING().getText()), true, connectorWord);
        }
        if (pc.parameter().IDENTIFIER() != null) {
            return new DQRuleParameterValue(pc.parameter().IDENTIFIER().getText(), false, connectorWord);
        }
        return new DQRuleParameterValue(pc.parameter().getText(), true, connectorWord);
    }

    private List<String> validateDictionary(DataQualityDefinitionLanguageParser.DictionaryContext dc) {
        ArrayList<String> dictionaryErrors = new ArrayList<String>();
        if (dc.pair() == null || dc.pair().size() == 1 && dc.pair().get(0).getText().isEmpty()) {
            dictionaryErrors.add("Empty dictionary provided");
        }
        return dictionaryErrors;
    }

    private Keyword parseKeyword(DataQualityDefinitionLanguageParser.StringValuesContext stringValuesContext) {
        Keyword keyword = null;
        try {
            Method method;
            Object result;
            String operand = stringValuesContext.getText().toUpperCase();
            if (this.isValidEnumValue(operand) && (result = (method = ((Object)((Object)stringValuesContext)).getClass().getMethod(operand, new Class[0])).invoke((Object)stringValuesContext, new Object[0])) != null) {
                keyword = Keyword.valueOf(operand);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            this.errorMessages.add(e.getMessage());
        }
        return keyword;
    }

    private boolean isValidEnumValue(String value) {
        try {
            Enum.valueOf(Keyword.class, value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private String processStringValues(DataQualityDefinitionLanguageParser.StringValuesContext sv) {
        if (sv.quotedString() != null) {
            return this.removeQuotes(sv.quotedString().getText());
        }
        return sv.getText();
    }

    static {
        ALLOWED_METADATA_KEYS.add(METADATA_VERSION_KEY);
        ALLOWED_SOURCES_KEYS = new HashSet<String>();
        ALLOWED_SOURCES_KEYS.add(PRIMARY_SOURCE_KEY);
        ALLOWED_SOURCES_KEYS.add(ADDITIONAL_SOURCES_KEY);
    }
}

