/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.glue.dqdl.parser;

import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.glue.dqdl.DataQualityDefinitionLanguageLexer;
import software.amazon.glue.dqdl.DataQualityDefinitionLanguageParser;
import software.amazon.glue.dqdl.exception.InvalidDataQualityRulesetException;
import software.amazon.glue.dqdl.model.DQRuleset;
import software.amazon.glue.dqdl.parser.DQDLErrorListener;
import software.amazon.glue.dqdl.parser.DQDLParserListener;
import software.amazon.glue.dqdl.util.Either;

public class DQDLParser {
    private static final Logger log = LoggerFactory.getLogger(DQDLParser.class);
    private static final String PARSING_ERROR_MESSAGE_PREFIX = "Parsing Error";

    public DQRuleset parse(String dqdl) throws InvalidDataQualityRulesetException {
        CodePointCharStream input = CharStreams.fromString((String)dqdl);
        DQDLErrorListener errorListener = new DQDLErrorListener();
        DataQualityDefinitionLanguageLexer lexer = new DataQualityDefinitionLanguageLexer((CharStream)input);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        DataQualityDefinitionLanguageParser parser = new DataQualityDefinitionLanguageParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        DQDLParserListener listener = new DQDLParserListener(errorListener);
        try {
            ParseTreeWalker.DEFAULT.walk((ParseTreeListener)listener, (ParseTree)parser.document());
        }
        catch (StringIndexOutOfBoundsException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new InvalidDataQualityRulesetException("Invalid DQDL.");
        }
        Either<List<String>, DQRuleset> dqRulesetEither = listener.getParsedRuleset();
        if (dqRulesetEither.isLeft()) {
            throw new InvalidDataQualityRulesetException(this.generateExceptionMessage(dqRulesetEither.getLeft()));
        }
        return dqRulesetEither.getRight();
    }

    private String generateExceptionMessage(List<String> errorMessages) {
        String message = PARSING_ERROR_MESSAGE_PREFIX;
        if (!errorMessages.isEmpty()) {
            String delimiter = ", ";
            message = message + ": " + String.join((CharSequence)delimiter, errorMessages);
        }
        return message;
    }
}

