/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.glue.dqdl.model.condition.string;

import java.util.List;
import java.util.stream.Collectors;
import software.amazon.glue.dqdl.model.condition.Condition;
import software.amazon.glue.dqdl.model.condition.string.StringBasedConditionOperator;
import software.amazon.glue.dqdl.model.condition.string.StringOperand;
import software.amazon.glue.dqdl.model.condition.variable.VariableReferenceOperand;
import software.amazon.glue.dqdl.util.StringUtils;

public class StringBasedCondition
extends Condition {
    private final StringBasedConditionOperator operator;
    private final List<StringOperand> operands;
    private final List<StringOperand> unresolvedOperands;

    public StringBasedCondition(String conditionAsString, StringBasedConditionOperator operator, List<StringOperand> operands) {
        this(conditionAsString, operator, operands, null);
    }

    public StringBasedCondition(String conditionAsString, StringBasedConditionOperator operator, List<StringOperand> operands, List<StringOperand> unresolvedOperands) {
        super(conditionAsString);
        this.operator = operator;
        this.operands = operands;
        this.unresolvedOperands = unresolvedOperands;
    }

    @Override
    public String getFormattedCondition() {
        if (StringUtils.isBlank(this.conditionAsString)) {
            return "";
        }
        List<StringOperand> effectiveOperands = this.getEffectiveOperands();
        switch (this.operator) {
            case MATCHES: {
                return String.format("matches %s", effectiveOperands.get(0).formatOperand());
            }
            case NOT_MATCHES: {
                return String.format("not matches %s", effectiveOperands.get(0).formatOperand());
            }
            case EQUALS: {
                return String.format("= %s", effectiveOperands.get(0).formatOperand());
            }
            case NOT_EQUALS: {
                return String.format("!= %s", effectiveOperands.get(0).formatOperand());
            }
            case IN: {
                return this.formatInCondition(false, false);
            }
            case NOT_IN: {
                return this.formatInCondition(true, false);
            }
        }
        return "";
    }

    @Override
    public String getSortedFormattedCondition() {
        if (StringUtils.isBlank(this.conditionAsString)) {
            return "";
        }
        switch (this.operator) {
            case IN: {
                return this.formatInCondition(false, true);
            }
            case NOT_IN: {
                return this.formatInCondition(true, true);
            }
        }
        return this.getFormattedCondition();
    }

    private String formatInCondition(boolean isNot, boolean sorted) {
        List<StringOperand> effectiveOperands = this.getEffectiveOperands();
        List<String> formattedOperands = sorted ? this.getSortedFormattedOperands(effectiveOperands) : this.getFormattedOperands(effectiveOperands);
        String operandStr = formattedOperands.size() == 1 && effectiveOperands.get(0) instanceof VariableReferenceOperand ? formattedOperands.get(0) : "[" + String.join((CharSequence)",", formattedOperands) + "]";
        return String.format("%sin %s", isNot ? "not " : "", operandStr);
    }

    private List<String> getFormattedOperands(List<StringOperand> operands) {
        return operands.stream().map(StringOperand::formatOperand).collect(Collectors.toList());
    }

    private List<String> getSortedFormattedOperands(List<StringOperand> operands) {
        return operands.stream().map(StringOperand::formatOperand).sorted().collect(Collectors.toList());
    }

    private List<StringOperand> getEffectiveOperands() {
        return this.unresolvedOperands != null ? this.unresolvedOperands : this.operands;
    }

    public StringBasedConditionOperator getOperator() {
        return this.operator;
    }

    public List<StringOperand> getOperands() {
        return this.operands;
    }

    public List<StringOperand> getUnresolvedOperands() {
        return this.unresolvedOperands;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringBasedCondition)) {
            return false;
        }
        StringBasedCondition other = (StringBasedCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StringBasedConditionOperator this$operator = this.getOperator();
        StringBasedConditionOperator other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !((Object)((Object)this$operator)).equals((Object)other$operator)) {
            return false;
        }
        List<StringOperand> this$operands = this.getOperands();
        List<StringOperand> other$operands = other.getOperands();
        if (this$operands == null ? other$operands != null : !((Object)this$operands).equals(other$operands)) {
            return false;
        }
        List<StringOperand> this$unresolvedOperands = this.getUnresolvedOperands();
        List<StringOperand> other$unresolvedOperands = other.getUnresolvedOperands();
        return !(this$unresolvedOperands == null ? other$unresolvedOperands != null : !((Object)this$unresolvedOperands).equals(other$unresolvedOperands));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StringBasedCondition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        StringBasedConditionOperator $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : ((Object)((Object)$operator)).hashCode());
        List<StringOperand> $operands = this.getOperands();
        result = result * 59 + ($operands == null ? 43 : ((Object)$operands).hashCode());
        List<StringOperand> $unresolvedOperands = this.getUnresolvedOperands();
        result = result * 59 + ($unresolvedOperands == null ? 43 : ((Object)$unresolvedOperands).hashCode());
        return result;
    }
}

