/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.glue.dqdl.model.condition.size;

import java.util.List;
import java.util.stream.Collectors;
import software.amazon.glue.dqdl.model.condition.Condition;
import software.amazon.glue.dqdl.model.condition.size.Size;
import software.amazon.glue.dqdl.model.condition.size.SizeBasedConditionOperator;
import software.amazon.glue.dqdl.util.StringUtils;

public class SizeBasedCondition
extends Condition {
    private final SizeBasedConditionOperator operator;
    private final List<Size> operands;

    public SizeBasedCondition(String conditionAsString, SizeBasedConditionOperator operator, List<Size> operands) {
        super(conditionAsString);
        this.operator = operator;
        this.operands = operands;
    }

    @Override
    public String getFormattedCondition() {
        if (this.operands.isEmpty()) {
            return "";
        }
        switch (this.operator) {
            case BETWEEN: {
                return String.format("between %s and %s", this.operands.get(0).getFormattedSize(), this.operands.get(1).getFormattedSize());
            }
            case NOT_BETWEEN: {
                return String.format("not between %s and %s", this.operands.get(0).getFormattedSize(), this.operands.get(1).getFormattedSize());
            }
            case GREATER_THAN: {
                return String.format("> %s", this.operands.get(0).getFormattedSize());
            }
            case GREATER_THAN_EQUAL_TO: {
                return String.format(">= %s", this.operands.get(0).getFormattedSize());
            }
            case LESS_THAN: {
                return String.format("< %s", this.operands.get(0).getFormattedSize());
            }
            case LESS_THAN_EQUAL_TO: {
                return String.format("<= %s", this.operands.get(0).getFormattedSize());
            }
            case EQUALS: {
                return String.format("= %s", this.operands.get(0).getFormattedSize());
            }
            case NOT_EQUALS: {
                return String.format("!= %s", this.operands.get(0).getFormattedSize());
            }
            case IN: {
                List<String> formattedOperands = this.getFormattedOperands();
                return String.format("in [%s]", String.join((CharSequence)",", formattedOperands));
            }
            case NOT_IN: {
                List<String> formattedOperands = this.getFormattedOperands();
                return String.format("not in [%s]", String.join((CharSequence)",", formattedOperands));
            }
        }
        return "";
    }

    @Override
    public String getSortedFormattedCondition() {
        if (StringUtils.isBlank(this.conditionAsString)) {
            return "";
        }
        switch (this.operator) {
            case IN: {
                return String.format("in [%s]", String.join((CharSequence)",", this.getSortedFormattedOperands()));
            }
            case NOT_IN: {
                return String.format("not in [%s]", String.join((CharSequence)",", this.getSortedFormattedOperands()));
            }
        }
        return this.getFormattedCondition();
    }

    private List<String> getFormattedOperands() {
        return this.operands.stream().map(Size::getFormattedSize).collect(Collectors.toList());
    }

    private List<String> getSortedFormattedOperands() {
        return this.operands.stream().map(Size::getFormattedSize).sorted().collect(Collectors.toList());
    }

    public SizeBasedConditionOperator getOperator() {
        return this.operator;
    }

    public List<Size> getOperands() {
        return this.operands;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SizeBasedCondition)) {
            return false;
        }
        SizeBasedCondition other = (SizeBasedCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SizeBasedConditionOperator this$operator = this.getOperator();
        SizeBasedConditionOperator other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !((Object)((Object)this$operator)).equals((Object)other$operator)) {
            return false;
        }
        List<Size> this$operands = this.getOperands();
        List<Size> other$operands = other.getOperands();
        return !(this$operands == null ? other$operands != null : !((Object)this$operands).equals(other$operands));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SizeBasedCondition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        SizeBasedConditionOperator $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : ((Object)((Object)$operator)).hashCode());
        List<Size> $operands = this.getOperands();
        result = result * 59 + ($operands == null ? 43 : ((Object)$operands).hashCode());
        return result;
    }
}

