/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.glue.dqdl.model.condition.size;

import java.io.Serializable;
import software.amazon.glue.dqdl.model.condition.size.SizeUnit;

public class Size
implements Serializable,
Comparable<Size> {
    private final Integer amount;
    private final SizeUnit unit;
    private final Long bytes;

    public Size(Integer amount, SizeUnit unit) {
        this.amount = amount;
        this.unit = unit;
        this.bytes = this.convertBytes(amount, unit);
    }

    public String getFormattedSize() {
        return String.format("%s %s", this.amount, this.unit.name().toUpperCase());
    }

    private Long convertBytes(Integer bytes, SizeUnit unit) {
        switch (unit) {
            case KB: {
                return (long)bytes.intValue() * 1024L;
            }
            case MB: {
                return (long)bytes.intValue() * 1024L * 1024L;
            }
            case GB: {
                return (long)bytes.intValue() * 1024L * 1024L * 1024L;
            }
            case TB: {
                return (long)bytes.intValue() * 1024L * 1024L * 1024L * 1024L;
            }
        }
        return (long)bytes;
    }

    @Override
    public int compareTo(Size other) {
        return Long.compare(this.getBytes(), other.getBytes());
    }

    public Integer getAmount() {
        return this.amount;
    }

    public SizeUnit getUnit() {
        return this.unit;
    }

    public Long getBytes() {
        return this.bytes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Size)) {
            return false;
        }
        Size other = (Size)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$amount = this.getAmount();
        Integer other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$bytes = this.getBytes();
        Long other$bytes = other.getBytes();
        if (this$bytes == null ? other$bytes != null : !((Object)this$bytes).equals(other$bytes)) {
            return false;
        }
        SizeUnit this$unit = this.getUnit();
        SizeUnit other$unit = other.getUnit();
        return !(this$unit == null ? other$unit != null : !((Object)((Object)this$unit)).equals((Object)other$unit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Size;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $bytes = this.getBytes();
        result = result * 59 + ($bytes == null ? 43 : ((Object)$bytes).hashCode());
        SizeUnit $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : ((Object)((Object)$unit)).hashCode());
        return result;
    }
}

