/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.glue.dqdl.model.condition.number;

import java.text.DecimalFormat;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.glue.dqdl.model.DQRule;
import software.amazon.glue.dqdl.model.condition.Condition;
import software.amazon.glue.dqdl.model.condition.number.NumberBasedConditionOperator;
import software.amazon.glue.dqdl.model.condition.number.NumericOperand;
import software.amazon.glue.dqdl.model.condition.number.OperandEvaluator;
import software.amazon.glue.dqdl.util.StringUtils;

public class NumberBasedCondition
extends Condition {
    private static final Logger log = LoggerFactory.getLogger(NumberBasedCondition.class);
    private final NumberBasedConditionOperator operator;
    private final List<NumericOperand> operands;
    private static final DecimalFormat OP_FORMAT = new DecimalFormat("#.###");

    public NumberBasedCondition(String conditionAsString, NumberBasedConditionOperator operator, List<NumericOperand> operands) {
        super(conditionAsString);
        this.operator = operator;
        this.operands = operands;
    }

    @Override
    public Boolean evaluate(Double metric, DQRule dqRule, OperandEvaluator evaluator) {
        if (this.operands == null) {
            return false;
        }
        List operandsAsDouble = this.operands.stream().map(operand -> evaluator.evaluate(dqRule, (NumericOperand)operand)).collect(Collectors.toList());
        log.info(String.format("Evaluating condition for rule: %s", dqRule));
        List formatOps = operandsAsDouble.stream().map(OP_FORMAT::format).collect(Collectors.toList());
        String formatMetric = OP_FORMAT.format(metric);
        switch (this.operator) {
            case BETWEEN: {
                if (this.operands.size() != 2) {
                    return false;
                }
                boolean result = metric > (Double)operandsAsDouble.get(0) && metric < (Double)operandsAsDouble.get(1);
                log.info("{} between {} and {}? {}", new Object[]{formatMetric, formatOps.get(0), formatOps.get(1), result});
                return result;
            }
            case NOT_BETWEEN: {
                if (this.operands.size() != 2) {
                    return false;
                }
                boolean result = metric <= (Double)operandsAsDouble.get(0) || metric >= (Double)operandsAsDouble.get(1);
                log.info("{} not between {} and {}? {}", new Object[]{formatMetric, formatOps.get(0), formatOps.get(1), result});
                return result;
            }
            case GREATER_THAN_EQUAL_TO: {
                if (this.operands.size() != 1) {
                    return false;
                }
                boolean result = metric >= (Double)operandsAsDouble.get(0);
                log.info("{} >= {}? {}", new Object[]{formatMetric, formatOps.get(0), result});
                return result;
            }
            case GREATER_THAN: {
                if (this.operands.size() != 1) {
                    return false;
                }
                boolean result = metric > (Double)operandsAsDouble.get(0);
                log.info("{} > {}? {}", new Object[]{formatMetric, formatOps.get(0), result});
                return result;
            }
            case LESS_THAN_EQUAL_TO: {
                if (this.operands.size() != 1) {
                    return false;
                }
                boolean result = metric <= (Double)operandsAsDouble.get(0);
                log.info("{} <= {}? {}", new Object[]{formatMetric, formatOps.get(0), result});
                return result;
            }
            case LESS_THAN: {
                if (this.operands.size() != 1) {
                    return false;
                }
                boolean result = metric < (Double)operandsAsDouble.get(0);
                log.info("{} < {}? {}", new Object[]{formatMetric, formatOps.get(0), result});
                return result;
            }
            case EQUALS: {
                if (this.operands.size() != 1) {
                    return false;
                }
                boolean result = this.isOperandEqualToMetric(metric, (Double)operandsAsDouble.get(0));
                log.info("{} == {}? {}", new Object[]{formatMetric, formatOps.get(0), result});
                return result;
            }
            case NOT_EQUALS: {
                if (this.operands.size() != 1) {
                    return false;
                }
                boolean result = !this.isOperandEqualToMetric(metric, (Double)operandsAsDouble.get(0));
                log.info("{} != {}? {}", new Object[]{formatMetric, formatOps.get(0), result});
                return result;
            }
            case IN: {
                boolean result = operandsAsDouble.stream().anyMatch(operand -> this.isOperandEqualToMetric(metric, (Double)operand));
                log.info("{} in {}? {}", new Object[]{formatMetric, formatOps, result});
                return result;
            }
            case NOT_IN: {
                boolean result = !operandsAsDouble.stream().anyMatch(operand -> this.isOperandEqualToMetric(metric, (Double)operand));
                log.info("{} not in {}? {}", new Object[]{formatMetric, formatOps, result});
                return result;
            }
        }
        log.error("Unknown operator");
        return false;
    }

    @Override
    public String getFormattedCondition() {
        if (StringUtils.isBlank(this.conditionAsString)) {
            return "";
        }
        switch (this.operator) {
            case BETWEEN: {
                return String.format("between %s and %s", this.operands.get(0).toString(), this.operands.get(1).toString());
            }
            case NOT_BETWEEN: {
                return String.format("not between %s and %s", this.operands.get(0).toString(), this.operands.get(1).toString());
            }
            case GREATER_THAN: {
                return String.format("> %s", this.operands.get(0).toString());
            }
            case GREATER_THAN_EQUAL_TO: {
                return String.format(">= %s", this.operands.get(0).toString());
            }
            case LESS_THAN: {
                return String.format("< %s", this.operands.get(0).toString());
            }
            case LESS_THAN_EQUAL_TO: {
                return String.format("<= %s", this.operands.get(0).toString());
            }
            case EQUALS: {
                return String.format("= %s", this.operands.get(0).toString());
            }
            case NOT_EQUALS: {
                return String.format("!= %s", this.operands.get(0).toString());
            }
            case IN: {
                return String.format("in [%s]", this.getFormattedOperands());
            }
            case NOT_IN: {
                return String.format("not in [%s]", this.getFormattedOperands());
            }
        }
        return "";
    }

    @Override
    public String getSortedFormattedCondition() {
        if (StringUtils.isBlank(this.conditionAsString)) {
            return "";
        }
        switch (this.operator) {
            case IN: {
                return String.format("in [%s]", this.getSortedFormattedOperands());
            }
            case NOT_IN: {
                return String.format("not in [%s]", this.getSortedFormattedOperands());
            }
        }
        return this.getFormattedCondition();
    }

    private String getFormattedOperands() {
        return this.operands.stream().map(Object::toString).collect(Collectors.joining(","));
    }

    private String getSortedFormattedOperands() {
        return this.operands.stream().map(Object::toString).sorted((s1, s2) -> {
            if (s1.equalsIgnoreCase("NULL") && s2.equalsIgnoreCase("NULL")) {
                return 0;
            }
            if (s1.equalsIgnoreCase("NULL")) {
                return 1;
            }
            if (s2.equalsIgnoreCase("NULL")) {
                return -1;
            }
            return Double.compare(Double.parseDouble(s1), Double.parseDouble(s2));
        }).collect(Collectors.joining(","));
    }

    protected boolean isOperandEqualToMetric(Double metric, Double operand) {
        return Math.abs(metric - operand) <= 1.0E-5;
    }

    public NumberBasedConditionOperator getOperator() {
        return this.operator;
    }

    public List<NumericOperand> getOperands() {
        return this.operands;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NumberBasedCondition)) {
            return false;
        }
        NumberBasedCondition other = (NumberBasedCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NumberBasedConditionOperator this$operator = this.getOperator();
        NumberBasedConditionOperator other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !((Object)((Object)this$operator)).equals((Object)other$operator)) {
            return false;
        }
        List<NumericOperand> this$operands = this.getOperands();
        List<NumericOperand> other$operands = other.getOperands();
        return !(this$operands == null ? other$operands != null : !((Object)this$operands).equals(other$operands));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NumberBasedCondition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        NumberBasedConditionOperator $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : ((Object)((Object)$operator)).hashCode());
        List<NumericOperand> $operands = this.getOperands();
        result = result * 59 + ($operands == null ? 43 : ((Object)$operands).hashCode());
        return result;
    }
}

