/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.glue.dqdl.model.condition.number;

import java.util.List;
import java.util.stream.Collectors;
import software.amazon.glue.dqdl.model.condition.number.NumericOperand;

public class FunctionCallOperand
extends NumericOperand {
    private final String functionName;
    private final List<NumericOperand> operands;

    public FunctionCallOperand(String operand, String functionName, List<NumericOperand> operands) {
        super(operand);
        this.functionName = functionName;
        this.operands = operands;
    }

    public String toString() {
        String params = this.operands.stream().map(Object::toString).collect(Collectors.joining(","));
        String formatted = String.format("%s(%s)", this.functionName, params);
        if (this.isParenthesized()) {
            return String.format("(%s)", formatted);
        }
        return formatted;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<NumericOperand> getOperands() {
        return this.operands;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionCallOperand)) {
            return false;
        }
        FunctionCallOperand other = (FunctionCallOperand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$functionName = this.getFunctionName();
        String other$functionName = other.getFunctionName();
        if (this$functionName == null ? other$functionName != null : !this$functionName.equals(other$functionName)) {
            return false;
        }
        List<NumericOperand> this$operands = this.getOperands();
        List<NumericOperand> other$operands = other.getOperands();
        return !(this$operands == null ? other$operands != null : !((Object)this$operands).equals(other$operands));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FunctionCallOperand;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $functionName = this.getFunctionName();
        result = result * 59 + ($functionName == null ? 43 : $functionName.hashCode());
        List<NumericOperand> $operands = this.getOperands();
        result = result * 59 + ($operands == null ? 43 : ((Object)$operands).hashCode());
        return result;
    }
}

