/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.glue.dqdl.model.condition.duration;

import java.util.List;
import java.util.stream.Collectors;
import software.amazon.glue.dqdl.model.condition.Condition;
import software.amazon.glue.dqdl.model.condition.duration.Duration;
import software.amazon.glue.dqdl.model.condition.duration.DurationBasedConditionOperator;
import software.amazon.glue.dqdl.util.StringUtils;

public class DurationBasedCondition
extends Condition {
    private final DurationBasedConditionOperator operator;
    private final List<Duration> operands;

    public DurationBasedCondition(String conditionAsString, DurationBasedConditionOperator operator, List<Duration> operands) {
        super(conditionAsString);
        this.operator = operator;
        this.operands = operands;
    }

    @Override
    public String getFormattedCondition() {
        if (this.operands.isEmpty()) {
            return "";
        }
        switch (this.operator) {
            case BETWEEN: {
                return String.format("between %s and %s", this.operands.get(0).getFormattedDuration(), this.operands.get(1).getFormattedDuration());
            }
            case NOT_BETWEEN: {
                return String.format("not between %s and %s", this.operands.get(0).getFormattedDuration(), this.operands.get(1).getFormattedDuration());
            }
            case GREATER_THAN: {
                return String.format("> %s", this.operands.get(0).getFormattedDuration());
            }
            case GREATER_THAN_EQUAL_TO: {
                return String.format(">= %s", this.operands.get(0).getFormattedDuration());
            }
            case LESS_THAN: {
                return String.format("< %s", this.operands.get(0).getFormattedDuration());
            }
            case LESS_THAN_EQUAL_TO: {
                return String.format("<= %s", this.operands.get(0).getFormattedDuration());
            }
            case EQUALS: {
                return String.format("= %s", this.operands.get(0).getFormattedDuration());
            }
            case NOT_EQUALS: {
                return String.format("!= %s", this.operands.get(0).getFormattedDuration());
            }
            case IN: {
                List<String> formattedOperands = this.getFormattedOperands();
                return String.format("in [%s]", String.join((CharSequence)",", formattedOperands));
            }
            case NOT_IN: {
                List<String> formattedOperands = this.getFormattedOperands();
                return String.format("not in [%s]", String.join((CharSequence)",", formattedOperands));
            }
        }
        return "";
    }

    @Override
    public String getSortedFormattedCondition() {
        if (StringUtils.isBlank(this.conditionAsString)) {
            return "";
        }
        switch (this.operator) {
            case IN: {
                return String.format("in [%s]", String.join((CharSequence)",", this.getSortedFormattedOperands()));
            }
            case NOT_IN: {
                return String.format("not in [%s]", String.join((CharSequence)",", this.getSortedFormattedOperands()));
            }
        }
        return this.getFormattedCondition();
    }

    private List<String> getFormattedOperands() {
        return this.operands.stream().map(Duration::getFormattedDuration).collect(Collectors.toList());
    }

    private List<String> getSortedFormattedOperands() {
        return this.operands.stream().map(Duration::getFormattedDuration).sorted().collect(Collectors.toList());
    }

    public DurationBasedConditionOperator getOperator() {
        return this.operator;
    }

    public List<Duration> getOperands() {
        return this.operands;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DurationBasedCondition)) {
            return false;
        }
        DurationBasedCondition other = (DurationBasedCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DurationBasedConditionOperator this$operator = this.getOperator();
        DurationBasedConditionOperator other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !((Object)((Object)this$operator)).equals((Object)other$operator)) {
            return false;
        }
        List<Duration> this$operands = this.getOperands();
        List<Duration> other$operands = other.getOperands();
        return !(this$operands == null ? other$operands != null : !((Object)this$operands).equals(other$operands));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DurationBasedCondition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        DurationBasedConditionOperator $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : ((Object)((Object)$operator)).hashCode());
        List<Duration> $operands = this.getOperands();
        result = result * 59 + ($operands == null ? 43 : ((Object)$operands).hashCode());
        return result;
    }
}

