/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.glue.dqdl.model.condition.date;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import software.amazon.glue.dqdl.model.condition.duration.Duration;

public abstract class DateExpression
implements Serializable {
    public abstract String getFormattedExpression();

    public abstract LocalDateTime getEvaluatedExpression();

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DateExpression)) {
            return false;
        }
        DateExpression other = (DateExpression)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof DateExpression;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public static class CurrentDateExpression
    extends DateExpression {
        private final DateExpressionOperator operator;
        private final Duration duration;

        @Override
        public String getFormattedExpression() {
            switch (this.operator) {
                case MINUS: {
                    return String.format("(now() - %s)", this.duration.getFormattedDuration());
                }
                case PLUS: {
                    return String.format("(now() + %s)", this.duration.getFormattedDuration());
                }
            }
            return "";
        }

        @Override
        public LocalDateTime getEvaluatedExpression() {
            switch (this.duration.getUnit()) {
                case MINUTES: {
                    return this.evaluateMinutes(this.operator, this.duration.getAmount(), LocalDateTime.now(ZoneOffset.UTC));
                }
                case HOURS: {
                    return this.evaluateMinutes(this.operator, this.duration.getAmount() * 60, LocalDateTime.now(ZoneOffset.UTC).withMinute(0));
                }
                case DAYS: {
                    return this.evaluateMinutes(this.operator, this.duration.getAmount() * 60 * 24, LocalDateTime.now(ZoneOffset.UTC).withMinute(0));
                }
            }
            throw new RuntimeException("Unsupported duration unit: " + (Object)((Object)this.duration.getUnit()));
        }

        private LocalDateTime evaluateMinutes(DateExpressionOperator operator, int minutes, LocalDateTime dt) {
            dt = dt.withSecond(0).withNano(0);
            switch (operator) {
                case MINUS: {
                    return dt.minusMinutes(minutes);
                }
                case PLUS: {
                    return dt.plusMinutes(minutes);
                }
            }
            return dt;
        }

        public DateExpressionOperator getOperator() {
            return this.operator;
        }

        public Duration getDuration() {
            return this.duration;
        }

        public CurrentDateExpression(DateExpressionOperator operator, Duration duration) {
            this.operator = operator;
            this.duration = duration;
        }
    }

    public static enum DateExpressionOperator {
        MINUS,
        PLUS;

    }

    public static class StaticDateTime
    extends DateExpression {
        private final LocalDateTime dateTime;
        private final String dateTimeString;

        @Override
        public String getFormattedExpression() {
            return "\"" + this.dateTimeString + "\"";
        }

        @Override
        public LocalDateTime getEvaluatedExpression() {
            return this.dateTime;
        }

        public StaticDateTime(LocalDateTime dateTime, String dateTimeString) {
            this.dateTime = dateTime;
            this.dateTimeString = dateTimeString;
        }
    }

    public static class CurrentDate
    extends DateExpression {
        @Override
        public String getFormattedExpression() {
            return "now()";
        }

        @Override
        public LocalDateTime getEvaluatedExpression() {
            return LocalDateTime.now(ZoneOffset.UTC);
        }
    }

    public static class StaticDate
    extends DateExpression {
        private final String date;

        @Override
        public String getFormattedExpression() {
            return "\"" + this.date + "\"";
        }

        @Override
        public LocalDateTime getEvaluatedExpression() {
            return LocalDateTime.parse(this.date + "T00:00:00");
        }

        public StaticDate(String date) {
            this.date = date;
        }
    }
}

