/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.glue.dqdl.model.condition.date;

import java.util.List;
import java.util.stream.Collectors;
import software.amazon.glue.dqdl.model.condition.Condition;
import software.amazon.glue.dqdl.model.condition.date.DateBasedConditionOperator;
import software.amazon.glue.dqdl.model.condition.date.DateExpression;
import software.amazon.glue.dqdl.util.StringUtils;

public class DateBasedCondition
extends Condition {
    private final DateBasedConditionOperator operator;
    private final List<DateExpression> operands;

    public DateBasedCondition(String conditionAsString, DateBasedConditionOperator operator, List<DateExpression> operands) {
        super(conditionAsString);
        this.operator = operator;
        this.operands = operands;
    }

    @Override
    public String getFormattedCondition() {
        if (StringUtils.isBlank(this.conditionAsString)) {
            return "";
        }
        switch (this.operator) {
            case BETWEEN: {
                return String.format("between %s and %s", this.operands.get(0).getFormattedExpression(), this.operands.get(1).getFormattedExpression());
            }
            case NOT_BETWEEN: {
                return String.format("not between %s and %s", this.operands.get(0).getFormattedExpression(), this.operands.get(1).getFormattedExpression());
            }
            case GREATER_THAN: {
                return String.format("> %s", this.operands.get(0).getFormattedExpression());
            }
            case GREATER_THAN_EQUAL_TO: {
                return String.format(">= %s", this.operands.get(0).getFormattedExpression());
            }
            case LESS_THAN: {
                return String.format("< %s", this.operands.get(0).getFormattedExpression());
            }
            case LESS_THAN_EQUAL_TO: {
                return String.format("<= %s", this.operands.get(0).getFormattedExpression());
            }
            case EQUALS: {
                return String.format("= %s", this.operands.get(0).getFormattedExpression());
            }
            case NOT_EQUALS: {
                return String.format("!= %s", this.operands.get(0).getFormattedExpression());
            }
            case IN: {
                List<String> formattedOperands = this.getFormattedOperands();
                return String.format("in [%s]", String.join((CharSequence)",", formattedOperands));
            }
            case NOT_IN: {
                List<String> formattedOperands = this.getFormattedOperands();
                return String.format("not in [%s]", String.join((CharSequence)",", formattedOperands));
            }
        }
        return "";
    }

    @Override
    public String getSortedFormattedCondition() {
        if (StringUtils.isBlank(this.conditionAsString)) {
            return "";
        }
        switch (this.operator) {
            case IN: {
                return String.format("in [%s]", String.join((CharSequence)",", this.getSortedFormattedOperands()));
            }
            case NOT_IN: {
                return String.format("not in [%s]", String.join((CharSequence)",", this.getSortedFormattedOperands()));
            }
        }
        return this.getFormattedCondition();
    }

    private List<String> getFormattedOperands() {
        List<String> formattedOperands = this.operands.stream().map(DateExpression::getFormattedExpression).collect(Collectors.toList());
        return formattedOperands;
    }

    private List<String> getSortedFormattedOperands() {
        List<String> formattedOperands = this.operands.stream().map(DateExpression::getFormattedExpression).sorted().collect(Collectors.toList());
        return formattedOperands;
    }

    public DateBasedConditionOperator getOperator() {
        return this.operator;
    }

    public List<DateExpression> getOperands() {
        return this.operands;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DateBasedCondition)) {
            return false;
        }
        DateBasedCondition other = (DateBasedCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DateBasedConditionOperator this$operator = this.getOperator();
        DateBasedConditionOperator other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !((Object)((Object)this$operator)).equals((Object)other$operator)) {
            return false;
        }
        List<DateExpression> this$operands = this.getOperands();
        List<DateExpression> other$operands = other.getOperands();
        return !(this$operands == null ? other$operands != null : !((Object)this$operands).equals(other$operands));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DateBasedCondition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        DateBasedConditionOperator $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : ((Object)((Object)$operator)).hashCode());
        List<DateExpression> $operands = this.getOperands();
        result = result * 59 + ($operands == null ? 43 : ((Object)$operands).hashCode());
        return result;
    }
}

