/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.glue.dqdl.model;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

public class DQVariable<T>
implements Serializable {
    private final String name;
    private final VariableType type;
    private final T value;

    public String toString() {
        if (this.value instanceof List) {
            return String.format("%s = %s", this.name, this.formatArray((List)this.value));
        }
        return String.format("%s = %s", this.name, this.formatValue(this.value));
    }

    private String formatValue(T val) {
        if (val == null) {
            return "null";
        }
        if (this.type == VariableType.STRING) {
            return "\"" + val + "\"";
        }
        return val.toString();
    }

    private String formatArray(List<?> list) {
        return "[" + list.stream().map(Object::toString).collect(Collectors.joining(", ")) + "]";
    }

    public DQVariable(String name, VariableType type, T value) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public VariableType getType() {
        return this.type;
    }

    public T getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DQVariable)) {
            return false;
        }
        DQVariable other = (DQVariable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        VariableType this$type = this.getType();
        VariableType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DQVariable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        VariableType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public static enum VariableType {
        NUMBER,
        STRING,
        DATE,
        DURATION,
        NUMBER_ARRAY,
        STRING_ARRAY,
        DATE_ARRAY,
        DURATION_ARRAY;

    }
}

