/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.glue.dqdl.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.glue.dqdl.model.DQAnalyzer;
import software.amazon.glue.dqdl.model.DQRule;
import software.amazon.glue.dqdl.util.StringUtils;

public class DQRuleset {
    private final Map<String, String> metadata;
    private final String primarySourceName;
    private final List<String> additionalDataSourcesNames;
    private final List<DQRule> rules;
    private final List<DQAnalyzer> analyzers;
    private static final String LINE_SEP = System.lineSeparator();

    public DQRuleset(List<DQRule> rules) {
        this(rules, new ArrayList<DQAnalyzer>());
    }

    public DQRuleset(List<DQRule> rules, List<DQAnalyzer> analyzers) {
        this.metadata = new HashMap<String, String>();
        this.primarySourceName = null;
        this.additionalDataSourcesNames = new ArrayList<String>();
        this.rules = rules;
        this.analyzers = analyzers;
    }

    public String toString() {
        String metadataStr = "";
        if (this.metadata != null && this.metadata.size() > 0) {
            metadataStr = "Metadata = {" + LINE_SEP + this.metadata.keySet().stream().map(k -> "    \"" + k + "\": \"" + this.metadata.get(k) + "\"").collect(Collectors.joining("," + LINE_SEP)) + LINE_SEP + "}";
        }
        String sourcesStr = "";
        if (StringUtils.isNotBlank(this.primarySourceName) || this.additionalDataSourcesNames != null && this.additionalDataSourcesNames.size() > 0) {
            String additionalDataSourcesStr = "";
            if (this.additionalDataSourcesNames != null && this.additionalDataSourcesNames.size() > 0) {
                additionalDataSourcesStr = "    \"AdditionalDataSources\": [ " + this.additionalDataSourcesNames.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(", ")) + " ]" + LINE_SEP;
            }
            String primarySourceStr = "";
            if (StringUtils.isNotBlank(this.primarySourceName)) {
                primarySourceStr = "    \"Primary\": \"" + this.primarySourceName + "\"";
                if (StringUtils.isNotBlank(additionalDataSourcesStr)) {
                    primarySourceStr = primarySourceStr + ",";
                }
                primarySourceStr = primarySourceStr + LINE_SEP;
            }
            sourcesStr = "DataSources = {" + LINE_SEP + primarySourceStr + additionalDataSourcesStr + "}";
        }
        String rulesStr = "";
        if (!this.rules.isEmpty()) {
            rulesStr = "Rules = [" + LINE_SEP + this.rules.stream().map(i -> "    " + i).collect(Collectors.joining("," + LINE_SEP)) + LINE_SEP + "]";
        }
        String analyzersStr = "";
        if (!this.analyzers.isEmpty()) {
            analyzersStr = "Analyzers = [" + LINE_SEP + this.analyzers.stream().map(i -> "    " + i).collect(Collectors.joining("," + LINE_SEP)) + LINE_SEP + "]";
        }
        StringBuilder sb = new StringBuilder();
        if (!metadataStr.isEmpty()) {
            sb.append(metadataStr).append(LINE_SEP).append(LINE_SEP);
        }
        if (!sourcesStr.isEmpty()) {
            sb.append(sourcesStr).append(LINE_SEP).append(LINE_SEP);
        }
        if (!rulesStr.isEmpty()) {
            sb.append(rulesStr);
        }
        if (!analyzersStr.isEmpty()) {
            if (!rulesStr.isEmpty()) {
                sb.append(LINE_SEP).append(LINE_SEP);
            }
            sb.append(analyzersStr);
        }
        return sb.toString();
    }

    public DQRuleset(Map<String, String> metadata, String primarySourceName, List<String> additionalDataSourcesNames, List<DQRule> rules, List<DQAnalyzer> analyzers) {
        this.metadata = metadata;
        this.primarySourceName = primarySourceName;
        this.additionalDataSourcesNames = additionalDataSourcesNames;
        this.rules = rules;
        this.analyzers = analyzers;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getPrimarySourceName() {
        return this.primarySourceName;
    }

    public List<String> getAdditionalDataSourcesNames() {
        return this.additionalDataSourcesNames;
    }

    public List<DQRule> getRules() {
        return this.rules;
    }

    public List<DQAnalyzer> getAnalyzers() {
        return this.analyzers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DQRuleset)) {
            return false;
        }
        DQRuleset other = (DQRuleset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$primarySourceName = this.getPrimarySourceName();
        String other$primarySourceName = other.getPrimarySourceName();
        if (this$primarySourceName == null ? other$primarySourceName != null : !this$primarySourceName.equals(other$primarySourceName)) {
            return false;
        }
        List<String> this$additionalDataSourcesNames = this.getAdditionalDataSourcesNames();
        List<String> other$additionalDataSourcesNames = other.getAdditionalDataSourcesNames();
        if (this$additionalDataSourcesNames == null ? other$additionalDataSourcesNames != null : !((Object)this$additionalDataSourcesNames).equals(other$additionalDataSourcesNames)) {
            return false;
        }
        List<DQRule> this$rules = this.getRules();
        List<DQRule> other$rules = other.getRules();
        if (this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules)) {
            return false;
        }
        List<DQAnalyzer> this$analyzers = this.getAnalyzers();
        List<DQAnalyzer> other$analyzers = other.getAnalyzers();
        return !(this$analyzers == null ? other$analyzers != null : !((Object)this$analyzers).equals(other$analyzers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DQRuleset;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $primarySourceName = this.getPrimarySourceName();
        result = result * 59 + ($primarySourceName == null ? 43 : $primarySourceName.hashCode());
        List<String> $additionalDataSourcesNames = this.getAdditionalDataSourcesNames();
        result = result * 59 + ($additionalDataSourcesNames == null ? 43 : ((Object)$additionalDataSourcesNames).hashCode());
        List<DQRule> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        List<DQAnalyzer> $analyzers = this.getAnalyzers();
        result = result * 59 + ($analyzers == null ? 43 : ((Object)$analyzers).hashCode());
        return result;
    }
}

