/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.glue.dqdl.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import software.amazon.glue.dqdl.model.DQRuleParameter;
import software.amazon.glue.dqdl.model.DQRuleParameterValue;

public class DQRuleType {
    private final String ruleTypeName;
    private final String description;
    private final List<DQRuleParameter> parameters;
    private final String returnType;
    private final boolean isThresholdSupported;
    private final boolean isExcludedAtRowLevelInCompositeRules;
    private final boolean isWhereClauseSupported;
    private final boolean isAnalyzerOnly;
    private final String scope;
    private final boolean isExperimental;
    private static final List<DQRuleType> ALL_RULES = DQRuleType.generateRuleTypes("/rules/rules-config.json");

    public DQRuleType(@JsonProperty(value="rule_type_name") String ruleTypeName, @JsonProperty(value="description") String description, @JsonProperty(value="parameters") List<DQRuleParameter> parameters, @JsonProperty(value="return_type") String returnType, @JsonProperty(value="is_threshold_supported") boolean isThresholdSupported, @JsonProperty(value="is_excluded_at_row_level_in_composite_rules") boolean isExcludedAtRowLevelInCompositeRules, @JsonProperty(value="is_where_clause_supported") boolean isWhereClauseSupported, @JsonProperty(value="is_analyzer_only") boolean isAnalyzerOnly, @JsonProperty(value="scope") String scope, @JsonProperty(value="experimental") boolean isExperimental) {
        this.ruleTypeName = ruleTypeName;
        this.description = description;
        this.parameters = parameters;
        this.returnType = returnType;
        this.isThresholdSupported = isThresholdSupported;
        this.isExcludedAtRowLevelInCompositeRules = isExcludedAtRowLevelInCompositeRules;
        this.isWhereClauseSupported = isWhereClauseSupported;
        this.isAnalyzerOnly = isAnalyzerOnly;
        this.scope = scope;
        this.isExperimental = isExperimental;
        if (parameters.isEmpty()) {
            return;
        }
        List<DQRuleParameter> expectedParametersToCheck = parameters.subList(0, parameters.size() - 1);
        if (expectedParametersToCheck.stream().anyMatch(DQRuleParameter::isVarArg)) {
            throw new IllegalArgumentException("Property isVarArg can only be set to true on last element in parameters list");
        }
    }

    public Optional<String> verifyParameters(List<DQRuleParameter> expectedParameters, List<DQRuleParameterValue> actualParameters) {
        boolean isVarArg;
        if (!expectedParameters.isEmpty() && (isVarArg = expectedParameters.get(expectedParameters.size() - 1).isVarArg())) {
            if (expectedParameters.size() > actualParameters.size()) {
                return Optional.of("VarArgs needs at least one parameter");
            }
            return Optional.empty();
        }
        if (expectedParameters.size() != actualParameters.size()) {
            return Optional.of("Unexpected number of parameters");
        }
        return Optional.empty();
    }

    public LinkedHashMap<String, DQRuleParameterValue> createParameterMap(List<DQRuleParameter> dqRuleTypeParameters, List<DQRuleParameterValue> actualParameters) {
        LinkedHashMap<String, DQRuleParameterValue> parameterMap = new LinkedHashMap<String, DQRuleParameterValue>();
        for (int i = 0; i < dqRuleTypeParameters.size(); ++i) {
            String dqRuleTypeParameterName = dqRuleTypeParameters.get(i).getName();
            if (dqRuleTypeParameters.get(i).isVarArg()) {
                int counter = 0;
                if (dqRuleTypeParameters.size() > 1) {
                    counter = dqRuleTypeParameters.size() - 1;
                }
                for (int j = counter; j < actualParameters.size(); ++j) {
                    String newDqRuleTypeParameterName = dqRuleTypeParameterName + (j + 1);
                    DQRuleParameterValue actualParameterName = actualParameters.get(j);
                    parameterMap.put(newDqRuleTypeParameterName, actualParameterName);
                }
                continue;
            }
            parameterMap.put(dqRuleTypeParameterName, actualParameters.get(i));
        }
        return parameterMap;
    }

    /*
     * Exception decompiling
     */
    static List<DQRuleType> generateRuleTypes(String rulesConfigPath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Optional<DQRuleType> getRuleType(String ruleTypeName, int parameterCount) {
        return ALL_RULES.stream().filter(ruleType -> {
            int ruleTypeParameterCount = ruleType.getParameters().size();
            boolean containsVarArg = ruleTypeParameterCount > 0 && ruleType.getParameters().get(ruleTypeParameterCount - 1).isVarArg();
            boolean ruleTypeNameMatches = ruleType.getRuleTypeName().equals(ruleTypeName);
            boolean parameterCountMatches = containsVarArg ? parameterCount >= ruleTypeParameterCount : parameterCount == ruleTypeParameterCount;
            return ruleTypeNameMatches && parameterCountMatches;
        }).findFirst();
    }

    public String getRuleTypeName() {
        return this.ruleTypeName;
    }

    public String getDescription() {
        return this.description;
    }

    public List<DQRuleParameter> getParameters() {
        return this.parameters;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public boolean isThresholdSupported() {
        return this.isThresholdSupported;
    }

    public boolean isExcludedAtRowLevelInCompositeRules() {
        return this.isExcludedAtRowLevelInCompositeRules;
    }

    public boolean isWhereClauseSupported() {
        return this.isWhereClauseSupported;
    }

    public boolean isAnalyzerOnly() {
        return this.isAnalyzerOnly;
    }

    public String getScope() {
        return this.scope;
    }

    public boolean isExperimental() {
        return this.isExperimental;
    }

    private static class DQRuleTypes {
        @JsonProperty(value="rule_types")
        private List<DQRuleType> ruleTypes;

        public DQRuleTypes(List<DQRuleType> ruleTypes) {
            this.ruleTypes = ruleTypes;
        }

        public DQRuleTypes() {
        }

        static /* synthetic */ List access$000(DQRuleTypes x0) {
            return x0.ruleTypes;
        }
    }
}

