/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.glue.dqdl.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class DQRuleParameterValue
implements Serializable {
    private static final String EMPTY_CONNECTOR = "";
    private final String value;
    private final boolean isQuoted;
    private final String connectorWord;

    public DQRuleParameterValue(String value) {
        this.value = value;
        this.isQuoted = false;
        this.connectorWord = EMPTY_CONNECTOR;
    }

    public DQRuleParameterValue(String value, boolean isQuoted) {
        this.value = value;
        this.isQuoted = isQuoted;
        this.connectorWord = EMPTY_CONNECTOR;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!EMPTY_CONNECTOR.equals(this.connectorWord)) {
            sb.append(this.connectorWord).append(" ");
        }
        String surroundBy = this.isQuoted ? "\"" : EMPTY_CONNECTOR;
        sb.append(surroundBy).append(this.value).append(surroundBy);
        return sb.toString();
    }

    public static Map<String, DQRuleParameterValue> createParameterValueMap(Map<String, String> parameters) {
        HashMap<String, DQRuleParameterValue> map = new HashMap<String, DQRuleParameterValue>();
        if (parameters == null) {
            return map;
        }
        boolean isQuoted = true;
        parameters.forEach((k, v) -> map.put((String)k, new DQRuleParameterValue((String)v, isQuoted)));
        return map;
    }

    public static Map<String, String> createParameterMap(Map<String, DQRuleParameterValue> parameters) {
        LinkedHashMap<String, String> paramValuesAsStringsMap = new LinkedHashMap<String, String>();
        parameters.forEach((k, v) -> paramValuesAsStringsMap.put((String)k, v.getValue()));
        return paramValuesAsStringsMap;
    }

    public DQRuleParameterValue(String value, boolean isQuoted, String connectorWord) {
        this.value = value;
        this.isQuoted = isQuoted;
        this.connectorWord = connectorWord;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isQuoted() {
        return this.isQuoted;
    }

    public String getConnectorWord() {
        return this.connectorWord;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DQRuleParameterValue)) {
            return false;
        }
        DQRuleParameterValue other = (DQRuleParameterValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isQuoted() != other.isQuoted()) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$connectorWord = this.getConnectorWord();
        String other$connectorWord = other.getConnectorWord();
        return !(this$connectorWord == null ? other$connectorWord != null : !this$connectorWord.equals(other$connectorWord));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DQRuleParameterValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isQuoted() ? 79 : 97);
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $connectorWord = this.getConnectorWord();
        result = result * 59 + ($connectorWord == null ? 43 : $connectorWord.hashCode());
        return result;
    }
}

