/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.glue.dqdl.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.glue.dqdl.model.DQRuleLogicalOperator;
import software.amazon.glue.dqdl.model.DQRuleParameterValue;
import software.amazon.glue.dqdl.model.DQRuleType;
import software.amazon.glue.dqdl.model.DQVariable;
import software.amazon.glue.dqdl.model.HasRuleTypeAndParameters;
import software.amazon.glue.dqdl.model.condition.Condition;
import software.amazon.glue.dqdl.model.condition.string.Tag;
import software.amazon.glue.dqdl.parser.DQDLVariableResolver;
import software.amazon.glue.dqdl.util.StringUtils;

public class DQRule
implements Serializable,
HasRuleTypeAndParameters {
    private final String ruleType;
    private final Map<String, String> parameters;
    private final Map<String, DQRuleParameterValue> parameterValueMap;
    private final Condition condition;
    private final Condition thresholdCondition;
    private final DQRuleLogicalOperator operator;
    private final List<DQRule> nestedRules;
    private final String whereClause;
    private Boolean isExcludedAtRowLevelInCompositeRules = false;
    private Map<String, Tag> tags;

    public DQRule(String ruleType, Map<String, String> parameters, Condition condition, Condition thresholdCondition, DQRuleLogicalOperator operator, List<DQRule> nestedRules, String whereClause) {
        this.ruleType = ruleType;
        this.parameters = parameters;
        this.parameterValueMap = DQRuleParameterValue.createParameterValueMap(parameters);
        this.condition = condition;
        this.thresholdCondition = thresholdCondition;
        this.operator = operator;
        this.nestedRules = nestedRules;
        this.whereClause = whereClause;
    }

    public DQRule(String ruleType, Map<String, String> parameters, Condition condition, Condition thresholdCondition, DQRuleLogicalOperator operator, List<DQRule> nestedRules) {
        this.ruleType = ruleType;
        this.parameters = parameters;
        this.parameterValueMap = DQRuleParameterValue.createParameterValueMap(parameters);
        this.condition = condition;
        this.thresholdCondition = thresholdCondition;
        this.operator = operator;
        this.nestedRules = nestedRules;
        this.whereClause = null;
    }

    public DQRule(String ruleType, Map<String, String> parameters, Condition condition) {
        this.ruleType = ruleType;
        this.parameters = parameters;
        this.parameterValueMap = DQRuleParameterValue.createParameterValueMap(parameters);
        this.condition = condition;
        this.thresholdCondition = null;
        this.operator = DQRuleLogicalOperator.AND;
        this.nestedRules = new ArrayList<DQRule>();
        this.whereClause = null;
    }

    public static DQRule createFromParameterValueMap(DQRuleType ruleType, LinkedHashMap<String, DQRuleParameterValue> parameters, Condition condition) {
        return DQRule.createFromParameterValueMap(ruleType, parameters, condition, null, null, null);
    }

    public DQRule(String ruleType, Map<String, String> parameters, Condition condition, Condition thresholdCondition) {
        this.ruleType = ruleType;
        this.parameters = parameters;
        this.parameterValueMap = DQRuleParameterValue.createParameterValueMap(parameters);
        this.condition = condition;
        this.thresholdCondition = thresholdCondition;
        this.operator = DQRuleLogicalOperator.AND;
        this.nestedRules = new ArrayList<DQRule>();
        this.whereClause = null;
    }

    public static DQRule createFromParameterValueMap(DQRuleType ruleType, LinkedHashMap<String, DQRuleParameterValue> parameters, Condition condition, Condition thresholdCondition, String whereClause, Map<String, Tag> tags) {
        DQRuleLogicalOperator operator = DQRuleLogicalOperator.AND;
        ArrayList<DQRule> nestedRules = new ArrayList<DQRule>();
        return new DQRule(ruleType.getRuleTypeName(), DQRuleParameterValue.createParameterMap(parameters), parameters, condition, thresholdCondition, operator, nestedRules, whereClause, ruleType.isExcludedAtRowLevelInCompositeRules(), tags);
    }

    public static DQRule createFromParameterValueMapWithVariables(DQRuleType ruleType, LinkedHashMap<String, DQRuleParameterValue> parameters, Condition condition, Condition thresholdCondition, String whereClause, Map<String, Tag> tags, Map<String, DQVariable> variables) {
        DQRule unresolvedRule = DQRule.createFromParameterValueMap(ruleType, parameters, condition, thresholdCondition, whereClause, tags);
        if (variables == null || variables.isEmpty()) {
            return unresolvedRule;
        }
        HashMap<String, DQVariable> usedVars = new HashMap<String, DQVariable>();
        Condition resolvedCondition = condition != null ? DQDLVariableResolver.resolveVariablesInCondition(condition, variables, usedVars) : null;
        Condition resolvedThresholdCondition = thresholdCondition != null ? DQDLVariableResolver.resolveVariablesInCondition(thresholdCondition, variables, usedVars) : null;
        return new DQRule(ruleType.getRuleTypeName(), DQRuleParameterValue.createParameterMap(parameters), parameters, resolvedCondition, resolvedThresholdCondition, DQRuleLogicalOperator.AND, new ArrayList<DQRule>(), whereClause, ruleType.isExcludedAtRowLevelInCompositeRules(), tags);
    }

    public DQRule withNestedRules(List<DQRule> nestedRules) {
        return this.toBuilder().nestedRules(nestedRules).build();
    }

    public DQRule withCondition(Condition condition) {
        return this.toBuilder().condition(condition).build();
    }

    public Map<String, String> getTags() {
        return Tag.convertToStringMap(this.tags);
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.nestedRules == null || this.nestedRules.isEmpty()) {
            Object formattedCondition;
            sb.append(this.ruleType);
            if (this.parameterValueMap != null) {
                this.parameterValueMap.values().forEach(p -> sb.append(" ").append(p.toString()));
            }
            if (this.condition != null && !StringUtils.isBlank((CharSequence)(formattedCondition = this.condition.getFormattedCondition()))) {
                sb.append(" ").append(this.condition.getFormattedCondition());
            }
            if (this.whereClause != null && !StringUtils.isBlank(this.whereClause)) {
                sb.append(" where ").append("\"").append(this.whereClause).append("\"");
            }
            if (this.thresholdCondition != null && !StringUtils.isBlank((CharSequence)(formattedCondition = this.thresholdCondition.getFormattedCondition()))) {
                sb.append(" with threshold ").append((String)formattedCondition);
            }
            if (this.tags != null) {
                for (Map.Entry entry : this.tags.entrySet()) {
                    sb.append(entry.getValue());
                }
            }
            return sb.toString().trim();
        }
        boolean canBeFlattened = this.usesSameOperator(this.operator);
        if (canBeFlattened) {
            List<DQRule> list = this.getNestedRulesAsFlattenedList();
            for (int i = 0; i < list.size(); ++i) {
                sb.append("(").append(list.get(i).toString()).append(")");
                if (i == list.size() - 1) continue;
                sb.append(" ").append(this.operator.toString()).append(" ");
            }
        } else {
            void var3_7;
            boolean bl = false;
            while (var3_7 < this.nestedRules.size()) {
                sb.append("(").append(this.nestedRules.get((int)var3_7).toString()).append(")");
                if (var3_7 != this.nestedRules.size() - 1) {
                    sb.append(" ").append(this.operator.toString()).append(" ");
                }
                ++var3_7;
            }
        }
        return sb.toString();
    }

    private boolean usesSameOperator(DQRuleLogicalOperator op) {
        if (this.nestedRules.isEmpty()) {
            return true;
        }
        if (this.operator != op) {
            return false;
        }
        for (DQRule nestedRule : this.nestedRules) {
            if (nestedRule.usesSameOperator(op)) continue;
            return false;
        }
        return true;
    }

    public List<DQRule> getNestedRulesAsFlattenedList() {
        ArrayList<DQRule> ret = new ArrayList<DQRule>();
        if (this.nestedRules.isEmpty()) {
            ret.add(this);
        } else {
            for (DQRule nestedRule : this.nestedRules) {
                List<DQRule> nestedRet = nestedRule.getNestedRulesAsFlattenedList();
                ret.addAll(nestedRet);
            }
        }
        return ret;
    }

    private static DQRuleBuilder builder() {
        return new DQRuleBuilder();
    }

    private DQRuleBuilder toBuilder() {
        return new DQRuleBuilder().ruleType(this.ruleType).parameters(this.parameters).parameterValueMap(this.parameterValueMap).condition(this.condition).thresholdCondition(this.thresholdCondition).operator(this.operator).nestedRules(this.nestedRules).whereClause(this.whereClause).isExcludedAtRowLevelInCompositeRules(this.isExcludedAtRowLevelInCompositeRules).tags(this.tags);
    }

    public DQRule(String ruleType, Map<String, String> parameters, Map<String, DQRuleParameterValue> parameterValueMap, Condition condition, Condition thresholdCondition, DQRuleLogicalOperator operator, List<DQRule> nestedRules, String whereClause, Boolean isExcludedAtRowLevelInCompositeRules, Map<String, Tag> tags) {
        this.ruleType = ruleType;
        this.parameters = parameters;
        this.parameterValueMap = parameterValueMap;
        this.condition = condition;
        this.thresholdCondition = thresholdCondition;
        this.operator = operator;
        this.nestedRules = nestedRules;
        this.whereClause = whereClause;
        this.isExcludedAtRowLevelInCompositeRules = isExcludedAtRowLevelInCompositeRules;
        this.tags = tags;
    }

    @Override
    public String getRuleType() {
        return this.ruleType;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Map<String, DQRuleParameterValue> getParameterValueMap() {
        return this.parameterValueMap;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public Condition getThresholdCondition() {
        return this.thresholdCondition;
    }

    public DQRuleLogicalOperator getOperator() {
        return this.operator;
    }

    public List<DQRule> getNestedRules() {
        return this.nestedRules;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public Boolean getIsExcludedAtRowLevelInCompositeRules() {
        return this.isExcludedAtRowLevelInCompositeRules;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DQRule)) {
            return false;
        }
        DQRule other = (DQRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isExcludedAtRowLevelInCompositeRules = this.getIsExcludedAtRowLevelInCompositeRules();
        Boolean other$isExcludedAtRowLevelInCompositeRules = other.getIsExcludedAtRowLevelInCompositeRules();
        if (this$isExcludedAtRowLevelInCompositeRules == null ? other$isExcludedAtRowLevelInCompositeRules != null : !((Object)this$isExcludedAtRowLevelInCompositeRules).equals(other$isExcludedAtRowLevelInCompositeRules)) {
            return false;
        }
        String this$ruleType = this.getRuleType();
        String other$ruleType = other.getRuleType();
        if (this$ruleType == null ? other$ruleType != null : !this$ruleType.equals(other$ruleType)) {
            return false;
        }
        Map<String, String> this$parameters = this.getParameters();
        Map<String, String> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        Map<String, DQRuleParameterValue> this$parameterValueMap = this.getParameterValueMap();
        Map<String, DQRuleParameterValue> other$parameterValueMap = other.getParameterValueMap();
        if (this$parameterValueMap == null ? other$parameterValueMap != null : !((Object)this$parameterValueMap).equals(other$parameterValueMap)) {
            return false;
        }
        Condition this$condition = this.getCondition();
        Condition other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !((Object)this$condition).equals(other$condition)) {
            return false;
        }
        Condition this$thresholdCondition = this.getThresholdCondition();
        Condition other$thresholdCondition = other.getThresholdCondition();
        if (this$thresholdCondition == null ? other$thresholdCondition != null : !((Object)this$thresholdCondition).equals(other$thresholdCondition)) {
            return false;
        }
        DQRuleLogicalOperator this$operator = this.getOperator();
        DQRuleLogicalOperator other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !((Object)((Object)this$operator)).equals((Object)other$operator)) {
            return false;
        }
        List<DQRule> this$nestedRules = this.getNestedRules();
        List<DQRule> other$nestedRules = other.getNestedRules();
        if (this$nestedRules == null ? other$nestedRules != null : !((Object)this$nestedRules).equals(other$nestedRules)) {
            return false;
        }
        String this$whereClause = this.getWhereClause();
        String other$whereClause = other.getWhereClause();
        if (this$whereClause == null ? other$whereClause != null : !this$whereClause.equals(other$whereClause)) {
            return false;
        }
        Map<String, String> this$tags = this.getTags();
        Map<String, String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DQRule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isExcludedAtRowLevelInCompositeRules = this.getIsExcludedAtRowLevelInCompositeRules();
        result = result * 59 + ($isExcludedAtRowLevelInCompositeRules == null ? 43 : ((Object)$isExcludedAtRowLevelInCompositeRules).hashCode());
        String $ruleType = this.getRuleType();
        result = result * 59 + ($ruleType == null ? 43 : $ruleType.hashCode());
        Map<String, String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        Map<String, DQRuleParameterValue> $parameterValueMap = this.getParameterValueMap();
        result = result * 59 + ($parameterValueMap == null ? 43 : ((Object)$parameterValueMap).hashCode());
        Condition $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : ((Object)$condition).hashCode());
        Condition $thresholdCondition = this.getThresholdCondition();
        result = result * 59 + ($thresholdCondition == null ? 43 : ((Object)$thresholdCondition).hashCode());
        DQRuleLogicalOperator $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : ((Object)((Object)$operator)).hashCode());
        List<DQRule> $nestedRules = this.getNestedRules();
        result = result * 59 + ($nestedRules == null ? 43 : ((Object)$nestedRules).hashCode());
        String $whereClause = this.getWhereClause();
        result = result * 59 + ($whereClause == null ? 43 : $whereClause.hashCode());
        Map<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    private static class DQRuleBuilder {
        private String ruleType;
        private Map<String, String> parameters;
        private Map<String, DQRuleParameterValue> parameterValueMap;
        private Condition condition;
        private Condition thresholdCondition;
        private DQRuleLogicalOperator operator;
        private List<DQRule> nestedRules;
        private String whereClause;
        private Boolean isExcludedAtRowLevelInCompositeRules;
        private Map<String, Tag> tags;

        DQRuleBuilder() {
        }

        private DQRuleBuilder ruleType(String ruleType) {
            this.ruleType = ruleType;
            return this;
        }

        private DQRuleBuilder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        private DQRuleBuilder parameterValueMap(Map<String, DQRuleParameterValue> parameterValueMap) {
            this.parameterValueMap = parameterValueMap;
            return this;
        }

        private DQRuleBuilder condition(Condition condition) {
            this.condition = condition;
            return this;
        }

        private DQRuleBuilder thresholdCondition(Condition thresholdCondition) {
            this.thresholdCondition = thresholdCondition;
            return this;
        }

        private DQRuleBuilder operator(DQRuleLogicalOperator operator) {
            this.operator = operator;
            return this;
        }

        private DQRuleBuilder nestedRules(List<DQRule> nestedRules) {
            this.nestedRules = nestedRules;
            return this;
        }

        private DQRuleBuilder whereClause(String whereClause) {
            this.whereClause = whereClause;
            return this;
        }

        private DQRuleBuilder isExcludedAtRowLevelInCompositeRules(Boolean isExcludedAtRowLevelInCompositeRules) {
            this.isExcludedAtRowLevelInCompositeRules = isExcludedAtRowLevelInCompositeRules;
            return this;
        }

        private DQRuleBuilder tags(Map<String, Tag> tags) {
            this.tags = tags;
            return this;
        }

        private DQRule build() {
            return new DQRule(this.ruleType, this.parameters, this.parameterValueMap, this.condition, this.thresholdCondition, this.operator, this.nestedRules, this.whereClause, this.isExcludedAtRowLevelInCompositeRules, this.tags);
        }

        public String toString() {
            return "DQRule.DQRuleBuilder(ruleType=" + this.ruleType + ", parameters=" + this.parameters + ", parameterValueMap=" + this.parameterValueMap + ", condition=" + this.condition + ", thresholdCondition=" + this.thresholdCondition + ", operator=" + (Object)((Object)this.operator) + ", nestedRules=" + this.nestedRules + ", whereClause=" + this.whereClause + ", isExcludedAtRowLevelInCompositeRules=" + this.isExcludedAtRowLevelInCompositeRules + ", tags=" + this.tags + ")";
        }
    }
}

