/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.glue.dqdl.model;

import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.glue.dqdl.model.DQRuleParameterValue;
import software.amazon.glue.dqdl.model.HasRuleTypeAndParameters;

public class DQAnalyzer
implements HasRuleTypeAndParameters {
    private final String ruleType;
    private final Map<String, String> parameters;
    private final Map<String, DQRuleParameterValue> parameterValueMap;

    public DQAnalyzer(String ruleType, Map<String, String> parameters) {
        this.ruleType = ruleType;
        this.parameters = parameters;
        this.parameterValueMap = DQRuleParameterValue.createParameterValueMap(this.parameters);
    }

    public static DQAnalyzer createFromValueMap(String ruleType, LinkedHashMap<String, DQRuleParameterValue> parameters) {
        return new DQAnalyzer(ruleType, DQRuleParameterValue.createParameterMap(parameters), parameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.ruleType);
        if (this.parameterValueMap != null) {
            this.parameterValueMap.values().forEach(p -> sb.append(" ").append(p.toString()));
        }
        return sb.toString();
    }

    public DQAnalyzer(String ruleType, Map<String, String> parameters, Map<String, DQRuleParameterValue> parameterValueMap) {
        this.ruleType = ruleType;
        this.parameters = parameters;
        this.parameterValueMap = parameterValueMap;
    }

    @Override
    public String getRuleType() {
        return this.ruleType;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Map<String, DQRuleParameterValue> getParameterValueMap() {
        return this.parameterValueMap;
    }
}

