/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.s3.model.ChecksumType;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

public class ConvertSDKRequests {
    public static CreateMultipartUploadRequest convert(PutObjectRequest request) {
        CreateMultipartUploadRequest.Builder output = CreateMultipartUploadRequest.builder();
        request.toBuilder().sdkFields().forEach(f -> {
            Object value = f.getValueOrDefault((Object)request);
            if (value != null) {
                switch (f.memberName()) {
                    case "ACL": {
                        output.acl((String)value);
                        break;
                    }
                    case "Bucket": {
                        output.bucket((String)value);
                        break;
                    }
                    case "BucketKeyEnabled": {
                        output.bucketKeyEnabled((Boolean)value);
                        break;
                    }
                    case "CacheControl": {
                        output.cacheControl((String)value);
                        break;
                    }
                    case "ChecksumAlgorithm": {
                        output.checksumAlgorithm((String)value);
                        break;
                    }
                    case "ChecksumType": {
                        output.checksumType((ChecksumType)value);
                    }
                    case "ContentDisposition": {
                        assert (value instanceof String);
                        output.contentDisposition((String)value);
                        break;
                    }
                    case "ContentEncoding": {
                        output.contentEncoding((String)value);
                        break;
                    }
                    case "ContentLanguage": {
                        output.contentLanguage((String)value);
                        break;
                    }
                    case "ContentType": {
                        output.contentType((String)value);
                        break;
                    }
                    case "ExpectedBucketOwner": {
                        output.expectedBucketOwner((String)value);
                        break;
                    }
                    case "Expires": {
                        output.expires((Instant)value);
                        break;
                    }
                    case "GrantFullControl": {
                        output.grantFullControl((String)value);
                        break;
                    }
                    case "GrantRead": {
                        output.grantRead((String)value);
                        break;
                    }
                    case "GrantReadACP": {
                        output.grantReadACP((String)value);
                        break;
                    }
                    case "GrantWriteACP": {
                        output.grantWriteACP((String)value);
                        break;
                    }
                    case "Key": {
                        output.key((String)value);
                        break;
                    }
                    case "Metadata": {
                        if (!ConvertSDKRequests.isStringStringMap(value)) {
                            throw new IllegalArgumentException("Metadata must be a Map<String, String>");
                        }
                        Map metadata = (Map)value;
                        output.metadata(metadata);
                        break;
                    }
                    case "ObjectLockLegalHoldStatus": {
                        output.objectLockLegalHoldStatus((String)value);
                        break;
                    }
                    case "ObjectLockMode": {
                        output.objectLockMode((String)value);
                        break;
                    }
                    case "ObjectLockRetainUntilDate": {
                        output.objectLockRetainUntilDate((Instant)value);
                        break;
                    }
                    case "RequestPayer": {
                        output.requestPayer((String)value);
                        break;
                    }
                    case "ServerSideEncryption": {
                        output.serverSideEncryption((String)value);
                        break;
                    }
                    case "SSECustomerAlgorithm": {
                        output.sseCustomerAlgorithm((String)value);
                        break;
                    }
                    case "SSECustomerKey": {
                        output.sseCustomerKey((String)value);
                        break;
                    }
                    case "SSEKMSEncryptionContext": {
                        output.ssekmsEncryptionContext((String)value);
                        break;
                    }
                    case "SSEKMSKeyId": {
                        output.ssekmsKeyId((String)value);
                        break;
                    }
                    case "StorageClass": {
                        output.storageClass((String)value);
                        break;
                    }
                    case "Tagging": {
                        output.tagging((String)value);
                        break;
                    }
                    case "WebsiteRedirectLocation": {
                        output.websiteRedirectLocation((String)value);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(f.locationName() + " is an unknown field. The S3 Encryption Client does not recognize this option and cannot set it on the CreateMultipartUploadRequest.This may be a new S3 feature.Please report this to the Amazon S3 Encryption Client for Java: https://github.com/aws/amazon-s3-encryption-client-java/issues.To work around this issue you can disable multi part upload,use the Async client, or not set this value on PutObject.You may be able to update this value after the PutObject request completes.");
                    }
                }
            }
        });
        return (CreateMultipartUploadRequest)output.overrideConfiguration((AwsRequestOverrideConfiguration)request.overrideConfiguration().orElse(null)).build();
    }

    private static boolean isStringStringMap(Object value) {
        if (!(value instanceof Map)) {
            return false;
        }
        Map map = (Map)value;
        return map.entrySet().stream().allMatch(entry -> entry != null && entry.getKey() instanceof String && entry.getValue() instanceof String);
    }
}

