/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.internal;

import com.sun.xml.messaging.saaj.packaging.mime.internet.MimeUtility;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionException;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.encryption.s3.S3EncryptionClientException;
import software.amazon.encryption.s3.algorithms.AlgorithmSuite;
import software.amazon.encryption.s3.internal.ContentMetadata;
import software.amazon.encryption.s3.materials.EncryptedDataKey;

public class ContentMetadataDecodingStrategy {
    private static final Base64.Decoder DECODER = Base64.getDecoder();
    private final S3AsyncClient wrappedAsyncClient_;

    public ContentMetadataDecodingStrategy(S3AsyncClient s3AsyncClient) {
        if (s3AsyncClient == null) {
            throw new S3EncryptionClientException("ContentMetadataDecodingStrategy requires a non-null async client.");
        }
        this.wrappedAsyncClient_ = s3AsyncClient;
    }

    private ContentMetadata readFromMap(Map<String, String> metadata, GetObjectResponse response) {
        String keyProviderInfo;
        byte[] edkCiphertext;
        AlgorithmSuite algorithmSuite;
        String contentEncryptionAlgorithm = metadata.get("x-amz-cek-alg");
        String contentRange = response.contentRange();
        if (contentEncryptionAlgorithm == null || contentEncryptionAlgorithm.equals(AlgorithmSuite.ALG_AES_256_CBC_IV16_NO_KDF.cipherName())) {
            algorithmSuite = AlgorithmSuite.ALG_AES_256_CBC_IV16_NO_KDF;
        } else if (contentEncryptionAlgorithm.equals(AlgorithmSuite.ALG_AES_256_GCM_IV12_TAG16_NO_KDF.cipherName())) {
            algorithmSuite = contentRange == null ? AlgorithmSuite.ALG_AES_256_GCM_IV12_TAG16_NO_KDF : AlgorithmSuite.ALG_AES_256_CTR_IV16_TAG16_NO_KDF;
        } else {
            throw new S3EncryptionClientException("Unknown content encryption algorithm: " + contentEncryptionAlgorithm);
        }
        String keyProviderId = "S3Keyring";
        switch (algorithmSuite) {
            case ALG_AES_256_CBC_IV16_NO_KDF: {
                if (metadata.containsKey("x-amz-key")) {
                    edkCiphertext = DECODER.decode(metadata.get("x-amz-key"));
                } else if (metadata.containsKey("x-amz-key-v2")) {
                    edkCiphertext = DECODER.decode(metadata.get("x-amz-key-v2"));
                } else {
                    throw new S3EncryptionClientException("Malformed object metadata! Could not find the encrypted data key.");
                }
                if (!metadata.containsKey("x-amz-wrap-alg")) {
                    if (edkCiphertext.length > 48) {
                        keyProviderInfo = "RSA";
                        break;
                    }
                    keyProviderInfo = "AES";
                    break;
                }
                keyProviderInfo = metadata.get("x-amz-wrap-alg");
                break;
            }
            case ALG_AES_256_GCM_IV12_TAG16_NO_KDF: 
            case ALG_AES_256_CTR_IV16_TAG16_NO_KDF: {
                int tagLength = Integer.parseInt(metadata.get("x-amz-tag-len"));
                if (tagLength != algorithmSuite.cipherTagLengthBits()) {
                    throw new S3EncryptionClientException("Expected tag length (bits) of: " + algorithmSuite.cipherTagLengthBits() + ", got: " + tagLength);
                }
                edkCiphertext = DECODER.decode(metadata.get("x-amz-key-v2"));
                keyProviderInfo = metadata.get("x-amz-wrap-alg");
                break;
            }
            default: {
                throw new S3EncryptionClientException("Unknown content encryption algorithm: " + algorithmSuite.id());
            }
        }
        EncryptedDataKey edk = EncryptedDataKey.builder().encryptedDataKey(edkCiphertext).keyProviderId("S3Keyring").keyProviderInfo(keyProviderInfo.getBytes(StandardCharsets.UTF_8)).build();
        HashMap<String, String> encryptionContext = new HashMap<String, String>();
        String jsonEncryptionContext = metadata.get("x-amz-matdesc");
        String decodedJsonEncryptionContext = ContentMetadataDecodingStrategy.decodeS3CustomEncoding(jsonEncryptionContext);
        try {
            JsonNodeParser parser = JsonNodeParser.create();
            JsonNode objectNode = parser.parse(decodedJsonEncryptionContext);
            for (Map.Entry entry : objectNode.asObject().entrySet()) {
                encryptionContext.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        byte[] iv = DECODER.decode(metadata.get("x-amz-iv"));
        return ContentMetadata.builder().algorithmSuite(algorithmSuite).encryptedDataKey(edk).encryptedDataKeyContext(encryptionContext).contentIv(iv).contentRange(contentRange).build();
    }

    public ContentMetadata decode(GetObjectRequest request, GetObjectResponse response) {
        Map metadata = response.metadata();
        if (metadata != null && metadata.containsKey("x-amz-iv") && (metadata.containsKey("x-amz-key") || metadata.containsKey("x-amz-key-v2"))) {
            return this.decodeFromObjectMetadata(request, response);
        }
        return this.decodeFromInstructionFile(request, response);
    }

    private static String decodeS3CustomEncoding(String s) {
        String mimeDecoded;
        try {
            mimeDecoded = MimeUtility.decodeText((String)s);
        }
        catch (UnsupportedEncodingException ex) {
            throw new S3EncryptionClientException("Unable to decode S3 object metadata: " + s, ex);
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(baos);
            byte[] sInBytes = mimeDecoded.getBytes(StandardCharsets.UTF_8);
            char[] sInChars = mimeDecoded.toCharArray();
            int nonAsciiChars = 0;
            for (int i = 0; i < sInChars.length; ++i) {
                if (sInChars[i] > '\u007f') {
                    byte[] buf = new byte[]{sInBytes[i + nonAsciiChars], sInBytes[i + nonAsciiChars + 1]};
                    String wrongString = new String(buf, StandardCharsets.UTF_8);
                    out.write(wrongString.charAt(0));
                    ++nonAsciiChars;
                    continue;
                }
                if (baos.size() > 0) {
                    stringBuilder.append(new String(baos.toByteArray(), StandardCharsets.UTF_8));
                    baos.reset();
                }
                stringBuilder.append(sInChars[i]);
            }
            return stringBuilder.toString();
        }
        catch (IOException exception) {
            throw new S3EncryptionClientException("Unable to decode S3 object metadata: " + s, exception);
        }
    }

    private ContentMetadata decodeFromObjectMetadata(GetObjectRequest request, GetObjectResponse response) {
        return this.readFromMap(response.metadata(), response);
    }

    private ContentMetadata decodeFromInstructionFile(GetObjectRequest request, GetObjectResponse response) {
        ResponseInputStream instruction;
        GetObjectRequest instructionGetObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(request.bucket()).key(request.key() + ".instruction").build();
        try {
            instruction = (ResponseInputStream)this.wrappedAsyncClient_.getObject(instructionGetObjectRequest, AsyncResponseTransformer.toBlockingInputStream()).join();
        }
        catch (CompletionException exception) {
            throw new S3EncryptionClientException("Instruction file not found! Please ensure the object you are attempting to decrypt has been encrypted using the S3 Encryption Client.", exception);
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        JsonNodeParser parser = JsonNodeParser.create();
        JsonNode objectNode = parser.parse((InputStream)instruction);
        for (Map.Entry entry : objectNode.asObject().entrySet()) {
            metadata.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asString());
        }
        return this.readFromMap(metadata, response);
    }
}

