/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.encryption.s3.legacy.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.encryption.s3.algorithms.AlgorithmSuite;

public class AdjustedRangeSubscriber
implements Subscriber<ByteBuffer> {
    private final int SYMMETRIC_CIPHER_BLOCK_SIZE_BYTES = AlgorithmSuite.ALG_AES_256_GCM_IV12_TAG16_NO_KDF.cipherBlockSizeBytes();
    private final Subscriber<? super ByteBuffer> wrappedSubscriber;
    private byte[] outputBuffer;
    private long virtualAvailable;
    private int numBytesToSkip = 0;

    public AdjustedRangeSubscriber(Subscriber<? super ByteBuffer> wrappedSubscriber, Long rangeBeginning, Long rangeEnd) throws IOException {
        this.wrappedSubscriber = wrappedSubscriber;
        this.initializeForRead(rangeBeginning, rangeEnd);
    }

    private void initializeForRead(long rangeBeginning, long rangeEnd) {
        if (rangeBeginning < (long)this.SYMMETRIC_CIPHER_BLOCK_SIZE_BYTES) {
            this.numBytesToSkip = (int)rangeBeginning;
        } else {
            int offsetIntoBlock = (int)(rangeBeginning % (long)this.SYMMETRIC_CIPHER_BLOCK_SIZE_BYTES);
            this.numBytesToSkip = this.SYMMETRIC_CIPHER_BLOCK_SIZE_BYTES + offsetIntoBlock;
        }
        this.virtualAvailable = rangeEnd - rangeBeginning + 1L;
    }

    public void onSubscribe(Subscription s) {
        this.wrappedSubscriber.onSubscribe(s);
    }

    public void onNext(ByteBuffer byteBuffer) {
        if (this.virtualAvailable <= 0L) {
            this.wrappedSubscriber.onComplete();
        }
        if (this.numBytesToSkip != 0) {
            byte[] buf = byteBuffer.array();
            if (this.numBytesToSkip > buf.length) {
                this.numBytesToSkip -= buf.length;
                this.wrappedSubscriber.onComplete();
            } else {
                this.outputBuffer = Arrays.copyOfRange(buf, this.numBytesToSkip, buf.length);
                this.numBytesToSkip = 0;
            }
        } else {
            this.outputBuffer = byteBuffer.array();
        }
        if (this.virtualAvailable > 0L) {
            long bytesToRead = Math.min(this.virtualAvailable, (long)this.outputBuffer.length);
            this.virtualAvailable -= bytesToRead;
            this.wrappedSubscriber.onNext((Object)ByteBuffer.wrap(this.outputBuffer, 0, Math.toIntExact(bytesToRead)));
        }
        if (this.virtualAvailable <= 0L) {
            this.wrappedSubscriber.onComplete();
        }
    }

    public void onError(Throwable t) {
        this.wrappedSubscriber.onError(t);
    }

    public void onComplete() {
        this.wrappedSubscriber.onComplete();
    }
}

