/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access.sqlite;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.IndexStatus;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex;
import software.amazon.dynamodb.services.local.google.Preconditions;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;
import software.amazon.dynamodb.services.local.shared.access.sqlite.SQLiteIndexElement;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TableSchemaInfo {
    private List<AttributeDefinition> attributes = null;
    private List<LocalSecondaryIndex> lsiList = null;
    @Deprecated
    private List<GlobalSecondaryIndex> gsiList = null;
    private List<GlobalSecondaryIndexDescription> gsiDescList = null;
    private List<List<SQLiteIndexElement>> uniqueGSIIndexes = null;
    private String timeToLiveAttributeName = null;
    private Map<String, List<SQLiteIndexElement>> sqliteIndex = null;
    private List<SQLiteIndexElement> uniqueIndexes = null;

    public TableSchemaInfo() {
    }

    @JsonIgnore
    public TableSchemaInfo(AttributeDefinition hashKeyDef, AttributeDefinition rangeKeyDef, List<AttributeDefinition> attributes, List<LocalSecondaryIndex> lsiList, List<GlobalSecondaryIndexDescription> gsiDescList) {
        Preconditions.checkNotNull(attributes, "attribute definition list may not be null");
        this.attributes = attributes;
        this.lsiList = lsiList;
        this.gsiDescList = gsiDescList;
        this.gsiList = LocalDBUtils.getGsiListFrom(gsiDescList);
        this.uniqueIndexes = new ArrayList<SQLiteIndexElement>();
        this.sqliteIndex = new HashMap<String, List<SQLiteIndexElement>>();
        ArrayList<SQLiteIndexElement> primaryIndexes = new ArrayList<SQLiteIndexElement>();
        SQLiteIndexElement hashKeyIndex = new SQLiteIndexElement(KeyType.HASH, hashKeyDef, "hashKey");
        primaryIndexes.add(hashKeyIndex);
        this.uniqueIndexes.add(hashKeyIndex);
        if (rangeKeyDef != null) {
            SQLiteIndexElement rangeKeyIndex = new SQLiteIndexElement(KeyType.RANGE, rangeKeyDef, "rangeKey");
            primaryIndexes.add(rangeKeyIndex);
            this.uniqueIndexes.add(rangeKeyIndex);
        }
        this.sqliteIndex.put("", primaryIndexes);
        this.initializeIndexMappings();
    }

    @JsonProperty(value="Attributes")
    public List<AttributeDefinition> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="Attributes")
    public void setAttributes(List<AttributeDefinition> attributes) {
        this.attributes = attributes;
    }

    @JsonProperty(value="LSIList")
    public List<LocalSecondaryIndex> getLsiList() {
        return this.lsiList;
    }

    @JsonProperty(value="GSIDescList")
    public List<GlobalSecondaryIndexDescription> getGsiDescList() {
        return this.gsiDescList;
    }

    @JsonProperty(value="GSIList")
    public List<GlobalSecondaryIndex> getGsiList() {
        return this.gsiList;
    }

    @JsonProperty(value="GSIDescList")
    public void setGsiDescList(List<GlobalSecondaryIndexDescription> updatedGSIDescList) {
        this.gsiDescList = updatedGSIDescList;
        this.gsiList = LocalDBUtils.getGsiListFrom(updatedGSIDescList);
    }

    @JsonProperty(value="SQLiteIndex")
    public Map<String, List<SQLiteIndexElement>> getSqliteIndex() {
        return this.sqliteIndex;
    }

    @JsonProperty(value="TimeToLiveAttributeName")
    public String getTimeToLiveAttributeName() {
        return this.timeToLiveAttributeName;
    }

    @JsonProperty(value="TimeToLiveAttributeName")
    public void setTimeToLiveAttributeName(String timeToLiveAttributeName) {
        this.timeToLiveAttributeName = timeToLiveAttributeName;
    }

    private void initializeIndexMappings() {
        int nextColumnIndex = 0;
        Map<String, AttributeDefinition> attributeNameToDefinitions = this.attributeNameToDefinitionsMap();
        SQLiteIndexElement baseTableHashKeyIndex = this.getHashKeyIndex();
        AttributeDefinition baseTableRangeKeyDef = this.getRangeKeyDefinition();
        HashMap<String, Object> nonGSIdDBAttrNameToSQLiteColNameMap = new HashMap<String, Object>();
        nonGSIdDBAttrNameToSQLiteColNameMap.put(baseTableHashKeyIndex.getDynamoDBAttribute().attributeName(), "hashKey");
        if (baseTableRangeKeyDef != null) {
            nonGSIdDBAttrNameToSQLiteColNameMap.put(baseTableRangeKeyDef.attributeName(), "rangeKey");
        }
        if (this.lsiList != null) {
            for (LocalSecondaryIndex lsi : this.lsiList) {
                AttributeDefinition lsiRangeKeyDef = attributeNameToDefinitions.get(((KeySchemaElement)lsi.keySchema().get(1)).attributeName());
                boolean isNewSQLiteColumnRequired = !nonGSIdDBAttrNameToSQLiteColNameMap.containsKey(lsiRangeKeyDef.attributeName());
                String lsiRangeSQLColName = isNewSQLiteColumnRequired ? "indexKey_" + nextColumnIndex++ : (String)nonGSIdDBAttrNameToSQLiteColNameMap.get(lsiRangeKeyDef.attributeName());
                ArrayList<SQLiteIndexElement> indexColumns = new ArrayList<SQLiteIndexElement>();
                indexColumns.add(baseTableHashKeyIndex);
                SQLiteIndexElement lsiRangeKeyIndex = new SQLiteIndexElement(KeyType.RANGE, lsiRangeKeyDef, lsiRangeSQLColName);
                indexColumns.add(lsiRangeKeyIndex);
                if (isNewSQLiteColumnRequired) {
                    this.uniqueIndexes.add(lsiRangeKeyIndex);
                }
                this.sqliteIndex.put(lsi.indexName(), indexColumns);
                nonGSIdDBAttrNameToSQLiteColNameMap.put(lsiRangeKeyDef.attributeName(), lsiRangeSQLColName);
            }
        }
        if (this.gsiDescList != null) {
            this.uniqueGSIIndexes = new ArrayList<List<SQLiteIndexElement>>();
            HashMap<String, String> dDBAttrNameToSQLiteColNameMap = new HashMap<String, String>(nonGSIdDBAttrNameToSQLiteColNameMap);
            nextColumnIndex = this.addGSIColumnMappings(this.gsiDescList, dDBAttrNameToSQLiteColNameMap, nextColumnIndex);
        }
    }

    public void addGSIColumnMappings(List<GlobalSecondaryIndexDescription> gsisToAdd, int nextColumnIndex) {
        this.addGSIColumnMappings(gsisToAdd, this.dDBAttrNameToSQLiteColNameMap(), nextColumnIndex);
    }

    public int addGSIColumnMappings(List<GlobalSecondaryIndexDescription> gsisToAdd, Map<String, String> dDBAttrNameToSQLiteColNameMap, int nextColumnIndex) {
        HashMap<String, Set<String>> gsiHashToRangeMap = new HashMap<String, Set<String>>();
        for (GlobalSecondaryIndexDescription gsi : gsisToAdd) {
            nextColumnIndex = this.addGSIColumnMapping(gsi, dDBAttrNameToSQLiteColNameMap, gsiHashToRangeMap, nextColumnIndex);
        }
        return nextColumnIndex;
    }

    public void removeGSIColumnMappings(List<GlobalSecondaryIndexDescription> gsiToDelete) {
        for (GlobalSecondaryIndexDescription gsi : gsiToDelete) {
            if (!IndexStatus.DELETING.toString().equals(gsi.indexStatusAsString())) continue;
            List<SQLiteIndexElement> indexElements = this.sqliteIndex.get(gsi.indexName());
            this.sqliteIndex.remove(gsi.indexName());
            if (this.numberOfGSIsWithSchema(this.gsiDescList, gsi.keySchema()) != 1) continue;
            this.uniqueGSIIndexes = this.removeFrom(this.uniqueGSIIndexes, indexElements);
        }
    }

    private List<List<SQLiteIndexElement>> removeFrom(List<List<SQLiteIndexElement>> list, List<SQLiteIndexElement> elementToRemove) {
        ArrayList<List<SQLiteIndexElement>> result = new ArrayList<List<SQLiteIndexElement>>();
        for (List<SQLiteIndexElement> element : list) {
            if (LocalDBUtils.isSQLiteIndexElementsEqual(element, elementToRemove)) continue;
            result.add(element);
        }
        return result;
    }

    private int numberOfGSIsWithSchema(List<GlobalSecondaryIndexDescription> updatedGSIList, List<KeySchemaElement> keySchema) {
        int count = 0;
        for (GlobalSecondaryIndexDescription desc : updatedGSIList) {
            if (!LocalDBUtils.isKeySchemasEqual(keySchema, desc.keySchema())) continue;
            ++count;
        }
        return count;
    }

    private Map<String, String> dDBAttrNameToSQLiteColNameMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.getSqliteIndex() != null) {
            for (Map.Entry<String, List<SQLiteIndexElement>> entry : this.getSqliteIndex().entrySet()) {
                for (SQLiteIndexElement ele : entry.getValue()) {
                    result.put(ele.getDynamoDBAttribute().attributeName(), ele.getSqliteColumnName());
                }
            }
        }
        return result;
    }

    private int addGSIColumnMapping(GlobalSecondaryIndexDescription gsi, Map<String, String> dDBAttrNameToSQLiteColNameMap, Map<String, Set<String>> gsiHashToRangeMap, int nextColumnIndex) {
        Map<String, AttributeDefinition> attributeNameToDefinitions = this.attributeNameToDefinitionsMap();
        AttributeDefinition gsiHashKeyDef = attributeNameToDefinitions.get(((KeySchemaElement)gsi.keySchema().get(0)).attributeName());
        AttributeDefinition gsiRangeKeyDef = null;
        if (gsi.keySchema().size() == 2) {
            gsiRangeKeyDef = attributeNameToDefinitions.get(((KeySchemaElement)gsi.keySchema().get(1)).attributeName());
        }
        boolean isNewSQLiteColRequiredForGSIHashKey = !dDBAttrNameToSQLiteColNameMap.containsKey(gsiHashKeyDef.attributeName());
        String gsiHashSQLColName = isNewSQLiteColRequiredForGSIHashKey ? "indexKey_" + nextColumnIndex++ : dDBAttrNameToSQLiteColNameMap.get(gsiHashKeyDef.attributeName());
        dDBAttrNameToSQLiteColNameMap.put(gsiHashKeyDef.attributeName(), gsiHashSQLColName);
        Object gsiRangeSQLColName = null;
        if (gsiRangeKeyDef != null) {
            gsiRangeSQLColName = dDBAttrNameToSQLiteColNameMap.get(gsiRangeKeyDef.attributeName());
        }
        if (gsiRangeKeyDef != null) {
            boolean isNewSQLiteColRequiredForGSIRangeKey = !dDBAttrNameToSQLiteColNameMap.containsKey(gsiRangeKeyDef.attributeName());
            gsiRangeSQLColName = isNewSQLiteColRequiredForGSIRangeKey ? "indexKey_" + nextColumnIndex++ : dDBAttrNameToSQLiteColNameMap.get(gsiRangeKeyDef.attributeName());
            dDBAttrNameToSQLiteColNameMap.put(gsiRangeKeyDef.attributeName(), (String)gsiRangeSQLColName);
        }
        List<SQLiteIndexElement> indexColumns = this.gsiIndexColumns(gsiHashSQLColName, (String)gsiRangeSQLColName, gsiHashKeyDef, gsiRangeKeyDef);
        if (this.uniqueGSIIndexes == null) {
            this.uniqueGSIIndexes = new ArrayList<List<SQLiteIndexElement>>();
        }
        if (this.isGSIUniqueIndex(gsiHashKeyDef, gsiRangeKeyDef, gsiHashToRangeMap)) {
            this.uniqueGSIIndexes.add(indexColumns);
            if (gsiHashToRangeMap.containsKey(gsiHashKeyDef.attributeName())) {
                if (gsiRangeKeyDef == null) {
                    gsiHashToRangeMap.get(gsiHashKeyDef.attributeName()).add(null);
                } else {
                    gsiHashToRangeMap.get(gsiHashKeyDef.attributeName()).add(gsiRangeKeyDef.attributeName());
                }
            } else {
                HashSet<String> rangeKeys = new HashSet<String>();
                if (gsiRangeKeyDef == null) {
                    rangeKeys.add(null);
                } else {
                    rangeKeys.add(gsiRangeKeyDef.attributeName());
                }
                gsiHashToRangeMap.put(gsiHashKeyDef.attributeName(), rangeKeys);
            }
        }
        dDBAttrNameToSQLiteColNameMap.put(gsiHashKeyDef.attributeName(), gsiHashSQLColName);
        if (gsiRangeKeyDef != null) {
            dDBAttrNameToSQLiteColNameMap.put(gsiRangeKeyDef.attributeName(), (String)gsiRangeSQLColName);
        }
        this.sqliteIndex.put(gsi.indexName(), indexColumns);
        return nextColumnIndex;
    }

    private boolean isGSIUniqueIndex(AttributeDefinition gsiHashKey, AttributeDefinition gsiRangeKeyDef, Map<String, Set<String>> gsiHashToRangeMap) {
        AttributeDefinition baseTableHashKeyDef = this.getHashKeyIndex().getDynamoDBAttribute();
        AttributeDefinition baseTableRangeKeyDef = this.getRangeKeyDefinition();
        String baseTableHashKeyName = baseTableHashKeyDef.attributeName();
        String gsiHashKeyName = gsiHashKey.attributeName();
        Map<String, String> nonGSIColumnMappings = this.nonGSIColumnMappings();
        if (baseTableRangeKeyDef == null && gsiRangeKeyDef == null && gsiHashKeyName.equals(baseTableHashKeyName)) {
            return false;
        }
        if (baseTableRangeKeyDef != null && gsiRangeKeyDef != null && nonGSIColumnMappings.containsKey(gsiHashKeyName) && nonGSIColumnMappings.containsKey(gsiRangeKeyDef.attributeName())) {
            return false;
        }
        if (gsiRangeKeyDef == null && gsiHashToRangeMap.containsKey(gsiHashKeyName) && gsiHashToRangeMap.get(gsiHashKeyName).contains(null)) {
            return false;
        }
        if (gsiRangeKeyDef != null) {
            if (gsiHashToRangeMap.containsKey(gsiHashKeyName) && gsiHashToRangeMap.get(gsiHashKeyName).contains(gsiRangeKeyDef.attributeName())) {
                return false;
            }
            return !gsiHashToRangeMap.containsKey(gsiRangeKeyDef.attributeName()) || !gsiHashToRangeMap.containsKey(gsiHashKeyName) || !gsiHashToRangeMap.get(gsiHashKeyName).contains(gsiHashKeyName);
        }
        return true;
    }

    private Map<String, String> nonGSIColumnMappings() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(this.getHashKeyIndex().getDynamoDBAttribute().attributeName(), "hashKey");
        AttributeDefinition baseTableRangeKeyDef = this.getRangeKeyDefinition();
        if (baseTableRangeKeyDef != null) {
            result.put(baseTableRangeKeyDef.attributeName(), "rangeKey");
        }
        if (this.lsiList != null) {
            for (LocalSecondaryIndex lsi : this.lsiList) {
                SQLiteIndexElement lsiSQLElement = this.sqliteIndex.get(lsi.indexName()).get(1);
                result.put(((KeySchemaElement)lsi.keySchema().get(1)).attributeName(), lsiSQLElement.getSqliteColumnName());
            }
        }
        return result;
    }

    private List<SQLiteIndexElement> gsiIndexColumns(String gsiHashSQLColName, String gsiRangeSQLColName, AttributeDefinition gsiHashKeyDef, AttributeDefinition gsiRangeKeyDef) {
        ArrayList<SQLiteIndexElement> indexColumns = new ArrayList<SQLiteIndexElement>();
        SQLiteIndexElement gsiHashKeyIndex = new SQLiteIndexElement(KeyType.HASH, gsiHashKeyDef, gsiHashSQLColName);
        indexColumns.add(gsiHashKeyIndex);
        if (gsiRangeKeyDef != null) {
            SQLiteIndexElement gsiRangeKeyIndex = new SQLiteIndexElement(KeyType.RANGE, gsiRangeKeyDef, gsiRangeSQLColName);
            indexColumns.add(gsiRangeKeyIndex);
        }
        return indexColumns;
    }

    @JsonIgnore
    public SQLiteIndexElement getGSIHashIndexElement(String indexName) {
        List<SQLiteIndexElement> indexes = this.sqliteIndex.get(indexName);
        if (indexes == null) {
            return null;
        }
        return indexes.get(0);
    }

    @JsonIgnore
    public SQLiteIndexElement getGSIRangeIndexElement(String indexName) {
        List<SQLiteIndexElement> indexes = this.sqliteIndex.get(indexName);
        if (indexes == null || indexes.size() < 2) {
            return null;
        }
        return indexes.get(1);
    }

    @JsonIgnore
    public SQLiteIndexElement getLSIRangeIndexElement(String indexName) {
        List<SQLiteIndexElement> indexes = this.sqliteIndex.get(indexName);
        if (indexes == null) {
            return null;
        }
        return indexes.get(1);
    }

    private Map<String, AttributeDefinition> attributeNameToDefinitionsMap() {
        HashMap<String, AttributeDefinition> result = new HashMap<String, AttributeDefinition>();
        for (AttributeDefinition attributeDefinition : this.attributes) {
            result.put(attributeDefinition.attributeName(), attributeDefinition);
        }
        return result;
    }

    public boolean hasGSIs() {
        return this.getGsiDescList() != null && this.getGsiDescList().size() > 0;
    }

    public List<GlobalSecondaryIndexDescription> getGSIsByIndexStatus(IndexStatus status, Boolean backfilling) {
        if (this.hasGSIs()) {
            return LocalDBUtils.getGSIsByIndexStatus(this.getGsiDescList(), status, backfilling);
        }
        return new ArrayList<GlobalSecondaryIndexDescription>();
    }

    @JsonIgnore
    public SQLiteIndexElement getHashKeyIndex() {
        return this.sqliteIndex.get("").get(0);
    }

    @JsonIgnore
    public AttributeDefinition getHashKeyDefinition() {
        return this.getHashKeyIndex().getDynamoDBAttribute();
    }

    @JsonIgnore
    public SQLiteIndexElement getRangeKeyIndex() {
        if (this.sqliteIndex.get("").size() == 2) {
            return this.sqliteIndex.get("").get(1);
        }
        return null;
    }

    @JsonProperty(value="UniqueIndexes")
    public List<SQLiteIndexElement> getUniqueIndexes() {
        return this.uniqueIndexes;
    }

    @JsonProperty(value="UniqueGSIIndexes")
    public List<List<SQLiteIndexElement>> getUniqueGSIIndexes() {
        return this.uniqueGSIIndexes;
    }

    @JsonIgnore
    public AttributeDefinition getRangeKeyDefinition() {
        SQLiteIndexElement index = this.getRangeKeyIndex();
        if (index != null) {
            return index.getDynamoDBAttribute();
        }
        return null;
    }
}

