/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access.api.dp;

import com.amazonaws.services.dynamodbv2.datamodel.ProjectionExpression;
import com.amazonaws.services.dynamodbv2.dbenv.DbEnv;
import com.amazonaws.services.dynamodbv2.rr.ProjectionExpressionWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.Get;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItem;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsResponse;
import software.amazon.dynamodb.services.exceptions.AWSExceptionFactory;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.LocalDBInputConverter;
import software.amazon.dynamodb.services.local.shared.access.LocalDBOutputConverter;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;
import software.amazon.dynamodb.services.local.shared.access.LocalDBValidatorUtils;
import software.amazon.dynamodb.services.local.shared.access.TableInfo;
import software.amazon.dynamodb.services.local.shared.access.api.dp.ReadDataPlaneFunction;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionMessage;
import software.amazon.dynamodb.services.local.shared.helpers.ConsumedCapacityUtils;
import software.amazon.dynamodb.services.local.shared.helpers.MultiTableLock;
import software.amazon.dynamodb.services.local.shared.helpers.TransactionsEnabledMode;
import software.amazon.dynamodb.services.local.shared.model.AttributeValue;
import software.amazon.dynamodb.services.local.shared.model.TableNameAndPrimaryKey;

public class TransactGetItemsFunction
extends ReadDataPlaneFunction<TransactGetItemsRequest, TransactGetItemsResponse> {
    public TransactGetItemsFunction(LocalDBAccess access, LocalDBInputConverter inputConverter, LocalDBOutputConverter localDBOutputConverter, AWSExceptionFactory awsExceptionFactory, DbEnv localDBEnv) {
        super(access, localDBEnv, inputConverter, localDBOutputConverter, awsExceptionFactory, TransactionsEnabledMode.TRANSACTIONS_ENABLED);
    }

    @Override
    public TransactGetItemsResponse apply(final TransactGetItemsRequest input) {
        this.validateRequest(input);
        TreeSet<String> tableNames = new TreeSet<String>();
        for (TransactGetItem item : input.transactItems()) {
            tableNames.add(item.get().tableName());
        }
        MultiTableLock tableLocker = new MultiTableLock(tableNames, this.dbAccess, MultiTableLock.LockMode.READ);
        final ArrayList items = new ArrayList();
        Runnable criticalSection = new Runnable(){

            @Override
            public void run() {
                items.addAll(TransactGetItemsFunction.this.doGetItems(input.transactItems()));
            }
        };
        tableLocker.wrapInTableLocks(criticalSection).run();
        HashMap itemsByTable = new HashMap();
        ArrayList<Map<String, AttributeValue>> filteredItems = new ArrayList<Map<String, AttributeValue>>(items.size());
        for (int i = 0; i < input.transactItems().size(); ++i) {
            Get get = ((TransactGetItem)input.transactItems().get(i)).get();
            ProjectionExpressionWrapper projectionExpressionWrapper = this.inputConverter.externalToInternalProjectionExpression(get.projectionExpression(), get.expressionAttributeNames());
            ProjectionExpression projectionExpression = projectionExpressionWrapper == null ? null : projectionExpressionWrapper.getProjection();
            Map<String, AttributeValue> filteredAttributes = projectionExpression != null ? LocalDBUtils.projectAttributes((Map<String, AttributeValue>)((Map)items.get(i)), projectionExpression) : (Map<String, AttributeValue>)items.get(i);
            filteredItems.add(filteredAttributes);
            if (!itemsByTable.containsKey(get.tableName())) {
                itemsByTable.put(get.tableName(), new ArrayList());
            }
            ((List)itemsByTable.get(get.tableName())).add((Map)items.get(i));
        }
        this.validateResponsePayloadSizeLimit(filteredItems);
        ReturnConsumedCapacity returnConsumedCapacity = this.convertReturnConsumedCapacity(input.returnConsumedCapacityAsString());
        ArrayList<ConsumedCapacity> consumedCapacities = new ArrayList<ConsumedCapacity>(itemsByTable.size());
        for (String tableName : itemsByTable.keySet()) {
            ConsumedCapacity consumedCapacity = ConsumedCapacityUtils.computeConsumedCapacity((List)itemsByTable.get(tableName), false, false, tableName, null, true, true, this.transactionsMode, returnConsumedCapacity);
            if (consumedCapacity == null) continue;
            consumedCapacity = (ConsumedCapacity)consumedCapacity.toBuilder().readCapacityUnits(consumedCapacity.capacityUnits()).build();
            consumedCapacities.add(consumedCapacity);
        }
        if (consumedCapacities.isEmpty()) {
            consumedCapacities = null;
        }
        return (TransactGetItemsResponse)TransactGetItemsResponse.builder().responses(this.localDBOutputConverter.internalToExternalTransactGetItemsResponses(filteredItems)).consumedCapacity(consumedCapacities).build();
    }

    private long validateResponsePayloadSizeLimit(List<Map<String, AttributeValue>> filteredItems) {
        long transactionResponsePayloadSizeBytes = 0L;
        for (Map<String, AttributeValue> item : filteredItems) {
            transactionResponsePayloadSizeBytes += 4L;
            if ((transactionResponsePayloadSizeBytes += LocalDBUtils.getItemSizeBytes(item)) <= 0x400000L) continue;
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TRANSACT_RESPONSE_PAYLOAD_TOO_LARGE.getMessage() + transactionResponsePayloadSizeBytes);
        }
        return transactionResponsePayloadSizeBytes;
    }

    private void validateRequest(TransactGetItemsRequest request) {
        try {
            if (request.transactItems() == null || request.transactItems().isEmpty()) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TRANSACT_GET_NULL_REQUESTS.getMessage());
            }
            if (request.transactItems().size() > 100) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TRANSACT_TOO_MANY_REQUESTS.getMessage());
            }
            long transactionPayloadSizeBytes = 0L;
            HashSet<TableNameAndPrimaryKey> keysToGet = new HashSet<TableNameAndPrimaryKey>();
            for (TransactGetItem item : request.transactItems()) {
                if (item == null) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TRANSACT_GET_NULL_REQUESTS.getMessage());
                }
                Get get = item.get();
                if ((transactionPayloadSizeBytes += this.validateGet(get, keysToGet)) <= 0x400000L) continue;
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TRANSACT_REQUEST_PAYLOAD_TOO_LARGE.getMessage() + transactionPayloadSizeBytes);
            }
        }
        catch (AwsServiceException e) {
            if (e.awsErrorDetails().errorCode().equals(AmazonServiceExceptionType.VALIDATION_EXCEPTION.getErrorCode())) {
                String msg = e.awsErrorDetails().errorMessage();
                if (LocalDBClientExceptionMessage.INCONSISTENT_GET_CONDITION_SIZE.getMessage().equals(msg) || LocalDBClientExceptionMessage.INCONSISTENT_TYPES.getMessage().equals(msg) || LocalDBClientExceptionMessage.INCONSISTENT_PRIMARY_KEY_TYPES.getMessage().equals(msg) || LocalDBClientExceptionMessage.INCONSISTENT_INDEX_KEY_TYPES.getMessage().equals(msg) || LocalDBClientExceptionMessage.NO_SPECIFED_KEY_VALUE.getMessage().equals(msg)) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.TRANSACTION_CANCELED_EXCEPTION, e.awsErrorDetails().errorMessage());
                }
            }
            throw e;
        }
    }

    private long validateGet(Get get, Set<TableNameAndPrimaryKey> keysToGet) {
        if (get == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TRANSACT_GET_NULL_REQUESTS.getMessage());
        }
        if (get.tableName() == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.REQUESTED_RESOURCE_NOT_FOUND.getMessage());
        }
        TableInfo tableInfo = this.validateTableExists(get.tableName());
        this.inputConverter.validateExpressionAttributeNamesUsedOnlyWithExpressions(get.projectionExpression(), null, null, null, null, get.expressionAttributeNames());
        ProjectionExpressionWrapper projectionExpressionWrapper = this.inputConverter.externalToInternalProjectionExpression(get.projectionExpression(), get.expressionAttributeNames());
        LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(tableInfo, projectionExpressionWrapper, this.awsExceptionFactory);
        if (!get.hasKey()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.BAD_GET_CONDITION.getMessage());
        }
        Map primaryKey = (Map)this.inputConverter.externalToInternalAttributes(get.key());
        this.validateGetKey(primaryKey, tableInfo);
        TableNameAndPrimaryKey keyToGet = new TableNameAndPrimaryKey(get.tableName(), primaryKey);
        if (keysToGet.contains(keyToGet)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TRANSACT_DUPLICATE_KEY.getMessage());
        }
        keysToGet.add(keyToGet);
        long totalSize = 0L;
        totalSize += LocalDBUtils.getItemSizeBytes(primaryKey);
        return totalSize += projectionExpressionWrapper != null ? (long)projectionExpressionWrapper.getCumulativeSize() : 0L;
    }

    private List<Map<String, AttributeValue>> doGetItems(List<TransactGetItem> itemsToGet) {
        ArrayList<Map<String, AttributeValue>> items = new ArrayList<Map<String, AttributeValue>>(itemsToGet.size());
        for (TransactGetItem item : itemsToGet) {
            Get get = item.get();
            Map<String, AttributeValue> result = this.dbAccess.getRecord(get.tableName(), (Map)this.inputConverter.externalToInternalAttributes(get.key()));
            items.add(result);
        }
        return items;
    }
}

