/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access.api.cp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.OnDemandThroughput;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.StreamSpecification;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.dynamodb.services.exceptions.AWSExceptionFactory;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;
import software.amazon.dynamodb.services.local.shared.access.api.cp.ControlPlaneFunction;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionMessage;

public class CreateTableFunction
extends ControlPlaneFunction<CreateTableRequest, CreateTableResponse> {
    public CreateTableFunction(LocalDBAccess dbAccess) {
        super(dbAccess);
    }

    @Override
    public CreateTableResponse apply(CreateTableRequest createTableRequest) {
        OnDemandThroughput onDemandThroughput;
        ProvisionedThroughput throughput;
        int maxSize;
        AttributeDefinition rangeKey;
        if (createTableRequest == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.INVALID_PARAMETER_VALUE, "createTableRequest was null");
        }
        final String tableName = createTableRequest.tableName();
        this.validateTableName(tableName);
        final Boolean deletionProtectionEnabled = createTableRequest.deletionProtectionEnabled();
        List keySchema = createTableRequest.keySchema();
        this.validateKeySchema(keySchema);
        int numKeysOnBaseTable = keySchema.size();
        boolean isHashAndRangeKey = numKeysOnBaseTable == 2;
        final List allAttributes = createTableRequest.attributeDefinitions();
        this.validateAttributeDefinitions(allAttributes);
        final AttributeDefinition hashKey = LocalDBUtils.findAttributeDefinition((KeySchemaElement)keySchema.get(0), allAttributes);
        if (hashKey == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NON_SPECIFIED_HASH_KEY.getMessage());
        }
        AttributeDefinition attributeDefinition = rangeKey = isHashAndRangeKey ? LocalDBUtils.findAttributeDefinition((KeySchemaElement)keySchema.get(1), allAttributes) : null;
        if (isHashAndRangeKey && rangeKey == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NON_SPECIFIED_RANGE_KEY.getMessage());
        }
        final List lsiIndexes = createTableRequest.localSecondaryIndexes();
        if (!isHashAndRangeKey && lsiIndexes != null && !lsiIndexes.isEmpty()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_LSI_ALLOWED.getMessage());
        }
        HashSet<String> lsiNames = new HashSet<String>();
        ArrayList<String> lsiProjAttr = new ArrayList<String>();
        int numLSIKeys = this.validateLSISchema(lsiIndexes, hashKey.attributeName(), allAttributes, rangeKey, lsiNames, lsiProjAttr);
        final List gsiIndexes = createTableRequest.globalSecondaryIndexes();
        boolean isTheRequestCreatingGSIs = createTableRequest.hasGlobalSecondaryIndexes();
        if (isTheRequestCreatingGSIs) {
            if (gsiIndexes.isEmpty()) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.EMPTY_GSI_LIST.getMessage());
            }
            if (gsiIndexes.size() > 20) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MANY_GSI_VALIDATION_EXCEPTION.getMessage());
            }
        }
        String billingModeString = createTableRequest.billingModeAsString();
        final BillingMode billingMode = CreateTableFunction.getBillingMode(billingModeString);
        List<GlobalSecondaryIndexDescription> gsiDescList = LocalDBUtils.getGsiDescListFrom(gsiIndexes);
        int numGSIKeys = this.validateGSISchemas(gsiDescList, hashKey, rangeKey, allAttributes, new ArrayList<String>(lsiNames), lsiProjAttr.size(), billingMode);
        int n = maxSize = isHashAndRangeKey ? 2 + numLSIKeys + numGSIKeys : 1 + numGSIKeys;
        if (allAttributes.size() > maxSize) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MANY_ATTRIBUTES.getMessage());
        }
        final ArrayList modifiedGsiIndexes = new ArrayList();
        if (BillingMode.PROVISIONED.equals((Object)billingMode)) {
            throughput = this.validateProvisionedThroughput(createTableRequest, tableName, gsiDescList);
            onDemandThroughput = EMPTY_ONDEMAND_THROUGHPUT;
        } else {
            throughput = ZERO_PROVISIONED_THROUGHPUT;
            onDemandThroughput = this.validateOndemandThroughput(createTableRequest, tableName, gsiDescList);
        }
        final StreamSpecification spec = createTableRequest.streamSpecification();
        this.validateStreamSpecification(spec, null, true);
        new LocalDBAccess.WriteLockWithTimeout(this.dbAccess.getLockForTable(tableName), 10){

            @Override
            public void criticalSection() {
                CreateTableFunction.this.validateTableNotExists(tableName);
                CreateTableFunction.this.dbAccess.createTable(tableName, hashKey, rangeKey, allAttributes, lsiIndexes, modifiedGsiIndexes.isEmpty() ? gsiIndexes : modifiedGsiIndexes, throughput, onDemandThroughput, billingMode, deletionProtectionEnabled, spec);
            }
        }.execute();
        TableDescription newTableDesc = this.getTableDescriptionHelper(tableName);
        newTableDesc = (TableDescription)newTableDesc.toBuilder().itemCount(Long.valueOf(0L)).tableSizeBytes(Long.valueOf(0L)).build();
        return (CreateTableResponse)CreateTableResponse.builder().tableDescription(newTableDesc).build();
    }

    private OnDemandThroughput validateOndemandThroughput(CreateTableRequest createTableRequest, String tableName, List<GlobalSecondaryIndexDescription> gsiDescList) {
        OnDemandThroughput onDemandThroughput;
        if (createTableRequest.onDemandThroughput() != null) {
            onDemandThroughput = createTableRequest.onDemandThroughput();
            this.validateOndemandThroughputIncrease(onDemandThroughput, null);
            this.validateOndemandThroughputWithGSIs(tableName, onDemandThroughput, gsiDescList);
        } else {
            onDemandThroughput = EMPTY_ONDEMAND_THROUGHPUT;
        }
        return onDemandThroughput;
    }

    @NotNull
    private ProvisionedThroughput validateProvisionedThroughput(CreateTableRequest createTableRequest, String tableName, List<GlobalSecondaryIndexDescription> gsiDescList) {
        ProvisionedThroughput throughput = createTableRequest.provisionedThroughput();
        this.validateProvisionedThroughputIncrease(throughput, null);
        this.validateProvisionedThroughputWithGSIs(tableName, throughput, gsiDescList);
        return throughput;
    }

    @NotNull
    protected static BillingMode getBillingMode(String billingModeString) {
        return StringUtils.isNotBlank((CharSequence)billingModeString) && BillingMode.PAY_PER_REQUEST.equals((Object)BillingMode.fromValue((String)billingModeString)) ? BillingMode.PAY_PER_REQUEST : BillingMode.PROVISIONED;
    }

    private int validateLSISchema(List<LocalSecondaryIndex> lsiList, String hashKeyName, List<AttributeDefinition> allAttributes, AttributeDefinition rangeKeyDef, Set<String> lsiNames, List<String> projAttributes) {
        if (CollectionUtils.isNullOrEmpty(lsiList)) {
            return 0;
        }
        CreateTableFunction.checkLsiEmpty(lsiList);
        if (lsiList.size() > 5) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MANY_LSI.getMessage());
        }
        HashSet<AttributeDefinition> lsiRangeKeys = new HashSet<AttributeDefinition>();
        int totalProjectedAttrs = 0;
        for (LocalSecondaryIndex lsi : lsiList) {
            String lsiName = lsi.indexName();
            this.validateTableName(lsiName);
            CreateTableFunction.checkSameLSIName(lsiNames, lsiName);
            if ((long)(totalProjectedAttrs += this.validateProjection(lsi.projection(), projAttributes)) > 100L) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MANY_PROJECTED.getMessage());
            }
            lsiNames.add(lsiName);
            List lsiSchema = lsi.keySchema();
            this.validateKeySchema(lsiSchema);
            if (lsiSchema.size() < 2) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_LSI_NO_RANGE.getMessage());
            }
            KeySchemaElement lsiHashKey = (KeySchemaElement)lsiSchema.get(0);
            if (lsiHashKey == null || !lsiHashKey.attributeName().equals(hashKeyName) || !lsiHashKey.keyType().equals((Object)KeyType.HASH)) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_LSI.getMessage());
            }
            KeySchemaElement lsiRangeKey = (KeySchemaElement)lsiSchema.get(1);
            if (lsiRangeKey == null || !lsiRangeKey.keyType().equals((Object)KeyType.RANGE)) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_LSI_NO_RANGE.getMessage());
            }
            AttributeDefinition lsiRangeKeyDef = LocalDBUtils.findAttributeDefinition(lsiRangeKey, allAttributes);
            if (lsiRangeKeyDef == null) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NON_SPECIFIED_LSI_RANGE_KEY.getMessage());
            }
            if (lsiRangeKeyDef.equals((Object)rangeKeyDef)) continue;
            lsiRangeKeys.add(lsiRangeKeyDef);
        }
        return lsiRangeKeys.size();
    }

    public static void checkSameLSIName(Set<String> lsiNames, String lsiName) {
        if (lsiNames.contains(lsiName)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.SAME_NAME_LSI.getMessage());
        }
    }

    public static void checkLsiEmpty(List<LocalSecondaryIndex> lsiList) {
        if (lsiList.isEmpty()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.EMPTY_LSI_LIST.getMessage());
        }
    }

    private void validateTableNotExists(String tableName) {
        if (this.dbAccess.getTableInfo(tableName) != null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.RESOURCE_IN_USE_EXCEPTION, LocalDBClientExceptionMessage.TABLE_ALREADY_EXISTS.getMessage());
        }
    }
}

