/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access;

import com.amazonaws.services.dynamodbv2.datamodel.DocumentFactory;
import com.amazonaws.services.dynamodbv2.datamodel.DocumentNodeType;
import com.amazonaws.services.dynamodbv2.dbenv.DbEnv;
import com.amazonaws.services.dynamodbv2.rr.ExpressionWrapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.model.AttributeAction;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.awssdk.services.dynamodb.model.ComparisonOperator;
import software.amazon.awssdk.services.dynamodb.model.Condition;
import software.amazon.awssdk.services.dynamodb.model.ConditionalOperator;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.Select;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;
import software.amazon.dynamodb.services.local.shared.access.LocalDBValidatorUtils;
import software.amazon.dynamodb.services.local.shared.access.SdkBytesComparator;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionMessage;
import software.amazon.dynamodb.services.local.shared.model.AttributeValue;
import software.amazon.dynamodb.services.local.shared.model.DeleteRequest;
import software.amazon.dynamodb.services.local.shared.model.ExpectedAttributeValue;
import software.amazon.dynamodb.services.local.shared.model.PutRequest;
import software.amazon.dynamodb.services.local.shared.model.WriteRequest;
import software.amazon.dynamodb.services.local.shared.validate.ErrorFactory;
import software.amazon.dynamodb.services.local.shared.validate.InputConverter;
import software.amazon.dynamodb.services.local.shared.validate.KeyConditionExpressionExtractor;

public class LocalDBInputConverter
extends InputConverter<AttributeValue, software.amazon.awssdk.services.dynamodb.model.AttributeValue, List<AttributeValue>, Map<String, AttributeValue>, String, software.amazon.dynamodb.services.local.shared.model.AttributeValueUpdate, AttributeValueUpdate, ExpectedAttributeValue, software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue, software.amazon.dynamodb.services.local.shared.model.Condition, Condition, software.amazon.dynamodb.services.local.shared.model.KeysAndAttributes, KeysAndAttributes, WriteRequest, software.amazon.awssdk.services.dynamodb.model.WriteRequest, AttributeAction, ComparisonOperator, ConditionalOperator, Select, ReturnConsumedCapacity, String> {
    public LocalDBInputConverter(DbEnv dbEnv, ErrorFactory errorFactory, DocumentFactory documentFactory, int maxKeyAttributeNameSize) {
        super(dbEnv, errorFactory, documentFactory, true, 409600, maxKeyAttributeNameSize, 100, 25, 0x200000);
    }

    @Override
    public String newAttributeName(String val) {
        if (val == null || val.length() == 0) {
            this.errorFactory.EMPTY_ATTRIBUTE_NAME.throwAsException();
        }
        if (this.getLengthInUTF8Bytes(val) > 65535) {
            this.errorFactory.ATTRIBUTE_NAME_TOO_LARGE.throwAsException();
        }
        return val;
    }

    @Override
    protected boolean isWriteDelete(software.amazon.awssdk.services.dynamodb.model.WriteRequest writeRequest) {
        return writeRequest.deleteRequest() != null;
    }

    @Override
    protected boolean isWritePut(software.amazon.awssdk.services.dynamodb.model.WriteRequest writeRequest) {
        return writeRequest.putRequest() != null;
    }

    @Override
    protected Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> getPutRequestItem(software.amazon.awssdk.services.dynamodb.model.WriteRequest writeRequest) {
        return writeRequest.putRequest().hasItem() ? writeRequest.putRequest().item() : null;
    }

    @Override
    protected Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> getDeleteRequestKey(software.amazon.awssdk.services.dynamodb.model.WriteRequest writeRequest) {
        return writeRequest.deleteRequest().hasKey() ? writeRequest.deleteRequest().key() : null;
    }

    @Override
    protected int getLengthInUTF8Bytes(String val) {
        return val.getBytes(LocalDBUtils.UTF8).length;
    }

    @Override
    protected AttributeValue newS(String val) {
        this.validateStringValue(val);
        AttributeValue ival = new AttributeValue();
        ival.setS(val);
        return ival;
    }

    @Override
    protected AttributeValue newN(String val) {
        LocalDBUtils.validateNumericValue(val);
        AttributeValue ival = new AttributeValue();
        ival.setN(val);
        return ival;
    }

    @Override
    protected AttributeValue newB(SdkBytes binaryAttribute) {
        this.validateNullSdkBytes(binaryAttribute);
        AttributeValue ival = new AttributeValue();
        ival.setB(binaryAttribute.asByteBuffer());
        return ival;
    }

    @Override
    protected AttributeValue newSS(List<String> stringSetAttribute) {
        this.validateStringSetValue(stringSetAttribute);
        AttributeValue ival = new AttributeValue();
        ArrayList<String> sortedList = new ArrayList<String>(stringSetAttribute);
        Collections.sort(sortedList);
        ival.setSS(sortedList);
        return ival;
    }

    @Override
    protected AttributeValue newNS(List<String> numberSetAttribute) {
        LocalDBUtils.validateNumberSet(numberSetAttribute);
        AttributeValue ival = new AttributeValue();
        ArrayList<String> result = null;
        ArrayList<BigDecimal> resultDecimals = new ArrayList<BigDecimal>();
        for (String s : numberSetAttribute) {
            resultDecimals.add(new BigDecimal(s));
        }
        Collections.sort(resultDecimals);
        result = new ArrayList<String>();
        for (BigDecimal decimal : resultDecimals) {
            result.add(decimal.toString());
        }
        ival.setNS(result);
        return ival;
    }

    @Override
    protected AttributeValue newBS(List<SdkBytes> binarySetAttribute) {
        this.validateNullBinarySet(binarySetAttribute);
        AttributeValue ival = new AttributeValue();
        ArrayList<SdkBytes> sortedBinarySetAttribute = new ArrayList<SdkBytes>(binarySetAttribute);
        sortedBinarySetAttribute.sort(SdkBytesComparator.singleton);
        ival.setBsWithSDKBytes(sortedBinarySetAttribute);
        return ival;
    }

    @Override
    protected AttributeValue newBoolean(Boolean val) {
        AttributeValue ival = new AttributeValue();
        ival.setBOOL(val);
        return ival;
    }

    @Override
    protected AttributeValue newNull() {
        AttributeValue ival = new AttributeValue();
        ival.setNULL(true);
        return ival;
    }

    @Override
    protected AttributeValue newM(Map<String, AttributeValue> val) {
        AttributeValue ival = new AttributeValue();
        ival.setM(val);
        return ival;
    }

    @Override
    protected AttributeValue newL(List<AttributeValue> val) {
        AttributeValue ival = new AttributeValue();
        ival.setL(val);
        return ival;
    }

    @Override
    protected int getAttributeSizeInBytes(AttributeValue val) {
        return (int)LocalDBUtils.getAttributeValueSizeBytes(val);
    }

    @Override
    public DocumentNodeType getType(AttributeValue val) {
        return val.getNodeType();
    }

    @Override
    protected List<AttributeValue> newAttrValueList(int depth, int capacity) {
        return new ArrayList<AttributeValue>(capacity);
    }

    @Override
    protected void addAttrValue(List<AttributeValue> list, AttributeValue val) {
        list.add(val);
    }

    @Override
    protected Map<String, AttributeValue> newAttrValueMap(int depth, int capacity) {
        return new HashMap<String, AttributeValue>(capacity);
    }

    @Override
    protected void putAttrValue(Map<String, AttributeValue> map2, String name, AttributeValue val) {
        map2.put(name, val);
    }

    @Override
    protected boolean isValidNestedLevel(int depth) {
        return depth >= 0 && depth < 32;
    }

    @Override
    protected String getS(software.amazon.awssdk.services.dynamodb.model.AttributeValue val) {
        return val.s();
    }

    @Override
    protected String getN(software.amazon.awssdk.services.dynamodb.model.AttributeValue val) {
        return val.n();
    }

    @Override
    protected SdkBytes getB(software.amazon.awssdk.services.dynamodb.model.AttributeValue val) {
        return val.b();
    }

    @Override
    protected Boolean isBOOL(software.amazon.awssdk.services.dynamodb.model.AttributeValue val) {
        return val.bool();
    }

    @Override
    protected Boolean isNULL(software.amazon.awssdk.services.dynamodb.model.AttributeValue val) {
        return val.nul();
    }

    @Override
    protected List<String> getSS(software.amazon.awssdk.services.dynamodb.model.AttributeValue val) {
        return val.ss();
    }

    @Override
    protected List<String> getNS(software.amazon.awssdk.services.dynamodb.model.AttributeValue val) {
        return val.ns();
    }

    @Override
    protected List<SdkBytes> getBS(software.amazon.awssdk.services.dynamodb.model.AttributeValue val) {
        return val.bs();
    }

    @Override
    protected List<software.amazon.awssdk.services.dynamodb.model.AttributeValue> getL(software.amazon.awssdk.services.dynamodb.model.AttributeValue val) {
        return val.l();
    }

    @Override
    protected boolean hasL(software.amazon.awssdk.services.dynamodb.model.AttributeValue val) {
        return val.hasL();
    }

    @Override
    protected boolean hasM(software.amazon.awssdk.services.dynamodb.model.AttributeValue val) {
        return val.hasM();
    }

    @Override
    protected boolean hasSs(software.amazon.awssdk.services.dynamodb.model.AttributeValue val) {
        return val.hasSs();
    }

    @Override
    protected boolean hasNs(software.amazon.awssdk.services.dynamodb.model.AttributeValue val) {
        return val.hasNs();
    }

    @Override
    protected boolean hasBs(software.amazon.awssdk.services.dynamodb.model.AttributeValue val) {
        return val.hasBs();
    }

    @Override
    protected Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> getM(software.amazon.awssdk.services.dynamodb.model.AttributeValue val) {
        return val.m();
    }

    @Override
    protected ExpectedAttributeValue newExpected(AttributeValue val, Boolean exists, List<AttributeValue> avList, ComparisonOperator op) {
        ExpectedAttributeValue expected = new ExpectedAttributeValue();
        expected.setValue(val);
        expected.setExists(exists);
        expected.setAttributeValueList(avList);
        expected.setComparisonOperator(op);
        return expected;
    }

    @Override
    protected software.amazon.dynamodb.services.local.shared.model.AttributeValueUpdate newUpdate(AttributeValue val, AttributeAction action) {
        return new software.amazon.dynamodb.services.local.shared.model.AttributeValueUpdate(val, action.toString());
    }

    @Override
    protected AttributeAction newAction(String val) {
        AttributeAction attributeAction = null;
        try {
            if (val == null) {
                return AttributeAction.PUT;
            }
            attributeAction = AttributeAction.fromValue((String)val);
        }
        catch (IllegalArgumentException illegalArgs) {
            this.errorFactory.INVALID_ACTION_TYPE.throwAsException();
        }
        return attributeAction;
    }

    @Override
    public boolean isDelete(AttributeAction val) {
        return val == AttributeAction.DELETE;
    }

    @Override
    public boolean isAdd(AttributeAction val) {
        return val == AttributeAction.ADD;
    }

    @Override
    protected Boolean isExists(software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue val) {
        return val.exists();
    }

    @Override
    protected ComparisonOperator newComparisonOperator(String val) {
        try {
            return ComparisonOperator.valueOf((String)val);
        }
        catch (Exception e) {
            this.errorFactory.INVALID_COMPARISON.throwAsException();
            return null;
        }
    }

    @Override
    public void validateArgumentsForComparisonOperator(ComparisonOperator op, List<AttributeValue> attributeValues) {
        LocalDBValidatorUtils.validateArgumentsForComparisonOperator(op, attributeValues, this.errorFactory);
    }

    @Override
    protected software.amazon.dynamodb.services.local.shared.model.Condition newCondition(ComparisonOperator op, List<AttributeValue> val) {
        software.amazon.dynamodb.services.local.shared.model.Condition condition = new software.amazon.dynamodb.services.local.shared.model.Condition();
        condition.setComparisonOperator(String.valueOf(op));
        condition.setAttributeValueList(val);
        return condition;
    }

    @Override
    protected String getConditionComparisonOperator(Condition val) {
        return val.comparisonOperatorAsString();
    }

    @Override
    protected List<software.amazon.awssdk.services.dynamodb.model.AttributeValue> getConditionAttributeValueList(Condition val) {
        return val.attributeValueList();
    }

    @Override
    protected ConditionalOperator newConditionalOperator(String val) {
        return ConditionalOperator.valueOf((String)val);
    }

    @Override
    protected Select newSelect(String val) {
        return Select.valueOf((String)val);
    }

    @Override
    protected ReturnConsumedCapacity newReturnConsumedCapacity(String val) {
        return ReturnConsumedCapacity.valueOf((String)val);
    }

    @Override
    protected WriteRequest newPutRequest(String tableName, Map<String, AttributeValue> item) {
        return new WriteRequest(new PutRequest(item));
    }

    @Override
    protected WriteRequest newDeleteRequest(String tableName, Map<String, AttributeValue> key) {
        return new WriteRequest(new DeleteRequest(key));
    }

    @Override
    protected software.amazon.dynamodb.services.local.shared.model.KeysAndAttributes newKeysAndAttributes(Set<Map<String, AttributeValue>> compositeKeySet, Set<String> attrsToGet, Boolean isConsistentRead, String projectionExpression, Map<String, String> expressionAttributeNames) {
        software.amazon.dynamodb.services.local.shared.model.KeysAndAttributes kas = new software.amazon.dynamodb.services.local.shared.model.KeysAndAttributes();
        kas.setKeys(compositeKeySet);
        kas.setAttributesToGet(attrsToGet);
        kas.setConsistentRead(isConsistentRead);
        kas.setProjectionExpression(projectionExpression);
        kas.setExpressionAttributeNames(expressionAttributeNames);
        return kas;
    }

    @Override
    protected List<Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue>> getKeys(KeysAndAttributes kas) {
        return kas.keys();
    }

    @Override
    protected List<String> getAttributesToGet(KeysAndAttributes kas) {
        return kas.attributesToGet();
    }

    @Override
    protected String getProjectionExpression(KeysAndAttributes kas) {
        return kas.projectionExpression();
    }

    @Override
    protected Map<String, String> getExpressionAttributeNames(KeysAndAttributes kas) {
        return kas.expressionAttributeNames();
    }

    @Override
    protected Boolean isConsistentRead(KeysAndAttributes kas) {
        return kas.consistentRead();
    }

    @Override
    protected String newTableName(String accountId, String tableName) {
        return tableName;
    }

    @Override
    protected software.amazon.awssdk.services.dynamodb.model.AttributeValue getExpectedValueExternal(software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue val) {
        software.amazon.awssdk.services.dynamodb.model.AttributeValue ll = val.value();
        return val.value();
    }

    @Override
    protected String getExpectedComparisonOperator(software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue val) {
        return val.comparisonOperatorAsString();
    }

    @Override
    protected List<software.amazon.awssdk.services.dynamodb.model.AttributeValue> getExpectedAttributeValueList(software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue val) {
        return val.attributeValueList();
    }

    @Override
    protected boolean hasExpectedAttributeValueList(software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue val) {
        return val.hasAttributeValueList();
    }

    private String validateStringValue(String value) {
        if (value == null) {
            this.errorFactory.INVALID_PARAMETER_VALUE.throwAsException("An AttributeValue may not contain a null string");
        }
        this.validateIntValueIsPackable(value.length(), false);
        return value;
    }

    private List<String> validateStringSetValue(List<String> stringSet) {
        HashSet<String> stringSetEntries;
        if (stringSet == null) {
            this.errorFactory.INVALID_PARAMETER_VALUE.throwAsException("An string set cannot be null");
        }
        if (stringSet.isEmpty()) {
            this.errorFactory.INVALID_PARAMETER_VALUE.throwAsException(LocalDBClientExceptionMessage.EMPTY_STRING_SET.getMessage());
        }
        if ((stringSetEntries = new HashSet<String>(stringSet)).size() < stringSet.size()) {
            this.errorFactory.INVALID_PARAMETER_VALUE.throwAsException("Input collection " + String.valueOf(stringSet) + " contains duplicates");
        }
        for (String stringValue : stringSet) {
            if (stringValue != null) continue;
            this.errorFactory.INVALID_PARAMETER_VALUE.throwAsException("An string set may not have a null string as a member");
        }
        return stringSet;
    }

    private void validateNullBinarySet(List<SdkBytes> binarySetValue) {
        HashSet<SdkBytes> blobSetEntries;
        if (binarySetValue == null) {
            this.errorFactory.ITEM_CONTAINS_NULL_ATTRVALUE.throwAsException();
        }
        if (binarySetValue.isEmpty()) {
            this.errorFactory.INVALID_PARAMETER_VALUE.throwAsException(LocalDBClientExceptionMessage.EMPTY_BINARY_SET.getMessage());
        }
        if ((blobSetEntries = new HashSet<SdkBytes>(binarySetValue)).size() < binarySetValue.size()) {
            this.errorFactory.INVALID_PARAMETER_VALUE.throwAsException("Input collection of type BS contains duplicates.");
        }
        for (SdkBytes sdkBytes : binarySetValue) {
            this.validateNullSdkBytes(sdkBytes);
        }
    }

    private void validateNullSdkBytes(SdkBytes value) {
        if (value == null) {
            this.errorFactory.ITEM_CONTAINS_NULL_ATTRVALUE.throwAsException();
        }
    }

    private void validateIntValueIsPackable(int value, boolean signed) {
        if (signed) {
            if (value >= 0x200000 || value <= -2097153) {
                this.errorFactory.ITEM_TOO_LARGE.throwAsException();
            }
        } else if (value >= 0x400000 || value < 0) {
            this.errorFactory.ITEM_TOO_LARGE.throwAsException();
        }
    }

    public Map<String, software.amazon.dynamodb.services.local.shared.model.Condition> externalToInternalKeyConditions(Map<String, Condition> keyConditions, ExpressionWrapper keyConditionExpressionWrapper) {
        if (keyConditions != null && !keyConditions.isEmpty()) {
            return this.externalToInternalConditions(keyConditions);
        }
        if (keyConditionExpressionWrapper != null) {
            KeyConditionExpressionExtractor extractor = new KeyConditionExpressionExtractor(this.dbEnv, this.errorFactory);
            return extractor.extractKeyConditions(keyConditionExpressionWrapper.getExpression());
        }
        return null;
    }
}

