/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.server;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.Logger;
import software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeLimitsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeLimitsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveResponse;
import software.amazon.awssdk.services.dynamodb.model.ExecuteStatementRequest;
import software.amazon.awssdk.services.dynamodb.model.ExecuteStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionRequest;
import software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionResponse;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.GetRecordsRequest;
import software.amazon.awssdk.services.dynamodb.model.GetRecordsResponse;
import software.amazon.awssdk.services.dynamodb.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.dynamodb.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsResponse;
import software.amazon.awssdk.services.dynamodb.model.ListTablesRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTablesResponse;
import software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceResponse;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.TagResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.TagResourceResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsResponse;
import software.amazon.awssdk.services.dynamodb.model.UntagResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.UntagResourceResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveResponse;
import software.amazon.dynamodb.services.exceptions.AWSExceptionFactory;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.exceptions.DynamoDBLocalServiceException;
import software.amazon.dynamodb.services.local.server.DynamoDBRequestHandler;
import software.amazon.dynamodb.services.local.shared.access.AmazonDynamoDBLocal;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.LocalDBClient;
import software.amazon.dynamodb.services.local.shared.access.sqlite.SQLiteDBAccess;
import software.amazon.dynamodb.services.local.shared.jobs.JobsRegister;
import software.amazon.dynamodb.services.local.shared.logging.LogManager;

public class LocalDynamoDBRequestHandler
extends DynamoDBRequestHandler {
    public static final String DB_FILE_EXTENSION = ".db";
    private static final String SHARED_DB_NAME = "shared-local-instance";
    static Logger logger = LogManager.getLogger(LocalDynamoDBRequestHandler.class);
    private final Map<String, AmazonDynamoDBLocal> dbRequestHandlers;
    private final boolean runInMemory;
    private final String dbFileLocation;
    private final boolean sharedDb;
    private final boolean delayTransientStatuses;
    private final boolean isTestControlEnabled;

    public LocalDynamoDBRequestHandler(int authorityLevel, boolean runInMemory, String dbFileLocation, boolean sharedDb, boolean delayTransientStatuses) throws DynamoDBLocalServiceException {
        this(authorityLevel, runInMemory, dbFileLocation, sharedDb, delayTransientStatuses, false);
    }

    LocalDynamoDBRequestHandler(int authorityLevel, boolean runInMemory, String dbFileLocation, boolean sharedDb, boolean delayTransientStatuses, boolean testControlEnabled) throws DynamoDBLocalServiceException {
        super(authorityLevel);
        this.dbFileLocation = dbFileLocation;
        this.runInMemory = runInMemory;
        this.sharedDb = sharedDb;
        this.delayTransientStatuses = delayTransientStatuses;
        this.isTestControlEnabled = testControlEnabled;
        if (runInMemory && dbFileLocation != null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.INTERNAL_FAILURE, "both inMemory and dbFileLocation set");
        }
        this.dbRequestHandlers = new ConcurrentHashMap<String, AmazonDynamoDBLocal>();
    }

    @Deprecated
    public LocalDynamoDBRequestHandler(int authorityLevel, boolean runInMemory, String dbFileLocation, boolean sharedDb) throws DynamoDBLocalServiceException {
        this(authorityLevel, runInMemory, dbFileLocation, sharedDb, false, false);
    }

    public static String generateDbFileRelativePath(String dbFileLocation, String dbName) {
        StringBuilder sb = new StringBuilder();
        return (dbFileLocation != null ? sb.append(dbFileLocation).append(File.separator) : sb).append(dbName).append(DB_FILE_EXTENSION).toString();
    }

    private static LocalDBAccess getDBAccess(String dbName, String dbFileLocation, boolean runInMemory) {
        if (runInMemory) {
            return new SQLiteDBAccess();
        }
        if (dbFileLocation != null) {
            return new SQLiteDBAccess(dbFileLocation + File.separator + dbName + DB_FILE_EXTENSION);
        }
        return new SQLiteDBAccess(dbName + DB_FILE_EXTENSION);
    }

    private synchronized AmazonDynamoDBLocal getHandler(String credentials) {
        String dbName;
        String string = dbName = this.sharedDb ? SHARED_DB_NAME : credentials;
        if (!this.dbRequestHandlers.containsKey(dbName)) {
            JobsRegister jobs = new JobsRegister(Executors.newFixedThreadPool(10), this.delayTransientStatuses);
            LocalDBClient client = new LocalDBClient(LocalDynamoDBRequestHandler.getDBAccess(dbName, this.dbFileLocation, this.runInMemory), jobs);
            this.dbRequestHandlers.put(dbName, client);
        }
        return this.dbRequestHandlers.get(dbName);
    }

    @Override
    public void shutdown() {
        for (AmazonDynamoDBLocal client : this.dbRequestHandlers.values()) {
            client.shutdown();
        }
    }

    @Override
    public CreateTableResponse createTable(String accessKey, String region, CreateTableRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbClient().createTable(req);
    }

    @Override
    public DeleteTableResponse deleteTable(String accessKey, String region, DeleteTableRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbClient().deleteTable(req);
    }

    @Override
    public DescribeTableResponse describeTable(String accessKey, String region, DescribeTableRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbClient().describeTable(req);
    }

    @Override
    public DescribeLimitsResponse describeLimits(String accessKey, String region, DescribeLimitsRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbClient().describeLimits(req);
    }

    @Override
    public ListTablesResponse listTables(String accessKey, String region, ListTablesRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbClient().listTables(req);
    }

    @Override
    public UpdateTableResponse updateTable(String accessKey, String region, UpdateTableRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbClient().updateTable(req);
    }

    @Override
    public BatchGetItemResponse batchGetItem(String accessKey, String region, BatchGetItemRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbClient().batchGetItem(req);
    }

    @Override
    public BatchWriteItemResponse batchWriteItem(String accessKey, String region, BatchWriteItemRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbClient().batchWriteItem(req);
    }

    @Override
    public DeleteItemResponse deleteItem(String accessKey, String region, DeleteItemRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbClient().deleteItem(req);
    }

    @Override
    public GetItemResponse getItem(String accessKey, String region, GetItemRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbClient().getItem(req);
    }

    @Override
    public PutItemResponse putItem(String accessKey, String region, PutItemRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbClient().putItem(req);
    }

    @Override
    public QueryResponse query(String accessKey, String region, QueryRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbClient().query(req);
    }

    @Override
    public ScanResponse scan(String accessKey, String region, ScanRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbClient().scan(req);
    }

    @Override
    public TransactGetItemsResponse transactGetItems(String accessKey, String region, TransactGetItemsRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbClient().transactGetItems(req);
    }

    @Override
    public TransactWriteItemsResponse transactWriteItems(String accessKey, String region, TransactWriteItemsRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbClient().transactWriteItems(req);
    }

    @Override
    public UpdateItemResponse updateItem(String accessKey, String region, UpdateItemRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbClient().updateItem(req);
    }

    @Override
    public ListStreamsResponse listStreams(String accessKey, String region, ListStreamsRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbStreamsClient().listStreams(req);
    }

    @Override
    public DescribeStreamResponse describeStream(String accessKey, String region, DescribeStreamRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbStreamsClient().describeStream(req);
    }

    @Override
    public DescribeTimeToLiveResponse describeTimeToLive(String accessKey, String region, DescribeTimeToLiveRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbClient().describeTimeToLive(req);
    }

    @Override
    public GetShardIteratorResponse getShardIterator(String accessKey, String region, GetShardIteratorRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbStreamsClient().getShardIterator(req);
    }

    @Override
    public GetRecordsResponse getRecords(String accessKey, String region, GetRecordsRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbStreamsClient().getRecords(req);
    }

    @Override
    public ListTagsOfResourceResponse listTagsOfResource(String accessKey, String region, ListTagsOfResourceRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbClient().listTagsOfResource(req);
    }

    @Override
    public TagResourceResponse tagResource(String accessKey, String region, TagResourceRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbClient().tagResource(req);
    }

    @Override
    public UntagResourceResponse untagResource(String accessKey, String region, UntagResourceRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbClient().untagResource(req);
    }

    @Override
    public UpdateTimeToLiveResponse updateTimeToLive(String accessKey, String region, UpdateTimeToLiveRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbClient().updateTimeToLive(req);
    }

    @Override
    public ExecuteStatementResponse executeStatement(String accessKey, String region, ExecuteStatementRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbClient().executeStatement(req);
    }

    @Override
    public BatchExecuteStatementResponse batchExecuteStatement(String accessKey, String region, BatchExecuteStatementRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbClient().batchExecuteStatement(req);
    }

    @Override
    public ExecuteTransactionResponse executeTransaction(String accessKey, String region, ExecuteTransactionRequest req) {
        return this.getHandler(this.getCredentialsString(accessKey, region)).dynamoDbClient().executeTransaction(req);
    }

    private String getCredentialsString(String accessKey, String region) {
        return accessKey + "_" + region;
    }
}

