/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.common.utilities;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.AbstractConverter;
import org.apache.commons.beanutils.converters.ArrayConverter;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.beanutils.converters.DateTimeConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.NumberConverter;
import org.apache.commons.beanutils.converters.ShortConverter;
import org.apache.commons.beanutils.converters.SqlTimestampConverter;
import org.apache.commons.beanutils.converters.StringConverter;
import org.bson.BsonRegularExpression;
import org.bson.BsonTimestamp;
import org.bson.types.Binary;
import org.bson.types.Decimal128;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.common.utilities.SqlError;
import software.amazon.documentdb.jdbc.common.utilities.SqlState;

public class TypeConverters {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeConverters.class);
    private static final ImmutableMap<Class<?>, AbstractConverter> TYPE_CONVERTERS_MAP = ImmutableMap.builder().put(Decimal128.class, (Object)new Decimal128Converter(new Decimal128(0L))).put(BigDecimal.class, (Object)new BigDecimalConverter((Object)0)).put(Boolean.class, (Object)new BooleanConverter((Object)false)).put(Boolean.TYPE, (Object)new BooleanConverter((Object)false)).put(BsonTimestamp.class, (Object)new BsonTimestampConverter()).put(BsonRegularExpression.class, (Object)new StringConverter()).put(Byte.class, (Object)new ByteConverter((Object)0)).put(Byte.TYPE, (Object)new ByteConverter((Object)0)).put(java.util.Date.class, (Object)new DateConverter(null)).put(Date.class, (Object)new DateConverter(null)).put(Double.class, (Object)new DoubleConverter((Object)0.0)).put(Double.TYPE, (Object)new DoubleConverter((Object)0.0)).put(Float.class, (Object)new FloatConverter((Object)0.0)).put(Float.TYPE, (Object)new FloatConverter((Object)0.0)).put(Integer.class, (Object)new IntegerConverter((Object)0)).put(Integer.TYPE, (Object)new IntegerConverter((Object)0)).put(Long.class, (Object)new LongConverter((Object)0)).put(Long.TYPE, (Object)new LongConverter((Object)0)).put(MaxKey.class, (Object)new StringConverter()).put(MinKey.class, (Object)new StringConverter()).put(ObjectId.class, (Object)new StringConverter()).put(Short.class, (Object)new ShortConverter((Object)0)).put(Short.TYPE, (Object)new ShortConverter((Object)0)).put(String.class, (Object)new StringConverter()).put(Timestamp.class, (Object)new SqlTimestampConverter()).put(Byte[].class, (Object)new ArrayConverter(Byte[].class, (Converter)new ByteConverter(), -1)).put(byte[].class, (Object)new ArrayConverter(byte[].class, (Converter)new ByteConverter(), -1)).put(Binary.class, (Object)new BsonBinaryConverter(byte[].class, (Converter)new ByteConverter())).build();

    public static AbstractConverter get(Class<? extends Object> sourceType, Class<? extends Object> targetType) throws SQLException {
        AbstractConverter converter = (AbstractConverter)TYPE_CONVERTERS_MAP.get(sourceType);
        if (converter == null) {
            throw SqlError.createSQLException(LOGGER, SqlState.DATA_EXCEPTION, SqlError.UNSUPPORTED_CONVERSION, sourceType.getSimpleName(), targetType.getSimpleName());
        }
        return converter;
    }

    private static class BsonBinaryConverter
    extends ArrayConverter {
        public BsonBinaryConverter(Class<?> defaultType, Converter elementConverter) {
            super(defaultType, elementConverter);
        }

        public BsonBinaryConverter(Class<?> defaultType, Converter elementConverter, int defaultSize) {
            super(defaultType, elementConverter, defaultSize);
        }

        public <T> T convertToType(Class<T> type, Object value) {
            Class<Object> targetType;
            Class<Object> clazz = targetType = type == null ? this.getDefaultType() : type;
            if (value instanceof Binary) {
                if (targetType.isAssignableFrom(String.class)) {
                    return (T)this.convertToString(value);
                }
                return (T)super.convertToType(targetType, (Object)((Binary)value).getData());
            }
            return (T)super.convertToType(targetType, value);
        }

        protected String convertToString(Object value) throws Throwable {
            if (value instanceof Binary) {
                return BaseEncoding.base16().encode(((Binary)value).getData());
            }
            return super.convertToString(value);
        }

        protected Class<?> getDefaultType() {
            return byte[].class;
        }
    }

    private static class BsonTimestampConverter
    extends DateTimeConverter {
        public BsonTimestampConverter() {
        }

        public BsonTimestampConverter(Object defaultValue) {
            super(defaultValue);
        }

        protected <T> T convertToType(Class<T> targetType, Object value) throws Exception {
            if (value instanceof BsonTimestamp) {
                long timeInMillisSinceEpoch = BsonTimestampConverter.getTimeInMillisSinceEpoch((BsonTimestamp)value);
                return (T)super.convertToType(targetType, (Object)timeInMillisSinceEpoch);
            }
            return (T)super.convertToType(targetType, value);
        }

        protected String convertToString(Object value) throws Throwable {
            if (value instanceof BsonTimestamp) {
                long timeInMillisSinceEpoch = BsonTimestampConverter.getTimeInMillisSinceEpoch((BsonTimestamp)value);
                return super.convertToString(super.convertToType(this.getDefaultType(), (Object)timeInMillisSinceEpoch));
            }
            return super.convertToString(value);
        }

        private static long getTimeInMillisSinceEpoch(BsonTimestamp value) {
            int timeInSecsSinceEpoch = value.getTime();
            return TimeUnit.SECONDS.toMillis(timeInSecsSinceEpoch);
        }

        protected Class<?> getDefaultType() {
            return Timestamp.class;
        }
    }

    private static class Decimal128Converter
    extends NumberConverter {
        public Decimal128Converter() {
            super(true);
        }

        public Decimal128Converter(Object defaultValue) {
            super(true, defaultValue);
        }

        protected <T> T convertToType(Class<T> targetType, Object value) throws Throwable {
            if (value instanceof Decimal128) {
                if (targetType.isAssignableFrom(BigDecimal.class)) {
                    return targetType.cast(((Decimal128)value).bigDecimalValue());
                }
                return (T)super.convertToType(targetType, (Object)((Decimal128)value).doubleValue());
            }
            return (T)super.convertToType(targetType, value);
        }

        protected String convertToString(Object value) throws Throwable {
            if (value instanceof Decimal128) {
                return ((Decimal128)value).toString();
            }
            return super.convertToString(value);
        }

        protected Class<?> getDefaultType() {
            return String.class;
        }
    }
}

