/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc;

import com.google.common.collect.ImmutableList;
import com.mongodb.client.MongoCursor;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.DocumentDbAbstractResultSet;
import software.amazon.documentdb.jdbc.common.utilities.JdbcColumnMetaData;
import software.amazon.documentdb.jdbc.common.utilities.SqlError;
import software.amazon.documentdb.jdbc.common.utilities.SqlState;

public class DocumentDbResultSet
extends DocumentDbAbstractResultSet
implements ResultSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentDbResultSet.class);
    private static final int DEFAULT_FETCH_SIZE = 10;
    private int fetchSize;
    private int rowIndex = -1;
    private final MongoCursor<Document> iterator;
    private Document current;
    private final List<String> paths;

    DocumentDbResultSet(Statement statement, MongoCursor<Document> iterator, ImmutableList<JdbcColumnMetaData> columnMetaData, List<String> paths) throws SQLException {
        super(statement, columnMetaData, true);
        this.iterator = iterator;
        this.fetchSize = statement != null ? statement.getFetchSize() : 10;
        this.paths = paths;
    }

    @Override
    protected void doClose() {
        this.iterator.close();
    }

    @Override
    protected int getDriverFetchSize() {
        return this.fetchSize;
    }

    @Override
    protected void setDriverFetchSize(int rows) {
        this.fetchSize = rows;
    }

    @Override
    protected int getRowIndex() {
        return this.rowIndex;
    }

    @Override
    protected int getRowCount() throws SQLFeatureNotSupportedException {
        throw SqlError.createSQLFeatureNotSupportedException(LOGGER, SqlError.RESULT_FORWARD_ONLY, new Object[0]);
    }

    @Override
    public boolean isLast() throws SQLException {
        this.verifyOpen();
        return this.current != null && !this.iterator.hasNext();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.verifyOpen();
        return this.current == null && !this.iterator.hasNext();
    }

    @Override
    public boolean next() throws SQLException {
        this.verifyOpen();
        if (this.iterator.hasNext()) {
            this.current = (Document)this.iterator.next();
            ++this.rowIndex;
            return true;
        }
        this.current = null;
        return false;
    }

    @Override
    protected Object getValue(int columnIndex) throws SQLException {
        ResultSetMetaData metadata = this.getMetaData();
        String path = this.paths.get(columnIndex - 1);
        if (path == null || path.isEmpty()) {
            throw SqlError.createSQLException(LOGGER, SqlState.DATA_EXCEPTION, SqlError.CANNOT_RETRIEVE_COLUMN, metadata.getColumnName(columnIndex));
        }
        String[] segmentedPath = path.split("\\.");
        Object segmentValue = this.current.get((Object)segmentedPath[0]);
        for (int j = 1; j < segmentedPath.length && segmentValue instanceof Document; ++j) {
            segmentValue = ((Document)segmentValue).get((Object)segmentedPath[j]);
        }
        if (segmentValue instanceof Document) {
            return ((Document)segmentValue).toJson();
        }
        if (segmentValue instanceof List) {
            List modifiedList = ((List)segmentValue).stream().map(o1 -> o1 instanceof Document ? ((Document)o1).toJson() : o1).collect(Collectors.toList());
            return modifiedList.toString();
        }
        return segmentValue;
    }
}

