/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.MongoCollection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.DocumentDbConnectionProperties;
import software.amazon.documentdb.jdbc.DocumentDbMetadataScanMethod;
import software.amazon.documentdb.jdbc.common.utilities.SqlError;
import software.amazon.documentdb.jdbc.common.utilities.SqlState;

public class DocumentDbMetadataScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentDbMetadataScanner.class);
    private static final String ID = "_id";
    private static final BsonInt32 FORWARD = new BsonInt32(1);
    private static final BsonInt32 REVERSE = new BsonInt32(-1);
    private static final String RANDOM = "$sample";

    @VisibleForTesting
    public static Iterator<BsonDocument> getIterator(DocumentDbConnectionProperties properties, MongoCollection<BsonDocument> collection) throws SQLException {
        int scanLimit = properties.getMetadataScanLimit();
        DocumentDbMetadataScanMethod method = properties.getMetadataScanMethod();
        switch (method) {
            case ALL: {
                return collection.find().cursor();
            }
            case ID_FORWARD: {
                return collection.find().sort((Bson)new BsonDocument(ID, (BsonValue)FORWARD)).limit(scanLimit).cursor();
            }
            case ID_REVERSE: {
                return collection.find().sort((Bson)new BsonDocument(ID, (BsonValue)REVERSE)).limit(scanLimit).cursor();
            }
            case RANDOM: {
                ArrayList<BsonDocument> aggregations = new ArrayList<BsonDocument>();
                aggregations.add(new BsonDocument(RANDOM, (BsonValue)new BsonDocument("size", (BsonValue)new BsonInt32(scanLimit))));
                return collection.aggregate(aggregations).cursor();
            }
        }
        throw SqlError.createSQLException(LOGGER, SqlState.CONNECTION_FAILURE, SqlError.UNSUPPORTED_PROPERTY, method.getName());
    }
}

