/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.calcite.adapter;

import com.google.common.collect.ImmutableList;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.UnwindOptions;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.enumerable.EnumerableRules;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.type.RelDataType;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbJoin;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbRel;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbRules;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbTable;
import software.amazon.documentdb.jdbc.calcite.adapter.DocumentDbToEnumerableConverterRule;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaColumn;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaTable;

public class DocumentDbTableScan
extends TableScan
implements DocumentDbRel {
    private final DocumentDbTable mongoTable;
    private final RelDataType projectRowType;
    private final DocumentDbSchemaTable metadataTable;

    protected DocumentDbTableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, DocumentDbTable mongoTable, RelDataType projectRowType, DocumentDbSchemaTable metadataTable) {
        super(cluster, traitSet, (List)ImmutableList.of(), table);
        this.mongoTable = mongoTable;
        this.projectRowType = projectRowType;
        this.metadataTable = metadataTable;
        assert (mongoTable != null);
        assert (this.getConvention() == CONVENTION);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return this;
    }

    public RelDataType deriveRowType() {
        return this.projectRowType != null ? this.projectRowType : super.deriveRowType();
    }

    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        float f = this.projectRowType == null ? 1.0f : (float)this.projectRowType.getFieldCount() / 100.0f;
        RelOptCost relOptCost = super.computeSelfCost(planner, mq);
        return relOptCost != null ? relOptCost.multiplyBy(0.1 * (double)f) : null;
    }

    public void register(RelOptPlanner planner) {
        planner.addRule((RelOptRule)DocumentDbToEnumerableConverterRule.INSTANCE);
        for (RelOptRule rule : DocumentDbRules.RULES) {
            planner.addRule(rule);
        }
        planner.removeRule((RelOptRule)CoreRules.PROJECT_REMOVE);
        planner.removeRule((RelOptRule)CoreRules.SORT_JOIN_TRANSPOSE);
        planner.removeRule((RelOptRule)EnumerableRules.ENUMERABLE_AGGREGATE_RULE);
        planner.removeRule((RelOptRule)EnumerableRules.ENUMERABLE_PROJECT_RULE);
        planner.removeRule(EnumerableRules.ENUMERABLE_JOIN_RULE);
        planner.removeRule((RelOptRule)EnumerableRules.ENUMERABLE_LIMIT_RULE);
        planner.removeRule((RelOptRule)EnumerableRules.ENUMERABLE_SORT_RULE);
        planner.removeRule((RelOptRule)EnumerableRules.ENUMERABLE_FILTER_RULE);
    }

    @Override
    public void implement(DocumentDbRel.Implementor implementor) {
        implementor.setTable(this.table);
        implementor.setDocumentDbTable(this.mongoTable);
        implementor.setMetadataTable(this.metadataTable);
        for (Map.Entry column : this.metadataTable.getColumnMap().entrySet()) {
            if (!((DocumentDbSchemaColumn)column.getValue()).isIndex()) continue;
            String indexName = (String)column.getKey();
            UnwindOptions opts = new UnwindOptions();
            String arrayPath = ((DocumentDbSchemaColumn)column.getValue()).getFieldPath();
            arrayPath = "$" + arrayPath;
            opts.includeArrayIndex(indexName);
            opts.preserveNullAndEmptyArrays(Boolean.valueOf(true));
            implementor.addUnwind(String.valueOf(Aggregates.unwind((String)arrayPath, (UnwindOptions)opts)));
        }
        String matchFilter = DocumentDbJoin.buildFieldsExistMatchFilter(DocumentDbJoin.getFilterColumns(this.metadataTable));
        if (matchFilter != null && DocumentDbJoin.isTableVirtual(this.metadataTable)) {
            implementor.setVirtualTableFilter(matchFilter);
        }
    }
}

