/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import org.apache.commons.beanutils.ConversionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.DocumentDbResultSetMetaData;
import software.amazon.documentdb.jdbc.common.ResultSet;
import software.amazon.documentdb.jdbc.common.utilities.JdbcColumnMetaData;
import software.amazon.documentdb.jdbc.common.utilities.SqlError;
import software.amazon.documentdb.jdbc.common.utilities.SqlState;
import software.amazon.documentdb.jdbc.common.utilities.TypeConverters;

public abstract class DocumentDbAbstractResultSet
extends ResultSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentDbAbstractResultSet.class);
    private final ImmutableList<JdbcColumnMetaData> columnMetaData;
    private final Map<String, Integer> columnToIndexMap;
    private final int columnCount;
    private boolean wasNull = false;
    private ResultSetMetaData resultSetMetaData = null;
    private final boolean caseSensitive;

    DocumentDbAbstractResultSet(Statement statement, ImmutableList<JdbcColumnMetaData> columnMetaData) {
        this(statement, columnMetaData, false);
    }

    DocumentDbAbstractResultSet(Statement statement, ImmutableList<JdbcColumnMetaData> columnMetaData, boolean caseSensitive) {
        super(statement);
        this.columnMetaData = columnMetaData;
        this.columnCount = columnMetaData.size();
        this.caseSensitive = caseSensitive;
        this.columnToIndexMap = this.buildColumnIndices(columnMetaData);
    }

    private Map<String, Integer> buildColumnIndices(ImmutableList<JdbcColumnMetaData> columnMetaData) {
        HashMap<String, Integer> columnIndices = this.caseSensitive ? new HashMap() : new TreeMap(String.CASE_INSENSITIVE_ORDER);
        for (JdbcColumnMetaData column : columnMetaData) {
            columnIndices.put(column.getColumnLabel(), column.getOrdinal() + 1);
        }
        return columnIndices;
    }

    protected void verifyRow() throws SQLException {
        if (this.isBeforeFirst()) {
            throw SqlError.createSQLException(LOGGER, SqlState.DATA_EXCEPTION, SqlError.BEFORE_FIRST, new Object[0]);
        }
        if (this.isAfterLast()) {
            throw SqlError.createSQLException(LOGGER, SqlState.DATA_EXCEPTION, SqlError.AFTER_LAST, new Object[0]);
        }
    }

    protected void verifyColumnIndex(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.columnCount) {
            throw SqlError.createSQLException(LOGGER, SqlState.DATA_EXCEPTION, SqlError.INVALID_INDEX, columnIndex, this.columnCount);
        }
    }

    protected void verifyState(int columnIndex) throws SQLException {
        this.verifyOpen();
        this.verifyRow();
        this.verifyColumnIndex(columnIndex);
    }

    private <T> T getValue(int columnIndex, Class<T> targetType) throws SQLException {
        this.verifyState(columnIndex);
        Object o = this.getValue(columnIndex);
        this.wasNull = o == null;
        Class<Object> sourceType = this.wasNull ? targetType : o.getClass();
        try {
            return (T)TypeConverters.get(sourceType, targetType).convert(targetType, o);
        }
        catch (ConversionException e) {
            throw SqlError.createSQLException(LOGGER, SqlState.DATA_EXCEPTION, (Exception)((Object)e), SqlError.UNSUPPORTED_CONVERSION, sourceType.getSimpleName(), targetType.getSimpleName());
        }
    }

    protected abstract Object getValue(int var1) throws SQLException;

    @Override
    public boolean wasNull() throws SQLException {
        this.verifyOpen();
        return this.wasNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.getValue(columnIndex, String.class);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.getValue(columnIndex, Boolean.TYPE);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.getValue(columnIndex, Byte.TYPE);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.getValue(columnIndex, Short.TYPE);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.getValue(columnIndex, Integer.TYPE);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.getValue(columnIndex, Long.TYPE);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.getValue(columnIndex, Float.TYPE).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.getValue(columnIndex, Double.TYPE);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.getValue(columnIndex, byte[].class);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, null);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, null);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, null);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        String value = this.getString(columnIndex);
        if (value == null) {
            return null;
        }
        return new ByteArrayInputStream(value.getBytes(StandardCharsets.US_ASCII));
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        byte[] value = this.getValue(columnIndex, byte[].class);
        if (value == null) {
            return null;
        }
        return new ByteArrayInputStream(value);
    }

    @Override
    public ResultSetMetaData getMetaData() {
        if (this.resultSetMetaData == null) {
            return new DocumentDbResultSetMetaData(this.columnMetaData);
        }
        return this.resultSetMetaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.verifyState(columnIndex);
        Object o = this.getValue(columnIndex);
        this.wasNull = o == null;
        return o;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        Integer columnIndex = this.columnToIndexMap.get(columnLabel);
        if (columnIndex == null) {
            throw SqlError.createSQLException(LOGGER, SqlState.DATA_EXCEPTION, SqlError.INVALID_COLUMN_LABEL, columnLabel);
        }
        return columnIndex;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        String value = this.getValue(columnIndex, String.class);
        if (value == null) {
            return null;
        }
        return new StringReader(value);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getValue(columnIndex, BigDecimal.class);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date value = this.getValue(columnIndex, Date.class);
        if (value == null) {
            return null;
        }
        return this.getMaybeAdjustedTime(value, cal);
    }

    private Date getMaybeAdjustedTime(Date utcTime, Calendar cal) {
        if (cal != null) {
            long adjustedTime = utcTime.getTime();
            adjustedTime -= (long)cal.getTimeZone().getOffset(adjustedTime);
            return new Date(adjustedTime);
        }
        return utcTime;
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Date value = this.getDate(columnIndex, cal);
        if (value == null) {
            return null;
        }
        return new Time(value.getTime());
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Date value = this.getDate(columnIndex, cal);
        if (value == null) {
            return null;
        }
        return new Timestamp(value.getTime());
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return this.getValue(columnIndex, type);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        byte[] bytes = this.getBytes(columnIndex);
        if (bytes == null) {
            return null;
        }
        return new SerialBlob(bytes);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        String value = this.getString(columnIndex);
        if (value == null) {
            return null;
        }
        return new SerialClob(value.toCharArray());
    }
}

