/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.bson.codecs.pojo.annotations.BsonCreator;
import org.bson.codecs.pojo.annotations.BsonId;
import org.bson.codecs.pojo.annotations.BsonIgnore;
import org.bson.codecs.pojo.annotations.BsonProperty;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaColumn;

@JsonSerialize(as=DocumentDbSchemaTable.class)
public class DocumentDbSchemaTable {
    public static final String UUID_PROPERTY = "uuid";
    public static final String COLLECTION_NAME_PROPERTY = "collectionName";
    public static final String COLUMNS_PROPERTY = "columns";
    public static final int UNKNOWN_RECORD_COUNT = -1;
    private String uuid;
    @NonNull
    private String sqlName;
    @NonNull
    private final String collectionName;
    private final Date modifyDate;
    @BsonIgnore
    @JsonIgnore
    @NonNull
    private final ImmutableMap<String, DocumentDbSchemaColumn> columnMap;
    @JsonProperty(value="columns")
    @BsonProperty(value="columns")
    private final List<DocumentDbSchemaColumn> columns;
    @BsonIgnore
    @JsonIgnore
    private long estimatedRecordCount = -1L;

    @BsonId
    @JsonProperty(value="_id")
    public String getId() {
        return DocumentDbSchemaTable.getSchemaId(this.sqlName, this.uuid);
    }

    private static String getSchemaId(String sqlName, String uuid) {
        return sqlName + "::" + uuid;
    }

    @BsonCreator
    @JsonCreator
    public DocumentDbSchemaTable(@JsonProperty(value="_id") @BsonId String id, @JsonProperty(value="uuid") @BsonProperty(value="uuid") String uuid, @JsonProperty(value="modifyDate") @BsonProperty(value="modifyDate") Date modifyDate, @JsonProperty(value="sqlName") @BsonProperty(value="sqlName") String sqlName, @JsonProperty(value="collectionName") @BsonProperty(value="collectionName") String collectionName, @JsonProperty(value="columns") @BsonProperty(value="columns") List<DocumentDbSchemaColumn> columns) {
        this.uuid = !Strings.isNullOrEmpty((String)uuid) ? uuid : UUID.randomUUID().toString();
        this.modifyDate = new Date(modifyDate.getTime());
        this.sqlName = sqlName;
        this.collectionName = collectionName;
        this.columns = columns;
        LinkedHashMap map = columns.stream().collect(Collectors.toMap(DocumentDbSchemaColumn::getSqlName, documentDbSchemaColumn -> documentDbSchemaColumn, (original, duplicate) -> original, LinkedHashMap::new));
        this.columnMap = ImmutableMap.copyOf((Map)map);
    }

    public DocumentDbSchemaTable(String sqlName, String collectionName, Map<String, DocumentDbSchemaColumn> columnMap) {
        this.uuid = UUID.randomUUID().toString();
        this.modifyDate = new Date(Instant.now().toEpochMilli());
        this.sqlName = sqlName;
        this.collectionName = collectionName;
        this.columns = new ArrayList<DocumentDbSchemaColumn>(columnMap.values());
        this.columnMap = ImmutableMap.copyOf(columnMap);
    }

    public Date getModifyDate() {
        return new Date(this.modifyDate.getTime());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentDbSchemaTable)) {
            return false;
        }
        DocumentDbSchemaTable that = (DocumentDbSchemaTable)o;
        return Objects.equals(this.uuid, that.uuid) && this.sqlName.equals(that.sqlName) && this.collectionName.equals(that.collectionName) && Objects.equals(this.modifyDate, that.modifyDate) && this.columnMap.equals(that.columnMap) && Objects.equals(this.columns, that.columns);
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.sqlName, this.collectionName, this.modifyDate, this.columnMap, this.columns);
    }

    public String getUuid() {
        return this.uuid;
    }

    @NonNull
    public String getSqlName() {
        return this.sqlName;
    }

    @NonNull
    public String getCollectionName() {
        return this.collectionName;
    }

    @NonNull
    public ImmutableMap<String, DocumentDbSchemaColumn> getColumnMap() {
        return this.columnMap;
    }

    public List<DocumentDbSchemaColumn> getColumns() {
        return this.columns;
    }

    public long getEstimatedRecordCount() {
        return this.estimatedRecordCount;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setSqlName(@NonNull String sqlName) {
        if (sqlName == null) {
            throw new NullPointerException("sqlName is marked non-null but is null");
        }
        this.sqlName = sqlName;
    }

    @JsonIgnore
    public void setEstimatedRecordCount(long estimatedRecordCount) {
        this.estimatedRecordCount = estimatedRecordCount;
    }
}

