/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.time.Instant;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.bson.codecs.pojo.annotations.BsonCreator;
import org.bson.codecs.pojo.annotations.BsonIgnore;
import org.bson.codecs.pojo.annotations.BsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.common.utilities.LazyLinkedHashMap;
import software.amazon.documentdb.jdbc.common.utilities.SqlError;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaException;
import software.amazon.documentdb.jdbc.metadata.DocumentDbSchemaTable;

@JsonSerialize(as=DocumentDbSchema.class)
public class DocumentDbSchema {
    public static final String SCHEMA_NAME_PROPERTY = "schemaName";
    public static final String SCHEMA_VERSION_PROPERTY = "schemaVersion";
    public static final String SQL_NAME_PROPERTY = "sqlName";
    public static final String ID_PROPERTY = "_id";
    public static final String MODIFY_DATE_PROPERTY = "modifyDate";
    public static final String TABLES_PROPERTY = "tables";
    public static final String SCHEMA_TABLE_ID_SEPARATOR = "::";
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentDbSchema.class);
    private static final ObjectMapper JSON_OBJECT_MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().serializationInclusion(JsonInclude.Include.NON_NULL)).serializationInclusion(JsonInclude.Include.NON_EMPTY)).enable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT})).build();
    private static final String EMPTY_STRING = "";
    public static final String DEFAULT_SCHEMA_NAME = "_default";
    @BsonProperty(value="schemaName")
    @NonNull
    private String schemaName;
    @BsonProperty(value="schemaVersion")
    private int schemaVersion;
    @BsonProperty(value="sqlName")
    @NonNull
    private final String sqlName;
    @BsonProperty(value="modifyDate")
    @NonNull
    private final Date modifyDate;
    @BsonIgnore
    @JsonIgnore
    private Map<String, DocumentDbSchemaTable> tables;
    @BsonProperty(value="tables")
    @JsonProperty(value="tables")
    private final Set<String> tableReferences;

    @BsonIgnore
    @JsonIgnore
    public Map<String, DocumentDbSchemaTable> getTableMap() {
        return this.tables;
    }

    @BsonIgnore
    @JsonIgnore
    public void setGetTableFunction(@NonNull Function<String, DocumentDbSchemaTable> getTableFunction, @NonNull Function<Set<String>, Map<String, DocumentDbSchemaTable>> getRemainingTablesFunction) throws IllegalStateException {
        if (getTableFunction == null) {
            throw new NullPointerException("getTableFunction is marked non-null but is null");
        }
        if (getRemainingTablesFunction == null) {
            throw new NullPointerException("getRemainingTablesFunction is marked non-null but is null");
        }
        if (this.tables != null || this.tableReferences == null) {
            throw new IllegalStateException(SqlError.lookup(SqlError.INVALID_STATE_SET_TABLE_FUNCTION, new Object[0]));
        }
        Map tableIdByTableName = this.tableReferences.stream().collect(Collectors.toMap(DocumentDbSchema::parseSqlTableName, tableId -> tableId, (a, b) -> b, LinkedHashMap::new));
        this.tables = new LazyLinkedHashMap<String, DocumentDbSchemaTable>(new LinkedHashSet(tableIdByTableName.keySet()), tableName -> (DocumentDbSchemaTable)getTableFunction.apply((String)tableIdByTableName.get(tableName)), remainingTableNames -> (Map)getRemainingTablesFunction.apply(tableIdByTableName.keySet().stream().filter(remainingTableNames::contains).map(tableIdByTableName::get).collect(Collectors.toCollection(LinkedHashSet::new))));
    }

    public static String parseSqlTableName(String tableId) {
        return DocumentDbSchema.parseTableNameAndUuid(tableId)[0];
    }

    private static String[] parseTableNameAndUuid(String tableId) {
        String[] tableNameAndUuid = tableId.split("[:][:]");
        if (tableNameAndUuid.length != 2) {
            throw new DocumentDbSchemaException(SqlError.lookup(SqlError.INVALID_FORMAT, tableId, "<tableName>::<tableId>"));
        }
        return tableNameAndUuid;
    }

    public DocumentDbSchema(String sqlName, int schemaVersion, Map<String, DocumentDbSchemaTable> tables) {
        this(DEFAULT_SCHEMA_NAME, sqlName, schemaVersion, tables);
    }

    public DocumentDbSchema(String schemaName, String sqlName, int schemaVersion, Map<String, DocumentDbSchemaTable> tables) {
        this.schemaName = schemaName;
        this.sqlName = sqlName;
        this.schemaVersion = schemaVersion;
        this.modifyDate = new Date(Instant.now().toEpochMilli());
        this.tableReferences = tables.values().stream().map(DocumentDbSchemaTable::getId).collect(Collectors.toSet());
        this.tables = tables;
    }

    @BsonCreator
    @JsonCreator
    public DocumentDbSchema(@JsonProperty(value="schemaName") @BsonProperty(value="schemaName") String schemaName, @JsonProperty(value="schemaVersion") @BsonProperty(value="schemaVersion") int schemaVersion, @JsonProperty(value="sqlName") @BsonProperty(value="sqlName") String sqlName, @JsonProperty(value="modifyDate") @BsonProperty(value="modifyDate") Date modifyDate, @JsonProperty(value="tables") @BsonProperty(value="tables") Set<String> tableReferences) {
        this.schemaName = schemaName;
        this.sqlName = sqlName;
        this.schemaVersion = schemaVersion;
        this.modifyDate = new Date(modifyDate.getTime());
        this.tableReferences = tableReferences != null ? tableReferences : new LinkedHashSet();
    }

    public Date getModifyDate() {
        return new Date(this.modifyDate.getTime());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentDbSchema)) {
            return false;
        }
        DocumentDbSchema that = (DocumentDbSchema)o;
        return this.schemaVersion == that.schemaVersion && this.schemaName.equals(that.schemaName) && this.sqlName.equals(that.sqlName) && this.modifyDate.equals(that.modifyDate) && Objects.equals(this.tableReferences, that.tableReferences);
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.schemaVersion, this.sqlName, this.modifyDate, this.tableReferences);
    }

    public String toString() {
        try {
            return JSON_OBJECT_MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Error converting object to JSON.", (Throwable)e);
            return EMPTY_STRING;
        }
    }

    @NonNull
    public String getSchemaName() {
        return this.schemaName;
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @NonNull
    public String getSqlName() {
        return this.sqlName;
    }

    public Set<String> getTableReferences() {
        return this.tableReferences;
    }

    public void setSchemaName(@NonNull String schemaName) {
        if (schemaName == null) {
            throw new NullPointerException("schemaName is marked non-null but is null");
        }
        this.schemaName = schemaName;
    }

    public void setSchemaVersion(int schemaVersion) {
        this.schemaVersion = schemaVersion;
    }
}

