/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.DocumentDbConnection;
import software.amazon.documentdb.jdbc.DocumentDbConnectionProperties;
import software.amazon.documentdb.jdbc.DocumentDbQueryExecutor;
import software.amazon.documentdb.jdbc.common.Statement;
import software.amazon.documentdb.jdbc.query.DocumentDbQueryMappingService;

class DocumentDbStatement
extends Statement
implements java.sql.Statement {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentDbStatement.class);
    private int queryTimeout;
    private final DocumentDbQueryExecutor queryExecutor;

    DocumentDbStatement(DocumentDbConnection connection) throws SQLException {
        super(connection);
        DocumentDbStatement.setDefaultFetchSize(this, connection.getConnectionProperties());
        DocumentDbQueryMappingService mappingService = new DocumentDbQueryMappingService(connection.getConnectionProperties(), connection.getDatabaseMetadata());
        this.queryExecutor = new DocumentDbQueryExecutor(this, connection.getConnectionProperties(), mappingService, this.getQueryTimeout(), this.getFetchSize());
    }

    static void setDefaultFetchSize(java.sql.Statement statement, DocumentDbConnectionProperties properties) throws SQLException {
        Integer defaultFetchSize = properties.getDefaultFetchSize();
        if (defaultFetchSize == null) {
            defaultFetchSize = 2000;
        }
        if (defaultFetchSize != 2000) {
            LOGGER.debug("Setting custom default fetch size: {}", (Object)defaultFetchSize);
        }
        statement.setFetchSize(defaultFetchSize);
    }

    DocumentDbStatement(DocumentDbConnection connection, DocumentDbQueryExecutor queryExecutor) {
        super(connection);
        this.queryExecutor = queryExecutor;
    }

    @Override
    protected void cancelQuery(boolean isClosing) throws SQLException {
        this.queryExecutor.cancelQuery(isClosing);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.verifyOpen();
        this.queryExecutor.setFetchSize(this.getFetchSize());
        return this.queryExecutor.executeQuery(sql);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.verifyOpen();
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.verifyOpen();
        this.queryTimeout = seconds;
        this.queryExecutor.setQueryTimeout(seconds);
    }
}

