/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.common.utilities;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;

public class LazyLinkedHashMap<K, V>
implements Map<K, V> {
    private final ImmutableSet<K> keySet;
    private final Map<K, V> map;
    private final Function<K, V> factory;
    private final Function<Set<K>, Map<K, V>> allValuesFactory;

    public LazyLinkedHashMap(@NonNull Set<K> keySet, @NonNull Function<K, V> factory) {
        if (keySet == null) {
            throw new NullPointerException("keySet is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        this.keySet = ImmutableSet.copyOf(keySet);
        this.factory = factory;
        this.allValuesFactory = null;
        this.map = new LinkedHashMap();
    }

    public LazyLinkedHashMap(@NonNull Set<K> keySet, @NonNull Function<K, V> factory, @NonNull Function<Set<K>, Map<K, V>> remainingValuesFactory) {
        if (keySet == null) {
            throw new NullPointerException("keySet is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (remainingValuesFactory == null) {
            throw new NullPointerException("remainingValuesFactory is marked non-null but is null");
        }
        this.keySet = ImmutableSet.copyOf(keySet);
        this.factory = factory;
        this.allValuesFactory = remainingValuesFactory;
        this.map = new LinkedHashMap();
    }

    @Override
    public int size() {
        return this.keySet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keySet.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keySet.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V get(Object key) {
        if (!this.keySet.contains(key)) {
            return null;
        }
        if (!this.map.containsKey(key)) {
            this.map.put(key, this.factory.apply(key));
        }
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.keySet.size() != this.map.size() && this.allValuesFactory != null) {
            this.putAllRemaining();
            return this.map.values();
        }
        if (this.keySet.size() == this.map.size()) {
            return this.map.values();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.keySet.size() != this.map.size() && this.allValuesFactory != null) {
            this.putAllRemaining();
            return this.map.entrySet();
        }
        if (this.keySet.size() == this.map.size()) {
            return this.map.entrySet();
        }
        throw new UnsupportedOperationException();
    }

    @VisibleForTesting
    int getLazyMapSize() {
        return this.map.size();
    }

    private void putAllRemaining() {
        LinkedHashSet missingKeySet = this.keySet.stream().filter(key -> !this.map.containsKey(key)).collect(Collectors.toCollection(LinkedHashSet::new));
        this.map.putAll(this.allValuesFactory.apply(missingKeySet));
    }
}

