/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.documentdb.jdbc.common;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.documentdb.jdbc.common.utilities.SqlError;
import software.amazon.documentdb.jdbc.common.utilities.SqlState;
import software.amazon.documentdb.jdbc.common.utilities.Warning;

public abstract class Statement
implements java.sql.Statement {
    private static final Logger LOGGER = LoggerFactory.getLogger(Statement.class);
    private final Connection connection;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private int maxFieldSize = 0;
    private long largeMaxRows = 0L;
    private boolean shouldCloseOnCompletion = false;
    private SQLWarning warnings;
    private int fetchSize = 0;
    private ResultSet resultSet;

    protected Statement(Connection connection) {
        this.connection = connection;
        this.warnings = null;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void cancel() throws SQLException {
        this.verifyOpen();
        this.cancelQuery(false);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.verifyOpen();
        this.warnings = null;
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed.getAndSet(true)) {
            LOGGER.debug("Cancel any running queries.");
            try {
                this.cancelQuery(true);
            }
            catch (SQLException e) {
                LOGGER.warn("Error occurred while closing Statement. Failed to cancel running query: %s", (Object)e.getMessage());
            }
            if (this.resultSet != null) {
                LOGGER.debug("Close opened result set.");
                this.resultSet.close();
            }
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.verifyOpen();
        this.shouldCloseOnCompletion = true;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.resultSet = this.executeQuery(sql);
        return true;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.READ_ONLY, new Object[0]));
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.READ_ONLY, new Object[0]));
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.READ_ONLY, new Object[0]));
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.READ_ONLY, new Object[0]));
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.READ_ONLY, new Object[0]));
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.READ_ONLY, new Object[0]));
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.READ_ONLY, new Object[0]));
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.READ_ONLY, new Object[0]));
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.verifyOpen();
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.verifyOpen();
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.verifyOpen();
        if (direction != 1000) {
            throw SqlError.createSQLException(LOGGER, SqlState.FEATURE_NOT_SUPPORTED, SqlError.UNSUPPORTED_FETCH_DIRECTION, direction);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.verifyOpen();
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.verifyOpen();
        if (rows < 0) {
            throw SqlError.createSQLException(LOGGER, SqlState.DATA_EXCEPTION, SqlError.INVALID_FETCH_SIZE, rows);
        }
        this.fetchSize = rows;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.UNSUPPORTED_GENERATED_KEYS, new Object[0]));
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        this.verifyOpen();
        return this.largeMaxRows;
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.verifyOpen();
        if (max < 0L) {
            throw SqlError.createSQLException(LOGGER, SqlState.DATA_EXCEPTION, SqlError.INVALID_LARGE_MAX_ROWS_SIZE, max);
        }
        this.largeMaxRows = max;
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.verifyOpen();
        return -1L;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.verifyOpen();
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.verifyOpen();
        if (max < 0) {
            throw SqlError.createSQLException(LOGGER, SqlState.DATA_EXCEPTION, SqlError.INVALID_MAX_FIELD_SIZE, max);
        }
        this.maxFieldSize = max;
    }

    @Override
    public int getMaxRows() throws SQLException {
        long maxRows = this.getLargeMaxRows();
        if (maxRows > Integer.MAX_VALUE) {
            String warning = Warning.lookup(Warning.MAX_VALUE_TRUNCATED, maxRows, Integer.MAX_VALUE);
            LOGGER.warn(warning);
            this.addWarning(new SQLWarning(warning));
            return Integer.MAX_VALUE;
        }
        return (int)maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.setLargeMaxRows(max);
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.verifyOpen();
        if (2 != current && this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        return false;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.verifyOpen();
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.verifyOpen();
        return 1007;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.verifyOpen();
        return 2;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.verifyOpen();
        return 1003;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return (int)this.getLargeUpdateCount();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.verifyOpen();
        return this.warnings;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.verifyOpen();
        return this.shouldCloseOnCompletion;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.verifyOpen();
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.POOLING_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return null != iface && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(SqlError.lookup(SqlError.READ_ONLY, new Object[0]));
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.verifyOpen();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw SqlError.createSQLException(LOGGER, SqlState.DATA_EXCEPTION, SqlError.CANNOT_UNWRAP, iface.toString());
    }

    void addWarning(SQLWarning warning) {
        if (this.warnings == null) {
            this.warnings = warning;
        } else {
            this.warnings.setNextWarning(warning);
        }
    }

    protected void verifyOpen() throws SQLException {
        if (this.isClosed.get()) {
            throw SqlError.createSQLException(LOGGER, SqlState.DATA_EXCEPTION, SqlError.STMT_CLOSED, new Object[0]);
        }
    }

    protected abstract void cancelQuery(boolean var1) throws SQLException;
}

