/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import software.amazon.disco.agent.DiscoAgentTemplate;
import software.amazon.disco.agent.concurrent.ConcurrencySupport;
import software.amazon.disco.agent.config.AgentConfig;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.interception.InstallationError;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;
import software.amazon.disco.agent.metrics.DiscoAgentMetrics;
import software.amazon.disco.agent.plugin.PluginOutcome;

public class DiscoAgent {
    private static final String KILLSWITCH_FILENAME = "/disco.kill";
    private static boolean agentPresent = false;
    private static Logger log = LogManager.getLogger(DiscoAgent.class);

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        DiscoAgent.impl(agentArgs, instrumentation);
    }

    public static void agentmain(String agentArgs, Instrumentation instrumentation) {
        DiscoAgent.impl(agentArgs, instrumentation);
    }

    private static void impl(String agentArgs, Instrumentation instrumentation) {
        log.info("DiSCo(Agent) starting agent");
        if (agentPresent) {
            DiscoAgent.logUrgentMessage(Logger.Level.WARN, "Disco(Agent) detected that this Disco agent is already loaded. Refusing to load again to prevent potentially harmful repeated instrumentation.\nPlease double check the arguments passed to java, and any use of the Injector.loadAgent() methods to ensure that the agent is specified exactly once.\nThis instance of the Agent will now exit without side effects.");
            return;
        }
        agentPresent = true;
        DiscoAgentMetrics.setAgentStartTime();
        DiscoAgentTemplate agent = new DiscoAgentTemplate(agentArgs);
        AgentConfig config = agent.getConfig();
        if (config.getPluginPath() == null) {
            log.warn("DiSCo(Agent) no pluginPath configured, agent is effectively inert. Are you sure that's what you intended?");
        }
        String attemptedLocation = "unknown";
        try {
            URL agentClassUrl = ClassLoader.getSystemClassLoader().getResource("software/amazon/disco/agent/DiscoAgent.class");
            Path agentJarPath = Paths.get(agentClassUrl.getPath().replaceFirst("!.*", ""), new String[0]);
            Path agentFolderPath = agentJarPath.subpath(0, agentJarPath.getNameCount() - 1);
            File killswitchFile = new File(new URI(agentFolderPath + KILLSWITCH_FILENAME));
            attemptedLocation = killswitchFile.getAbsolutePath();
            if (killswitchFile.exists()) {
                DiscoAgent.logUrgentMessage(Logger.Level.WARN, "DiSCo(Agent) killswitch from " + attemptedLocation + " applied. This instance of the Agent will now exit without side effects.");
                return;
            }
        }
        catch (Exception e) {
            log.error("DiSCo(Agent) could not search for killswitch file - looked in the agent JAR location at " + attemptedLocation);
        }
        Collection<PluginOutcome> outcomes = agent.install(instrumentation, new LinkedHashSet<Installable>(new ConcurrencySupport().get()));
        DiscoAgent.dump(outcomes);
        DiscoAgent.check(outcomes);
        log.info("DiSCo(Agent) agent startup complete in " + DiscoAgentMetrics.getAgentUptime());
    }

    private static void dump(Collection<PluginOutcome> outcomes) {
        for (PluginOutcome outcome : outcomes) {
            StringBuilder builder = new StringBuilder();
            builder.append("DiSCo(Agent) Plugin name: ").append(outcome.name).append("\n");
            builder.append("\tPlugin ClassLoader: ").append((Object)outcome.classLoaderType).append("\n");
            if (outcome.initClass != null) {
                builder.append("\tInit: ").append(outcome.initClass.getName()).append("\n");
            }
            if (outcome.installables != null && !outcome.installables.isEmpty()) {
                ArrayList installableStrings = new ArrayList(outcome.installables.size());
                outcome.installables.forEach(i -> installableStrings.add(i.getClass().getName()));
                builder.append("\tInstallables: ").append(String.join((CharSequence)", ", installableStrings.toArray(new String[0]))).append("\n");
            }
            if (outcome.listeners != null && !outcome.listeners.isEmpty()) {
                ArrayList listenerStrings = new ArrayList(outcome.listeners.size());
                outcome.listeners.forEach(l -> listenerStrings.add(l.getClass().getName()));
                builder.append("\tListeners: ").append(String.join((CharSequence)", ", listenerStrings.toArray(new String[0]))).append("\n");
            }
            log.info(builder.toString());
        }
    }

    private static void check(Collection<PluginOutcome> outcomes) {
        boolean installationErrorsDetected = false;
        for (PluginOutcome outcome : outcomes) {
            for (InstallationError installationError : outcome.installationErrors) {
                installationErrorsDetected = true;
                DiscoAgent.logUrgentMessage(Logger.Level.ERROR, installationError.toString());
            }
        }
        if (installationErrorsDetected) {
            DiscoAgent.logUrgentMessage(Logger.Level.ERROR, "DiSCo(Agent): one or more Disco Installables failed to install");
        }
    }

    private static void logUrgentMessage(Logger.Level level, String message) {
        log.log(level, message);
        System.err.printf("[%s] %s\n", new Object[]{level, message});
    }
}

