/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.logging;

import java.util.HashMap;
import java.util.Map;
import software.amazon.disco.agent.logging.Logger;
import software.amazon.disco.agent.logging.LoggerFactory;

public class LogManager {
    private static final Map<String, LevelAwareDelegatingLogger> namedLoggers = new HashMap<String, LevelAwareDelegatingLogger>();
    private static Logger.Level minimumLevel = Logger.Level.INFO;
    private static int minimumLevelOrdinal = minimumLevel.ordinal();
    private static final int traceLevelOrdinal = Logger.Level.TRACE.ordinal();
    private static final int debugLevelOrdinal = Logger.Level.DEBUG.ordinal();
    private static LoggerFactory installedLoggerFactory = new NullLoggerFactory();

    public static void setMinimumLevel(Logger.Level level) {
        minimumLevel = level;
        minimumLevelOrdinal = level.ordinal();
    }

    public static Logger.Level getMinimumLevel() {
        return minimumLevel;
    }

    public static boolean isTraceEnabled() {
        return traceLevelOrdinal >= minimumLevelOrdinal;
    }

    public static boolean isDebugEnabled() {
        return debugLevelOrdinal >= minimumLevelOrdinal;
    }

    public static Logger getLogger(Class clazz) {
        if (namedLoggers.containsKey(clazz.getName())) {
            return namedLoggers.get(clazz.getName());
        }
        LevelAwareDelegatingLogger logger = new LevelAwareDelegatingLogger(installedLoggerFactory.createLogger(clazz));
        namedLoggers.put(clazz.getName(), logger);
        return logger;
    }

    public static void installLoggerFactory(LoggerFactory loggerFactory) {
        installedLoggerFactory = loggerFactory == null ? new NullLoggerFactory() : loggerFactory;
        for (Map.Entry<String, LevelAwareDelegatingLogger> entry : namedLoggers.entrySet()) {
            entry.getValue().setDelegate(loggerFactory.createLogger(entry.getKey()));
        }
    }

    private static class NullLoggerFactory
    implements LoggerFactory {
        static final NullLogger nullLogger = new NullLogger();

        private NullLoggerFactory() {
        }

        @Override
        public Logger createLogger(String name) {
            return nullLogger;
        }

        private static class NullLogger
        implements Logger {
            private NullLogger() {
            }

            @Override
            public void log(Logger.Level level, String message) {
            }

            @Override
            public void log(Logger.Level level, Throwable t) {
            }

            @Override
            public void log(Logger.Level level, String message, Throwable t) {
            }
        }
    }

    private static class LevelAwareDelegatingLogger
    implements Logger {
        Logger delegate;

        LevelAwareDelegatingLogger(Logger delegate) {
            this.delegate = delegate;
        }

        LevelAwareDelegatingLogger setDelegate(Logger delegate) {
            this.delegate = delegate;
            return this;
        }

        @Override
        public void log(Logger.Level level, String message) {
            if (level.ordinal() >= minimumLevel.ordinal()) {
                this.delegate.log(level, message);
            }
        }

        @Override
        public void log(Logger.Level level, Throwable t) {
            if (level.ordinal() >= minimumLevel.ordinal()) {
                this.delegate.log(level, t);
            }
        }

        @Override
        public void log(Logger.Level level, String message, Throwable t) {
            if (level.ordinal() >= minimumLevel.ordinal()) {
                this.delegate.log(level, message, t);
            }
        }
    }
}

